/*****
 * drawpath3.h
 *
 * Stores a path3 that has been added to a picture.
 *****/

#ifndef DRAWPATH3_H
#define DRAWPATH3_H

#include "drawelement.h"
#include "path3.h"

namespace camp {

class drawPath3 : public drawElement {
protected:
  const path3 g;
  bool straight;
  RGBAColour color;
  bool invisible;
  triple Min,Max;
  Triple *controls;
  string name;
public:
  drawPath3(path3 g, const pen&p, const string& name) :
    g(g), straight(g.piecewisestraight()), color(rgba(p)),
    invisible(p.invisible()), Min(g.min()), Max(g.max()), controls(NULL),
    name(name) {}
    
  drawPath3(const vm::array& t, const drawPath3 *s) :
    g(camp::transformed(t,s->g)), straight(s->straight), color(s->color),
    invisible(s->invisible), Min(g.min()), Max(g.max()), controls(NULL),
    name(s->name) {}
  
  virtual ~drawPath3() {
    if(controls) delete controls;
  }

  bool is3D() {return true;}
  
  void bounds(bbox3& B) {
    B.add(Min);
    B.add(Max);
  }
  
  void ratio(pair &b, double (*m)(double, double), bool &first) {
    pair z=g.ratio(m);
    if(first) {
      b=z;
      first=false;
    } else b=pair(m(b.getx(),z.getx()),m(b.gety(),z.gety()));
  }
  
  bool write(prcfile *out, unsigned int *count, vm::array *index,
             vm::array *origin);
  
  void render(GLUnurbs*, double, const triple&, const triple&, double,
              bool transparent);

  drawElement *transformed(const vm::array& t);
};

}

#endif
