/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.asn1.ber;

import com.android.apksig.internal.asn1.ber.BerDataValue;
import com.android.apksig.internal.asn1.ber.BerDataValueFormatException;
import com.android.apksig.internal.asn1.ber.BerDataValueReader;
import com.android.apksig.internal.asn1.ber.BerEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class InputStreamBerDataValueReader
implements BerDataValueReader {
    private final InputStream mIn;

    public InputStreamBerDataValueReader(InputStream in2) {
        if (in2 == null) {
            throw new NullPointerException("in == null");
        }
        this.mIn = in2;
    }

    @Override
    public BerDataValue readDataValue() throws BerDataValueFormatException {
        return InputStreamBerDataValueReader.readDataValue(this.mIn);
    }

    private static BerDataValue readDataValue(InputStream input) throws BerDataValueFormatException {
        RecordingInputStream in2 = new RecordingInputStream(input);
        try {
            int contentsOffsetInDataValue;
            int contentsLength;
            int firstIdentifierByte = in2.read();
            if (firstIdentifierByte == -1) {
                return null;
            }
            int tagNumber = InputStreamBerDataValueReader.readTagNumber(in2, firstIdentifierByte);
            int firstLengthByte = in2.read();
            if (firstLengthByte == -1) {
                throw new BerDataValueFormatException("Missing length");
            }
            boolean constructed = BerEncoding.isConstructed((byte)firstIdentifierByte);
            if ((firstLengthByte & 0x80) == 0) {
                contentsLength = InputStreamBerDataValueReader.readShortFormLength(firstLengthByte);
                contentsOffsetInDataValue = in2.getReadByteCount();
                InputStreamBerDataValueReader.skipDefiniteLengthContents(in2, contentsLength);
            } else if ((firstLengthByte & 0xFF) != 128) {
                contentsLength = InputStreamBerDataValueReader.readLongFormLength(in2, firstLengthByte);
                contentsOffsetInDataValue = in2.getReadByteCount();
                InputStreamBerDataValueReader.skipDefiniteLengthContents(in2, contentsLength);
            } else {
                contentsOffsetInDataValue = in2.getReadByteCount();
                contentsLength = constructed ? InputStreamBerDataValueReader.skipConstructedIndefiniteLengthContents(in2) : InputStreamBerDataValueReader.skipPrimitiveIndefiniteLengthContents(in2);
            }
            byte[] encoded = in2.getReadBytes();
            ByteBuffer encodedContents = ByteBuffer.wrap(encoded, contentsOffsetInDataValue, contentsLength);
            return new BerDataValue(ByteBuffer.wrap(encoded), encodedContents, BerEncoding.getTagClass((byte)firstIdentifierByte), constructed, tagNumber);
        }
        catch (IOException e11) {
            throw new BerDataValueFormatException("Failed to read data value", e11);
        }
    }

    private static int readTagNumber(InputStream in2, int firstIdentifierByte) throws IOException, BerDataValueFormatException {
        int tagNumber = BerEncoding.getTagNumber((byte)firstIdentifierByte);
        if (tagNumber == 31) {
            return InputStreamBerDataValueReader.readHighTagNumber(in2);
        }
        return tagNumber;
    }

    private static int readHighTagNumber(InputStream in2) throws IOException, BerDataValueFormatException {
        int b11;
        int result = 0;
        do {
            if ((b11 = in2.read()) == -1) {
                throw new BerDataValueFormatException("Truncated tag number");
            }
            if (result > 0xFFFFFF) {
                throw new BerDataValueFormatException("Tag number too large");
            }
            result <<= 7;
            result |= b11 & 0x7F;
        } while ((b11 & 0x80) != 0);
        return result;
    }

    private static int readShortFormLength(int firstLengthByte) {
        return firstLengthByte & 0x7F;
    }

    private static int readLongFormLength(InputStream in2, int firstLengthByte) throws IOException, BerDataValueFormatException {
        int byteCount = firstLengthByte & 0x7F;
        if (byteCount > 4) {
            throw new BerDataValueFormatException("Length too large: " + byteCount + " bytes");
        }
        int result = 0;
        for (int i11 = 0; i11 < byteCount; ++i11) {
            int b11 = in2.read();
            if (b11 == -1) {
                throw new BerDataValueFormatException("Truncated length");
            }
            if (result > 0x7FFFFF) {
                throw new BerDataValueFormatException("Length too large");
            }
            result <<= 8;
            result |= b11 & 0xFF;
        }
        return result;
    }

    private static void skipDefiniteLengthContents(InputStream in2, int len) throws IOException, BerDataValueFormatException {
        long bytesRead = 0L;
        while (len > 0) {
            int skipped = (int)in2.skip(len);
            if (skipped <= 0) {
                throw new BerDataValueFormatException("Truncated definite-length contents: " + bytesRead + " bytes read, " + len + " missing");
            }
            len -= skipped;
            bytesRead += (long)skipped;
        }
    }

    private static int skipPrimitiveIndefiniteLengthContents(InputStream in2) throws IOException, BerDataValueFormatException {
        boolean prevZeroByte = false;
        int bytesRead = 0;
        while (true) {
            int b11;
            if ((b11 = in2.read()) == -1) {
                throw new BerDataValueFormatException("Truncated indefinite-length contents: " + bytesRead + " bytes read");
            }
            if (++bytesRead < 0) {
                throw new BerDataValueFormatException("Indefinite-length contents too long");
            }
            if (b11 == 0) {
                if (prevZeroByte) {
                    return bytesRead - 2;
                }
                prevZeroByte = true;
                continue;
            }
            prevZeroByte = false;
        }
    }

    private static int skipConstructedIndefiniteLengthContents(RecordingInputStream in2) throws BerDataValueFormatException {
        BerDataValue dataValue;
        ByteBuffer encoded;
        int readByteCountBefore = in2.getReadByteCount();
        do {
            if ((dataValue = InputStreamBerDataValueReader.readDataValue(in2)) == null) {
                throw new BerDataValueFormatException("Truncated indefinite-length contents: " + (in2.getReadByteCount() - readByteCountBefore) + " bytes read");
            }
            if (in2.getReadByteCount() > 0) continue;
            throw new BerDataValueFormatException("Indefinite-length contents too long");
        } while ((encoded = dataValue.getEncoded()).remaining() != 2 || encoded.get(0) != 0 || encoded.get(1) != 0);
        return in2.getReadByteCount() - readByteCountBefore - 2;
    }

    private static class RecordingInputStream
    extends InputStream {
        private final InputStream mIn;
        private final ByteArrayOutputStream mBuf;

        private RecordingInputStream(InputStream in2) {
            this.mIn = in2;
            this.mBuf = new ByteArrayOutputStream();
        }

        public byte[] getReadBytes() {
            return this.mBuf.toByteArray();
        }

        public int getReadByteCount() {
            return this.mBuf.size();
        }

        @Override
        public int read() throws IOException {
            int b11 = this.mIn.read();
            if (b11 != -1) {
                this.mBuf.write(b11);
            }
            return b11;
        }

        @Override
        public int read(byte[] b11) throws IOException {
            int len = this.mIn.read(b11);
            if (len > 0) {
                this.mBuf.write(b11, 0, len);
            }
            return len;
        }

        @Override
        public int read(byte[] b11, int off, int len) throws IOException {
            if ((len = this.mIn.read(b11, off, len)) > 0) {
                this.mBuf.write(b11, off, len);
            }
            return len;
        }

        @Override
        public long skip(long n11) throws IOException {
            if (n11 <= 0L) {
                return this.mIn.skip(n11);
            }
            byte[] buf = new byte[4096];
            int len = this.mIn.read(buf, 0, (int)Math.min((long)buf.length, n11));
            if (len > 0) {
                this.mBuf.write(buf, 0, len);
            }
            return len < 0 ? 0L : (long)len;
        }

        @Override
        public int available() throws IOException {
            return super.available();
        }

        @Override
        public void close() throws IOException {
            super.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

