RabbitMQ `3.11.28` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).
This release series [goes out of community support on Dec 31, 2023](https://rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25 and supports Erlang versions up to `25.3.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/main/release-notes).
    

### Prometheus Plugin

#### Enhancements

 * Metric label values now escape certain non-ASCII characters.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#10196](https://github.com/rabbitmq/rabbitmq-server/pull/10196)


### Management Plugin

#### Bug Fixes

 * Reverted a change to `DELETE /api/queues/{vhost}/{name}` that allowed removal of
   exclusive queues and introduced unexpected side effects.

   GitHub issue: [#10189](https://github.com/rabbitmq/rabbitmq-server/pull/10189)

 * Avoid log noise when an HTTP API request is issued against a booting
   or very freshly booted node.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#10183](https://github.com/rabbitmq/rabbitmq-server/pull/10183)


### AWS Peer Discovery Plugin

#### Enhancements

 * Type spec and test corrections.
                        
   Contributed by @illotum (AWS).

   GitHub issue: [#10133](https://github.com/rabbitmq/rabbitmq-server/pull/10133)


## Dependency Upgrades

 None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.28.tar.xz`
instead of the source tarball produced by GitHub.
