(defun my-save-buffer()
  (interactive)
  (save-excursion
    (goto-char (point-min))
    (blank-trim-lines)
    (goto-char (point-max))
    (delete-blank-lines))
  (save-buffer))
  
(defun fixit ()
  (interactive)
  (while (< (point) (point-max))
    (end-of-line)
    (search-backward " ")
    (insert-char ?\  (- 32 (current-column)))
    (forward-line 1)))

(defun findit ()
  (interactive)
  (let ((end) (name))
    (forward-word 1)
    (setq end (point))
    (backward-word 1)
    (setq name (buffer-substring (point) end))
    (forward-line 1)
    (other-window 1)
    (goto-char (point-min))
    (re-search-forward (concat "\n" name " *[(]"))
    (forward-line -1)
    (beginning-of-line)
    (if (looking-at "^.*[/]")
	(insert "\n"))
    (insert "static ")
    (if (looking-at " *$")
	(insert "int"))
    (other-window 1)))

(defun wrapit ()
  "Wrap long C source code lines (such as those output by mkptypes) at
a comma." 
  (interactive)
  (while (< (point) (point-max))
    (end-of-line)
    (if (< 79 (current-column))
	(progn
	  (beginning-of-line)
	  (forward-char 79)
	  (search-backward ",")
	  (forward-char 1)
	  (insert "\n")
	  (tab-to-tab-stop))
      (forward-line 1))))
