#ifndef S_GNULINUX_H_
#define S_GNULINUX_H_

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifdef RCSID
#ifndef lint
static const char *s_gnulinux_rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/s-gnulinux.h,v 1.4 2005/05/31 18:34:42 beebe Exp beebe $";
#endif
#endif /* RCSID */

/*
 * s-gnulinux.h - configuration file for GNU/Linux (all CPU architectures)
 */

/*
 * The HOSTNAME macro is used only as a last resort, if no other way
 * of determining the hostname will work.  If you have a domain name,
 * i.e. there are dots in the official name of your host, include only
 * the first component of the name.
 */
#if 0
#define HOSTNAME "ourhost"		/* local hostname */
#endif

/*
 * If you have an official domain name for your host, and the domain name
 * is not discernible with gethostbyname(3), define LOCALDOMAIN
 * to be the name of your domain, preceded by a "."; otherwise, define
 * LOCALDOMAIN to be a null string.  For example, if the name of your host
 * is podunk.edu, you should specify:
 *	#define LOCALDOMAIN ".edu"
 * If your host is vax.cs.podunk.edu, you'd use
 *	#define LOCALDOMAIN ".cs.podunk.edu"
 */
#if 0
#define LOCALDOMAIN ".ourdomain.edu"	/* local domain */
#endif

/*
 * If your site likes to make outgoing mail appear as if it all comes
 * from one central host, define HIDDENNET as the name of that host.
 * Otherwise, leave HIDDENNET undefined.
 */
#if 0
#define HIDDENNET "mailhost.ourdomain.edu"	/* fake mail host name */
#endif

/*
 * If your operating system supports filenames longer than 14 characters,
 * I.e. you are running a Berkeley UNIX derivative, define HAVE_FLEXFILENAMES.
 * If you are running some sort of operating system which supports
 * long filenames only on remote filesystems (e.g. HP-UX 6.0), don't
 * define it.
 */
#define HAVE_FLEXFILENAMES		/* we have long filenames */

/*
 * If you have the Berkeley sendmail program, define SENDMAIL to be the
 * pathname by which it should be invoked.
 */
#define SENDMAIL "/usr/sbin/sendmail"	/* we have sendmail */

/*
 * Define SPOOL_DIRECTORY to be the name of the directory to which
 * new mail is delivered.  On System V-based systems, this is usually
 * /usr/mail; on Berkeley systems, it's usually /usr/spool/mail.
 */
#define SPOOL_DIRECTORY "/var/mail"

/*
 * If your mailer supports .forward files, and you want MM to display
 * the contents of .forward file (you may not wish to do this if it's
 * likely that a user's .forward file will be ignored because of conflicting
 * entries in /usr/lib/aliases), define FORWARD_FILE as the name of the
 * file in the user's home directory.
 */
#define FORWARD_FILE ".forward"		/* we use .forward files */

/*
 * If you have GNU Emacs, define GNUEMACS to be the name with which it
 * is usually referred by your users.  If GNUEMACS is not defined, special
 * code used to interface MM with GNU Emacs will not be compiled into MM.
 */
#define GNUEMACS "emacs"		/* we have GNU Emacs */

/*
 * If you have, and use, the Sun Yellow Pages facility, define
 * HAVE_YP.
 */
#define HAVE_YP				/* we use yp */

/*
 * If you have NFS and users will be referencing mail files on remote
 * filesystems, define HAVE_NFS.
 */
#define HAVE_NFS			/* we use NFS */

/*
 * Define one or more of NEED_FCNTL, NEED_UNISTD, and NEED_SYSFILE
 * as appropriate, depending on whether or not MM has to include
 * <fcntl.h>, <unistd.h>, and/or <sys/file.h> in order to obtain
 * the symbol definitions used in the open(2), fcntl(2), flock(2),
 * lockf(2), and lseek(2) system calls.
 */
#define NEED_FCNTL			/* include <fcntl.h> */
#define NEED_UNISTD			/* include <unistd.h> */
#define NEED_SYSFILE			/* include <sys/file.h> */

/*
 * You will probably need this, but you may want to undefine it if
 * another system header file includes it automatically.
 */
#define NEED_IOCTL			/* include <sys/ioctl.h> */

/*
 * MM needs to refer to definitions which may appear in either
 * <time.h> or <sys/time.h>, depending on what kind of system you have.
 * <time.h> usually contains the definition of the "tm" struct, while
 * on many BSD-based systems, <sys/time.h> will include the same information
 * in addition to the "timeval" and "timezone" structs.  Define one or
 * the other, or both, as appropriate.
 */
#define NEED_SYSTIME			/* include <sys/time.h> */
#define NEED_TIME			/* include <time.h> */

/*
 * Define NEED_WAIT if your system defines "union wait" in <sys/wait.h>
 * See also HAVE_WAIT3 below.
 */
#define NEED_WAIT			/* include <sys/wait.h> */

/*
 * Define HAVE_WAIT3 if your system has the wait3() system call.
 */
#define HAVE_WAIT3			/* we have wait3() */

/*
 * Define HAVE_JOBS if your system has job control.  Currently 4.2 job control
 * is the only type supported.
 */
#define HAVE_JOBS			/* we have job control */

/*
 * Define HAVE_BSD_SIGNALS if you have the 4.2BSD-style signal handling
 * facilities.
 */
#undef HAVE_BSD_SIGNALS			/* we don't have 4.2 signals */

/*
 * If you have support for disk quotas, and you use them, define HAVE_QUOTAS.
 * Otherwise leave it undefined.
 */
#undef HAVE_QUOTAS			/* we don't have quota support and use it */

/*
 * If you defined HAVE_QUOTAS above, define HAVE_QUOTACTL if your system
 * has quotactl(2) system call.  If this is defined, MM also expects to
 * find quota.h in <ufs/quota.h> rather than <sys/quota.h>.
 */
#undef HAVE_QUOTACTL			/* we don't have quotactl(), not quota() */

/*
 * Define HAVE_INDEX if your system has index(3) and rindex(3) rather than
 * than strchr(3) and strrchr(3).
 */
#undef HAVE_INDEX			/* we don't have index & rindex */

/*
 * Define HAVE_BSTRING if you have bcopy(3), bzero(3), and bcmp(3).  These
 * are usually present on BSD-based systems, and missing on older systems
 * where MM will use memcpy(3), memset(3), and memcmp(3).
 */
#undef HAVE_BSTRING			/* we don't have bcopy and friends */

/*
 * Define HAVE_VFORK if your system has the vfork(2) system call.
 */
#undef HAVE_VFORK			/* we don't have vfork() */

/*
 * Define HAVE_GETWD if you have getwd(2).  Most BSD-based systems should.
 */
#undef HAVE_GETWD			/* we don't have the bsd getwd() */

/*
 * Define HAVE_GETCWD if you have getcwd(3) rather than getwd(2).  This will
 * be true on most SYSV-based systems.
 */
#define HAVE_GETCWD			/* we have getcwd() */

/*
 * Define HAVE_GETHOSTNAME if you have the gethostname(2) system call, and
 * HAVE_GETHOSTBYNAME if you have get gethostbyxxxx(3) library routines.
 * This is generally true on BSD-based systems, and some SYSV systems.
 * They should be undefined if you either don't have them, or don't use
 * them (because they're broken?).
 */
#define	HAVE_GETHOSTNAME		/* we have gethostname() */
#define	HAVE_GETHOSTBYNAME		/* we have gethostbyname() */

/*
 * Define HAVE_UNAME if you don't have the gethostname(2) system call,
 * but you do have uname(2).  This is usually true on non-networked
 * SYSV systems.
 */
#define HAVE_UNAME			/* we have uname() */

/*
 * Define PHOSTNAME if you have neither gethostname(2) or uname(2).
 * It's value should be a string containing a UNIX command which will
 * print your system's hostname.
 */
#if 0
#define PHOSTNAME "uuname -l"	/* program that prints our hostname */
#endif

/*
 * Define HAVE_RENAME if you have the rename(2) system call, or an equivalent
 * C library routine.  This is true on later BSD releases and SVR3.
 */
#define HAVE_RENAME			/* we have rename() */

/*
 * Define one or more of the following symbols, depending on what file-
 * locking facilities are available on your system.  MM prefers the fcntl
 * locking facility, since lockf and flock don't work on remote files when
 * using NFS.
 *
 * If you have the fcntl facility for locking file regions, define
 * HAVE_F_SETLK (should be true of most systems with SVR2 (?) file locking).
 * If you have flock(2) (most BSD-based systems), define HAVE_FLOCK.
 * If you have lockf(2) (most SYSV systems), define HAVE_FLOCK.
 */
#undef HAVE_F_SETLK			/* fcntl locks file regions */
#undef HAVE_FLOCK			/* no flock locks whole files */
#undef HAVE_LOCKF			/* lockf don't works */

/*
 * If your /bin/mail program uses the flock(2) system call to prevent
 * simultaneous access to files in /usr/mail or /usr/spool/mail, define
 * MAIL_USE_FLOCK.  If this is not defined, the movemail program will
 * attempt to lock files in the spool directory using lock files.
 *
 * If you're not sure whether or not to define this symbol, you might
 * be able to find the answer by consulting the sources for /bin/mail
 * on your system, or looking in the appropriate s-*.h file from the
 * GNU Emacs distribution.  If you have the strings(1) program, you
 * can try "strings /usr/spool/mail" to see if any ".lock" files exist
 * there.
 */
#if 0
#define MAIL_USE_FLOCK	/* GNU/Linux /bin/mail uses flock(2) */
#endif

/*
 * Define HAVE_BSD_SETPGRP if your system's setpgrp() system call takes two
 * arguments.  This is generally true on later BSD releases with job control.
 * On some systems, there is both a SYSV setpgrp() call and a setpgrp2() call,
 * the latter of which takes two arguments like the BSD setpgrp() call.  If
 * that's true on your system, you should probably also add
 *	#define setpgrp setpgrp2
 * unless your system somehow figures this out automatically.
 */
#define HAVE_BSD_SETPGRP		/* setpgrp() takes two args */

/*
 * Define HAVE_VOIDSIG if your <signal.h> defines signal(2) as
 * void (*signal())(). This seems to be true in System V Release 3
 * and SunOS 5.0.
 */
#define HAVE_VOIDSIG			/* void (*signal())() */

/*
 * Define NEED_VFORK if we need to include <vfork.h>.
 */

#undef NEED_VFORK

/*
 * define volatile as static if your C compiler does not support the
 * "volatile" directive (ANSI C).
 */

/* #define volatile static */

#endif /* S_GNULINUX_H_ */
