#include "args.h"
#include <stdio.h>

extern char	*malloc ARGS((size_t));
extern void	abort (VOID);

#ifndef NULL
#define NULL 0
#endif

void *
#if HAVE_STDC
xmalloc (unsigned int size)
#else /* K&R style */
xmalloc (size)
  unsigned size;
#endif /* HAVE_STDC */
{
  char *new_mem = malloc (size); 
  
  if (new_mem == NULL)
    {
      fprintf (stderr, "xmalloc: request for %u bytes failed.\n", size);
      abort ();
    }

  return new_mem;
}
