#ifndef OSFILES_H_
#define OSFILES_H_

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifdef RCSID
#ifndef lint
static const char *osfiles_rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/osfiles.h,v 1.4 2005/05/31 14:43:11 beebe Exp beebe $";
#endif
#endif /* RCSID */

/*
 * This file pulls in most of the UNIX system header files needed by MM.
 * Include it after config.h, and before compat.h.
 */

#if (defined(__unix__) || defined(__unix)) && !defined(unix)
#define unix				/* we use "unix" throughout the code */
#endif

#ifndef stdin
#include <stdio.h>
#endif
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <errno.h>
#if !defined(HAVE_GNU_LINUX) && !defined(HAVE_NEW_BSD)
extern int sys_nerr;
extern char *sys_errlist[];
#endif

#ifdef NEED_IOCTL
#include <sys/ioctl.h>
#endif

#ifdef NEED_FCNTL
#include <fcntl.h>
#endif

#ifdef NEED_LIBC
#include <libc.h>
#endif

#ifdef NEED_UNISTD
#include <unistd.h>
#endif

#ifdef NEED_LIBC
#include <libc.h>		/* NeXT Mach's equivalent of unistd.h */
#endif

#ifdef NEED_SYSFILE
#include <sys/file.h>
#endif

#ifdef NEED_SYSTIME
#include <sys/time.h>
#endif

#ifdef NEED_TIME
#include <time.h>
#endif

#ifdef NEED_WAIT
#include <sys/wait.h>

#if defined(WUNTRACED) && !defined(WSTOPPED)
#define WSTOPPED WUNTRACED		/* some GNU/Linux systems have only WUNTRACED */
#endif

#endif

#ifdef NEED_VFORK
#include <vfork.h>
#endif

#include <signal.h>

#if HAVE_STDC
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#undef bzero
#define bzero(a,b)	memset((a),0,b)
#undef bcopy
/* Using memmove here because memcpy doesn't usually handle overlapping
   memory copies */
/* #define bcopy(a,b,c)	memcpy((b),(a),c) */
#define bcopy(a,b,c)	memmove((b),(a),c)
#undef bcmp
#define bcmp(a,b,c)	memcmp((a),(b),c)
#else
extern char *calloc ARGS((size_t, size_t));
extern char *getcwd ARGS((char *, size_t));
extern char *getenv ARGS((const char *));
extern char *getlogin ARGS((void));
extern char *getwd ARGS((void));
extern char *index ARGS((const char *,int));
extern char *malloc ARGS((size_t));
extern char *realloc ARGS((void *, size_t));
extern char *rindex ARGS((const char *,int));
extern char *strcpy ARGS((char *,const char *));
extern char *strchr ARGS((const char *,int));
extern char *strrchr ARGS((const char *,int));
extern int bcmp ARGS((char *,char *, int));
extern int dup ARGS((int));
extern void bcopy ARGS((char *,char *, int));
extern void bzero ARGS((char *,int));
extern void free ARGS((void *));
#endif

#if defined(__hpux) || defined(__osf__) || defined(__NeXT__)
#define setkey Setkey	/* avoid name collision with system encryption code */
#endif

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#define QSORT_FUN_TYPE int (*) ARGS((const void *, const void *))

#ifndef fileno
extern int fileno ARGS((FILE *));
#endif

/* The function are not declared in many UNIX __STDC__ environments */
extern int pclose ARGS((FILE *stream_));
extern FILE *fdopen ARGS((int, const char *));
extern FILE *popen ARGS((const char *, const char *));


#ifdef unix
#if defined(__NeXT__)
/* pwd.h cannot be included more than once, and ../ccmd/cmfnc.h includes it */
#else
#include <pwd.h>
#endif
#if !defined(HAVE_STDC)
extern struct passwd *getpwnam ARGS((const char *name_));
extern struct group *getgrgid ARGS((gid_t gid_));
#endif
#endif

#ifdef HAVE_GETHOSTNAME
/* Supply a prototype for gethostname() if system header files didn't do so */
#if !defined(__hpux) && !defined(HAVE_GNU_LINUX) && !defined(__osf__)
extern int gethostname ARGS((char *name_, int namelen_));
#endif
#endif

#if defined(_IBMR2)
#define truncate(path,length) (truncate)((char*)(path),(off_t)(length))
#endif

#if defined(__NeXT__)
#define execvp(file,argv) (execvp)((file),(const char **)(argv))
#define execv(path,argv)  (execv)((path),(const char **)(argv))
#endif

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* OSFILES_H_ */
