#include "args.h"

#include "config.h"
/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#include "mm.h"
#include "parse.h"

extern Setkey user_level;

/*
 * banner messages for different modes
 */
static const char *top_level_banner = "\n\
[ H=headers  R=read  REV=review  S=send   Q=quit  BYE  ?=Hints  HELP ]\n\
";

static const char *send_banner = "\n\
[ D=display  S=send  TE=text  ED=edit  TY=type   Q=quit  ?=Hints  HELP ]\n\
";

static const char *read_banner = "\n\
[ D=delete  H=header  R=reply  TY=type  PRI=print   Q=quit  ?=Hints  HELP ]\n\
";

/*
 * print out a banner message if the userlevel is novice.   the banner
 * depends on the current mode.
 */

#define mode mode_		/* avoid warnings about shadowed global */

void
#if HAVE_STDC
novice_banner(int mode)
#else /* K&R style */
novice_banner(mode)
int mode;
#endif /* HAVE_STDC */
{
    if (strcmp(user_level.current, "novice") != 0)
	return;
    switch(mode) {
    case MM_TOP_LEVEL:
	cmxprintf("%s", top_level_banner);
	break;
    case MM_SEND:
	cmxprintf("%s", send_banner);
	break;
    case MM_READ:
	cmxprintf("%s", read_banner);
	break;
    default:break;
    }
}
