# /usr/local/src/mm-0.90/mm/mkdep.awk, Tue Jun 28 21:36:38 1994
# Edit by Nelson H. F. Beebe <beebe@sunrise>
# ========================================================================
# Process a file of dependencies from "cc -M" or "cc -xM" or "cc -xM1"
# into a more compact equivalent for insertion in a Makefile.  This
# process is automated by "make depends".
#
# The input consists of lines of the form
#
#	filename.o: filename.c
#	filename.o: anotherfile.h
#	...
#
# Usage:
#	make depends
# or
#	cc -M ... *.c | sort | nawk -f mkdep.awk [ MAXLENGTH=nnn ]
#
# The command-line variable MAXLENGTH sets the output line length limit.
# The default value of 79 is normally adequate.
#
# This version makes two special substitutions
#
#	../ccmd -> $(CCMD)
#	s-*.h   -> $(SFILE)
#
# in order to obtain a machine-independent dependency list for the
# mm Makefile.  The field widths in formats and length checks below
# have been adjusted to suit the filename sizes in the mm Makefile,
# so as to obtain neatly ordered columns of output.
#
# [28-Jun-1994]
# ========================================================================
BEGIN {
    FS = ":"
    if (MAXLENGTH == 0) MAXLENGTH = 79
}
{
    gsub(/[ \t]/,"")
    if ($2 ~ /s-[a-z0-9]+[.]h/) $2 = "$(SFILE)"
    if ($2 ~ /^\.\.\/ccmd\//) $2 = "$(CCMD)" substr($2,8)
    if ($1 == last) # same LHS filename as previous line
    {
	if ((length(line) + 17) <= (MAXLENGTH - 2))
	    line = sprintf("%s%-17s",line,$2)
	else
	{
	    print line " \\"
	    line = sprintf("%-18s%-17s"," ",$2)
	}
    }
    else # LHS filename has changed
    {
	if (line != "") print trim(line) "\n"
        line = sprintf("%-18s%-17s",$1 ": ",$2)
    }
    last = $1
}
END   {
    print trim(line)
}

function trim(s, t)
{
    t = s
    sub(/[ \t]+$/,"",t)
    return (t)
}
