#include "args.h"

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifndef lint
static const char *rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/formattab.c,v 1.1 2005/05/28 22:27:51 beebe Exp $";
#endif

/*
 * a keyword table of the different formats we handle
 */

#include "mm.h"
#include "parse.h"
#include "rd.h"

/*
 * this has to stay in alphabetical order too,
 * or they won't line up, will they?
 */
static keywrd formatkeys[] = {
    { "babyl",	0,	(keyval) TYPE_BABYL },
    { "mbox",	0,	(keyval) TYPE_MBOX },
    { "mh",	KEY_INV|KEY_NOR, (keyval) TYPE_MH },
    { "mtxt",	0,	(keyval) TYPE_MTXT },
    { "pop2",	KEY_INV|KEY_NOR, (keyval) TYPE_POP2 },
    { "pop3",	KEY_INV|KEY_NOR, (keyval) TYPE_POP3 },
  };

keytab formattab = { (sizeof(formatkeys)/sizeof(keywrd)), formatkeys };

/*
 * default mail file names for different formats
 * must be kept in same order as formatkeys, above
 */
const char *defmailfile[] = {
    "~/RMAIL", "~/mbox", "~/mh??", "~/mail.txt", "~/pop2??", "~/pop3??",
};
