#include "args.h"

#include "config.h"
/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifndef lint
static const char *rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/action.c,v 1.2 2005/05/28 22:39:23 beebe Exp $";
#endif

#include "mm.h"
#include "parse.h"
#include "cmfncs.h"
#include "acttab.h"

#define brk brk_	/* avoid warnings about conflict with brk() */
#define atmbuf atmbuf_	/* avoid warnings about conflict with global atmbuf */

extern int (*(stdact[128])) ARGS((fdb *fdblist, int brk, int deferred));
extern int control_l_confirm;
extern int user_aborted;
extern jmp_buf abortbuf;

int allow_aborts;

static int (*(mmact[128])) ARGS((fdb *fdblist, int brk, int deferred));
static int mm_abortact ARGS((fdb *fdblist, int brk, int deferred));
static int mm_clsact ARGS((fdb *fdblist, int brk, int deferred));

/*
 * set up special action characters for MM.
 */

acttab
mmactini(VOID)
{
    bcopy(stdact, mmact, sizeof(mmact));
    mmact[(int) '\f'] = mm_clsact;
    mmact[(int) '\016'] = mm_abortact;
    return ((acttab)mmact);
}

static int
#if HAVE_STDC
mm_clsact(fdb *fdblist, int brk, int deferred)
#else /* K&R style */
mm_clsact(fdblist,brk,deferred)
fdb *fdblist;
int brk;
int deferred;
#endif /* HAVE_STDC */
{
  if (control_l_confirm) {
      return ((*stdact[brk])(fdblist, brk, deferred));
  }
  cmxcls();	 	  	    	/* clear the screen for a formfeed */
  return(fixact(fdblist,brk,deferred));	/* refresh the line */
}

static int
#if HAVE_STDC
mm_abortact(fdb *fdblist, int brk, int deferred)
#else /* K&R style */
mm_abortact(fdblist,brk,deferred)
fdb *fdblist;
int brk;
int deferred;
#endif /* HAVE_STDC */
{
    int cmdbuf[200];
    char atmbuf[200], wrkbuf[200];

    if (deferred)
	return(CMxDFR);

    if (!allow_aborts) {
	return(nextact(fdblist,brk,deferred));
    }

    if (control_n_abort == SET_ALWAYS) {
	user_aborted = true;
	longjmp (abortbuf, 1);
    }
    if (control_n_abort == SET_NEVER) {
	cmsti1 (brk, 0);
	return CMxOK;
    }
    else {				/* set control-n-abort ask */
	csb oldcsb;
	save_parse_context();
	oldcsb = cmcsb;
	cmbufs (cmdbuf, sizeof cmdbuf, atmbuf, sizeof atmbuf,
		wrkbuf, sizeof wrkbuf);
	cmact (nil);
	user_aborted = yesno("Abort? ", "yes");
	cmcsb = oldcsb;
	cmcsb._cmcol = 0;
	restore_parse_context();
	if (user_aborted)
	    longjmp (abortbuf, 1);
	fixact (fdblist, brk, 0);
	return (CMxOK);
    }
}

/*
 * redisplay_line:
 * simulate a ^R
 */
void
redisplay_line (VOID)
{
    fixact ((fdb*)NULL, 0, 0);		/* doesn't use any args */
}
