#ifndef SITE_H_
#define SITE_H_

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.

*/

/*
 * Define HAVE_VOIDSIG if your <signal.h> defines signal(2) as
 * void (*signal())(). This seems to be true in System V Release 3
 * and SunOS 4.0.
 */

#if defined(SVR3)
#  define HAVE_VOIDSIG
#endif

#if defined(sun) || defined(__sun)
#  undef needTERMIO		/* SunOS and Solaris both have sgtty.h */
				/* and we need values defined there */
#  if defined(__solaris)
#    define needTERMIOS		/* and in termios.h */
#    define BSD_COMP		/* to get CRMOD from <sys/ioctl.h> */
#  endif
#endif

#if defined(__unix) && !defined(unix)
#  define unix	1	/* Standard C compilers on UNIX don't define unix */
#endif

#if !defined(needUNISTD)
#  if unix || defined(_POSIX_SOURCE)
#    define needUNISTD	1 /* almost all UNIXes have this POSIX.1 header file */
#  endif
#endif

#endif /* SITE_H_ */
