#ifndef MACHDEP_H_
#define MACHDEP_H_

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.

*/
/*
 * This file contains conditional compilation directives describing the
 * presence or absence of certain common features which are not unique
 * to any one generic environment.
 *
 * Machine dependencies which need to be reflected in the compilation
 * of ccmd applications should go into ccmdmd.h.
 */

/* One of these needs to be defined... */
/* #define DIRLIB */		/* e.g. 4.2bsd */
/* #define NDIRLIB */		/* e.g. hp-ux */
/* #define DIRENTLIB */		/* e.g. posix? */
/* #define NODIRLIB */		/* e.g. v7 */

/* completion is slow when using Sun's YP facility */
/* #define NO_USERNAME_COMPLETION */
/* #define NO_GROUP_COMPLETION */

#include "site.h"

#ifdef BSD
#undef BSTRING
#define BSTRING
#endif

#ifdef SYSV
#define bzero(a,b)	memset((a),0,b)
/* Using memmove here because memcpy doesn't usually handle overlapping
   memory copies */
/* #define bcopy(a,b,c)	memcpy((b),(a),c) */
#define bcopy(a,b,c)	memmove((b),(a),c)
#define bcmp(a,b,c)	memcmp((a),(b),c)
#undef BSTRING
#define BSTRING
#endif

#if defined(__osf__)
#undef BSTRING
#endif

#if defined(_IBMR2)
#undef BSTRING
#endif

#if !defined(DIRLIB) && !defined(NDIRLIB) && !defined(DIRENTLIB)
#  ifndef NODIRLIB
#    if BSD
#      define DIRLIB
#    else
#      if hpux || __hpux
#        define NDIRLIB
#      else
#	 if AIX || __sgi
#	   define DIRENTLIB
#	 else
#          define NODIRLIB
#	 endif
#      endif
#    endif
#  endif
#endif

#if defined(HAVE_VOIDSIG)
#define SIG void
#else
#define SIG int
#endif

#if defined(__sgi) && defined(_LANGUAGE_C_PLUS_PLUS)
	/* SGI C++ <sys/signal.h> has irregular signal() arguments */
typedef SIG (*Sigval) ARGS((_sigargs));
#else
typedef SIG (*Sigval) ARGS((int));
#endif

extern int	mkstemp ARGS((char *));

#if defined(__NeXT__)
#define pid_t int
#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif
extern int	close ARGS((int));
extern uid_t	geteuid (VOID);
extern int	getgroups ARGS((int, int *));
extern char*	getlogin (VOID);
extern int	getpid (VOID);
extern uid_t	getuid (VOID);
extern int	ioctl ARGS((int fildes, int op, ...));
extern int	isatty ARGS((int));
extern char*	mktemp ARGS((char *));
extern int	open ARGS((const char *, int, ...));
extern int	read ARGS((int, void *, int));
extern int	select ARGS((int, fd_set *, fd_set *, fd_set *, struct timeval *));
extern char*	ttyname ARGS((int));
extern int	unlink ARGS((const char *));
extern int	write ARGS((int, const void *, int));
#if defined(__cplusplus) || defined(c_plusplus)
}
#endif /* defined(__cplusplus) || defined(c_plusplus) */
#endif /* defined(__NeXT__) */

#if defined(_IBMR2)
/* IBM RS/6000 AIX 3.x header files are missing several prototypes that
   we need for GNU g++ compilation */
#if defined(__GNUG__)
#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif
extern int 	ioctl ARGS((int fildes, int op, ...));
extern char*	mktemp ARGS((char *));

#if defined(AIX3)
extern void	setpwent(VOID);
extern void	endpwent(VOID);
extern void	gettimeofday ARGS((struct timeval *, struct timezone *));
#endif /* defined(AIX3) */

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif /* defined(__cplusplus) || defined(c_plusplus) */
#endif /* defined(__GNUG__) */

#endif /* _IBMR2 */

#endif /* MACHDEP_H_ */
