; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+m -mattr=+v -O2 < %s \
; RUN:    | FileCheck --check-prefix=SPILL-O2 %s

define <vscale x 1 x i32> @test_vector_std(<vscale x 1 x i32> %va) nounwind {
; SPILL-O2-LABEL: test_vector_std:
; SPILL-O2:       # %bb.0: # %entry
; SPILL-O2-NEXT:    addi sp, sp, -16
; SPILL-O2-NEXT:    csrr a0, vlenb
; SPILL-O2-NEXT:    slli a0, a0, 1
; SPILL-O2-NEXT:    sub sp, sp, a0
; SPILL-O2-NEXT:    addi a0, sp, 16
; SPILL-O2-NEXT:    vs1r.v v8, (a0) # Unknown-size Folded Spill
; SPILL-O2-NEXT:    #APP
; SPILL-O2-NEXT:    #NO_APP
; SPILL-O2-NEXT:    vl1r.v v8, (a0) # Unknown-size Folded Reload
; SPILL-O2-NEXT:    csrr a0, vlenb
; SPILL-O2-NEXT:    slli a0, a0, 1
; SPILL-O2-NEXT:    add sp, sp, a0
; SPILL-O2-NEXT:    addi sp, sp, 16
; SPILL-O2-NEXT:    ret
entry:
  call void asm sideeffect "",
  "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9},~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19},~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29},~{v30},~{v31}"()

  ret <vscale x 1 x i32> %va
}

define riscv_vector_cc <vscale x 1 x i32> @test_vector_callee(<vscale x 1 x i32> %va) nounwind {
; SPILL-O2-LABEL: test_vector_callee:
; SPILL-O2:       # %bb.0: # %entry
; SPILL-O2-NEXT:    addi sp, sp, -16
; SPILL-O2-NEXT:    csrr a0, vlenb
; SPILL-O2-NEXT:    slli a0, a0, 4
; SPILL-O2-NEXT:    sub sp, sp, a0
; SPILL-O2-NEXT:    csrr a0, vlenb
; SPILL-O2-NEXT:    slli a1, a0, 4
; SPILL-O2-NEXT:    sub a0, a1, a0
; SPILL-O2-NEXT:    add a0, sp, a0
; SPILL-O2-NEXT:    addi a0, a0, 16
; SPILL-O2-NEXT:    vs1r.v v1, (a0) # Unknown-size Folded Spill
; SPILL-O2-NEXT:    csrr a0, vlenb
; SPILL-O2-NEXT:    li a1, 13
; SPILL-O2-NEXT:    mul a0, a0, a1
; SPILL-O2-NEXT:    add a0, sp, a0
; SPILL-O2-NEXT:    addi a0, a0, 16
; SPILL-O2-NEXT:    vs2r.v v2, (a0) # Unknown-size Folded Spill
; SPILL-O2-NEXT:    csrr a0, vlenb
; SPILL-O2-NEXT:    slli a1, a0, 3
; SPILL-O2-NEXT:    add a0, a1, a0
; SPILL-O2-NEXT:    add a0, sp, a0
; SPILL-O2-NEXT:    addi a0, a0, 16
; SPILL-O2-NEXT:    vs4r.v v4, (a0) # Unknown-size Folded Spill
; SPILL-O2-NEXT:    csrr a0, vlenb
; SPILL-O2-NEXT:    add a0, sp, a0
; SPILL-O2-NEXT:    addi a0, a0, 16
; SPILL-O2-NEXT:    vs8r.v v24, (a0) # Unknown-size Folded Spill
; SPILL-O2-NEXT:    addi a0, sp, 16
; SPILL-O2-NEXT:    vs1r.v v8, (a0) # Unknown-size Folded Spill
; SPILL-O2-NEXT:    #APP
; SPILL-O2-NEXT:    #NO_APP
; SPILL-O2-NEXT:    vl1r.v v8, (a0) # Unknown-size Folded Reload
; SPILL-O2-NEXT:    csrr a0, vlenb
; SPILL-O2-NEXT:    slli a1, a0, 4
; SPILL-O2-NEXT:    sub a0, a1, a0
; SPILL-O2-NEXT:    add a0, sp, a0
; SPILL-O2-NEXT:    addi a0, a0, 16
; SPILL-O2-NEXT:    vl1r.v v1, (a0) # Unknown-size Folded Reload
; SPILL-O2-NEXT:    csrr a0, vlenb
; SPILL-O2-NEXT:    li a1, 13
; SPILL-O2-NEXT:    mul a0, a0, a1
; SPILL-O2-NEXT:    add a0, sp, a0
; SPILL-O2-NEXT:    addi a0, a0, 16
; SPILL-O2-NEXT:    vl2r.v v2, (a0) # Unknown-size Folded Reload
; SPILL-O2-NEXT:    csrr a0, vlenb
; SPILL-O2-NEXT:    slli a1, a0, 3
; SPILL-O2-NEXT:    add a0, a1, a0
; SPILL-O2-NEXT:    add a0, sp, a0
; SPILL-O2-NEXT:    addi a0, a0, 16
; SPILL-O2-NEXT:    vl4r.v v4, (a0) # Unknown-size Folded Reload
; SPILL-O2-NEXT:    csrr a0, vlenb
; SPILL-O2-NEXT:    add a0, sp, a0
; SPILL-O2-NEXT:    addi a0, a0, 16
; SPILL-O2-NEXT:    vl8r.v v24, (a0) # Unknown-size Folded Reload
; SPILL-O2-NEXT:    csrr a0, vlenb
; SPILL-O2-NEXT:    slli a0, a0, 4
; SPILL-O2-NEXT:    add sp, sp, a0
; SPILL-O2-NEXT:    addi sp, sp, 16
; SPILL-O2-NEXT:    ret
entry:
  call void asm sideeffect "",
  "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9},~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19},~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29},~{v30},~{v31}"()

  ret <vscale x 1 x i32> %va
}

; Make sure the local stack allocation pass doesn't count vector registers. The
; sizes are chosen to be on the edge of what RISCVRegister::needsFrameBaseReg
; considers to need a virtual base register.
define riscv_vector_cc void @local_stack_allocation_frame_pointer() "frame-pointer"="all" {
; SPILL-O2-LABEL: local_stack_allocation_frame_pointer:
; SPILL-O2:       # %bb.0:
; SPILL-O2-NEXT:    addi sp, sp, -2032
; SPILL-O2-NEXT:    .cfi_def_cfa_offset 2032
; SPILL-O2-NEXT:    sw ra, 2028(sp) # 4-byte Folded Spill
; SPILL-O2-NEXT:    sw s0, 2024(sp) # 4-byte Folded Spill
; SPILL-O2-NEXT:    .cfi_offset ra, -4
; SPILL-O2-NEXT:    .cfi_offset s0, -8
; SPILL-O2-NEXT:    addi s0, sp, 2032
; SPILL-O2-NEXT:    .cfi_def_cfa s0, 0
; SPILL-O2-NEXT:    addi sp, sp, -480
; SPILL-O2-NEXT:    lbu a0, -1912(s0)
; SPILL-O2-NEXT:    sb a0, -1912(s0)
; SPILL-O2-NEXT:    addi sp, s0, -2048
; SPILL-O2-NEXT:    addi sp, sp, -464
; SPILL-O2-NEXT:    addi sp, sp, 480
; SPILL-O2-NEXT:    lw ra, 2028(sp) # 4-byte Folded Reload
; SPILL-O2-NEXT:    lw s0, 2024(sp) # 4-byte Folded Reload
; SPILL-O2-NEXT:    addi sp, sp, 2032
; SPILL-O2-NEXT:    ret
  %va = alloca [2500 x i8], align 4
  %va_gep = getelementptr [2000 x i8], ptr %va, i64 0, i64 600
  %load = load volatile i8, ptr %va_gep, align 4
  store volatile i8 %load, ptr %va_gep, align 4
  ret void
}
