; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=aarch64 -mattr=+sve2 -verify-machineinstrs %s -o - | FileCheck %s

define <vscale x 2 x i64> @add_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: add_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    add z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = add <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @add_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: add_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    add z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = add <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @add_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: add_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    add z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = add <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @add_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: add_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    add z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = add <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @sub_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: sub_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    sub z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = sub <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @sub_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: sub_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    sub z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = sub <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @sub_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: sub_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    sub z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = sub <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @sub_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: sub_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    sub z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = sub <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @mul_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: mul_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    mul z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = mul <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @mul_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: mul_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    mul z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = mul <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @mul_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: mul_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    mul z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = mul <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @mul_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: mul_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    mul z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = mul <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @sdiv_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: sdiv_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    sdivr z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    mov z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = sdiv <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @sdiv_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: sdiv_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sdivr z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = sdiv <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @sdiv_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: sdiv_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sunpkhi z3.s, z1.h
; CHECK-NEXT:    sunpkhi z4.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    sdivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    sunpklo z4.s, z0.h
; CHECK-NEXT:    sdivr z1.s, p0/m, z1.s, z4.s
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    uzp1 z1.h, z1.h, z3.h
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = sdiv <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @sdiv_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: sdiv_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sunpkhi z3.h, z1.b
; CHECK-NEXT:    sunpkhi z4.h, z0.b
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sunpklo z1.h, z1.b
; CHECK-NEXT:    sunpkhi z5.s, z3.h
; CHECK-NEXT:    sunpkhi z6.s, z4.h
; CHECK-NEXT:    sunpklo z3.s, z3.h
; CHECK-NEXT:    sunpklo z4.s, z4.h
; CHECK-NEXT:    sdivr z5.s, p0/m, z5.s, z6.s
; CHECK-NEXT:    sunpkhi z6.s, z1.h
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    sdivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    sunpklo z4.h, z0.b
; CHECK-NEXT:    sunpkhi z7.s, z4.h
; CHECK-NEXT:    sunpklo z4.s, z4.h
; CHECK-NEXT:    sdivr z6.s, p0/m, z6.s, z7.s
; CHECK-NEXT:    uzp1 z3.h, z3.h, z5.h
; CHECK-NEXT:    sdivr z1.s, p0/m, z1.s, z4.s
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    uzp1 z1.h, z1.h, z6.h
; CHECK-NEXT:    uzp1 z1.b, z1.b, z3.b
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = sdiv <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @udiv_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: udiv_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    udivr z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    mov z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = udiv <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @udiv_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: udiv_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    udivr z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = udiv <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @udiv_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: udiv_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uunpkhi z3.s, z1.h
; CHECK-NEXT:    uunpkhi z4.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    udivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    uunpklo z4.s, z0.h
; CHECK-NEXT:    udivr z1.s, p0/m, z1.s, z4.s
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    uzp1 z1.h, z1.h, z3.h
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = udiv <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @udiv_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: udiv_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uunpkhi z3.h, z1.b
; CHECK-NEXT:    uunpkhi z4.h, z0.b
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uunpklo z1.h, z1.b
; CHECK-NEXT:    uunpkhi z5.s, z3.h
; CHECK-NEXT:    uunpkhi z6.s, z4.h
; CHECK-NEXT:    uunpklo z3.s, z3.h
; CHECK-NEXT:    uunpklo z4.s, z4.h
; CHECK-NEXT:    udivr z5.s, p0/m, z5.s, z6.s
; CHECK-NEXT:    uunpkhi z6.s, z1.h
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    udivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    uunpklo z4.h, z0.b
; CHECK-NEXT:    uunpkhi z7.s, z4.h
; CHECK-NEXT:    uunpklo z4.s, z4.h
; CHECK-NEXT:    udivr z6.s, p0/m, z6.s, z7.s
; CHECK-NEXT:    uzp1 z3.h, z3.h, z5.h
; CHECK-NEXT:    udivr z1.s, p0/m, z1.s, z4.s
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    uzp1 z1.h, z1.h, z6.h
; CHECK-NEXT:    uzp1 z1.b, z1.b, z3.b
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = udiv <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @srem_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: srem_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    sdiv z3.d, p0/m, z3.d, z1.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    mls z0.d, p0/m, z3.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = srem <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @srem_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: srem_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    sdiv z3.s, p0/m, z3.s, z1.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    mls z0.s, p0/m, z3.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = srem <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @srem_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: srem_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sunpkhi z3.s, z1.h
; CHECK-NEXT:    sunpkhi z4.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sunpklo z5.s, z0.h
; CHECK-NEXT:    sdivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    sunpklo z4.s, z1.h
; CHECK-NEXT:    sdivr z4.s, p0/m, z4.s, z5.s
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    uzp1 z2.h, z4.h, z3.h
; CHECK-NEXT:    mls z0.h, p0/m, z2.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = srem <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @srem_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: srem_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sunpkhi z3.h, z1.b
; CHECK-NEXT:    sunpkhi z4.h, z0.b
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sunpkhi z5.s, z3.h
; CHECK-NEXT:    sunpkhi z6.s, z4.h
; CHECK-NEXT:    sunpklo z3.s, z3.h
; CHECK-NEXT:    sunpklo z4.s, z4.h
; CHECK-NEXT:    sdivr z5.s, p0/m, z5.s, z6.s
; CHECK-NEXT:    sunpklo z6.h, z0.b
; CHECK-NEXT:    sunpkhi z24.s, z6.h
; CHECK-NEXT:    sunpklo z6.s, z6.h
; CHECK-NEXT:    sdivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    sunpklo z4.h, z1.b
; CHECK-NEXT:    sunpkhi z7.s, z4.h
; CHECK-NEXT:    sunpklo z4.s, z4.h
; CHECK-NEXT:    sdivr z7.s, p0/m, z7.s, z24.s
; CHECK-NEXT:    uzp1 z3.h, z3.h, z5.h
; CHECK-NEXT:    sdivr z4.s, p0/m, z4.s, z6.s
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    uzp1 z4.h, z4.h, z7.h
; CHECK-NEXT:    uzp1 z2.b, z4.b, z3.b
; CHECK-NEXT:    mls z0.b, p0/m, z2.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = srem <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @urem_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: urem_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    udiv z3.d, p0/m, z3.d, z1.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    mls z0.d, p0/m, z3.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = urem <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @urem_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: urem_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    udiv z3.s, p0/m, z3.s, z1.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    mls z0.s, p0/m, z3.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = urem <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @urem_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: urem_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uunpkhi z3.s, z1.h
; CHECK-NEXT:    uunpkhi z4.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uunpklo z5.s, z0.h
; CHECK-NEXT:    udivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    uunpklo z4.s, z1.h
; CHECK-NEXT:    udivr z4.s, p0/m, z4.s, z5.s
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    uzp1 z2.h, z4.h, z3.h
; CHECK-NEXT:    mls z0.h, p0/m, z2.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = urem <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @urem_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: urem_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uunpkhi z3.h, z1.b
; CHECK-NEXT:    uunpkhi z4.h, z0.b
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uunpkhi z5.s, z3.h
; CHECK-NEXT:    uunpkhi z6.s, z4.h
; CHECK-NEXT:    uunpklo z3.s, z3.h
; CHECK-NEXT:    uunpklo z4.s, z4.h
; CHECK-NEXT:    udivr z5.s, p0/m, z5.s, z6.s
; CHECK-NEXT:    uunpklo z6.h, z0.b
; CHECK-NEXT:    uunpkhi z24.s, z6.h
; CHECK-NEXT:    uunpklo z6.s, z6.h
; CHECK-NEXT:    udivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    uunpklo z4.h, z1.b
; CHECK-NEXT:    uunpkhi z7.s, z4.h
; CHECK-NEXT:    uunpklo z4.s, z4.h
; CHECK-NEXT:    udivr z7.s, p0/m, z7.s, z24.s
; CHECK-NEXT:    uzp1 z3.h, z3.h, z5.h
; CHECK-NEXT:    udivr z4.s, p0/m, z4.s, z6.s
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    uzp1 z4.h, z4.h, z7.h
; CHECK-NEXT:    uzp1 z2.b, z4.b, z3.b
; CHECK-NEXT:    mls z0.b, p0/m, z2.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = urem <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @and_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: and_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    and z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = and <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @and_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: and_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    and z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = and <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @and_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: and_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    and z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = and <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @and_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: and_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    and z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = and <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @or_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: or_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    orr z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = or <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @or_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: or_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    orr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = or <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @or_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: or_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    orr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = or <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @or_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: or_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    orr z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = or <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @xor_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: xor_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    eor z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = xor <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @xor_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: xor_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    eor z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = xor <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @xor_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: xor_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    eor z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = xor <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @xor_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: xor_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    eor z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = xor <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @shl_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: shl_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p1.d, p0/z, z2.d, #0
; CHECK-NEXT:    lslr z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, p1/m, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = shl <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @shl_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: shl_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p1.s, p0/z, z2.s, #0
; CHECK-NEXT:    lslr z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.s, p1/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = shl <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @shl_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: shl_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p1.h, p0/z, z2.h, #0
; CHECK-NEXT:    lslr z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.h, p1/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = shl <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @shl_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: shl_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p1.b, p0/z, z2.b, #0
; CHECK-NEXT:    lslr z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.b, p1/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = shl <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @ashr_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: ashr_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p1.d, p0/z, z2.d, #0
; CHECK-NEXT:    asrr z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, p1/m, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = ashr <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @ashr_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: ashr_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p1.s, p0/z, z2.s, #0
; CHECK-NEXT:    asrr z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.s, p1/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = ashr <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @ashr_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: ashr_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p1.h, p0/z, z2.h, #0
; CHECK-NEXT:    asrr z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.h, p1/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = ashr <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @ashr_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: ashr_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p1.b, p0/z, z2.b, #0
; CHECK-NEXT:    asrr z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.b, p1/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = ashr <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @lshr_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: lshr_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p1.d, p0/z, z2.d, #0
; CHECK-NEXT:    lsrr z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, p1/m, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = lshr <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @lshr_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: lshr_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p1.s, p0/z, z2.s, #0
; CHECK-NEXT:    lsrr z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.s, p1/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = lshr <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @lshr_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: lshr_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p1.h, p0/z, z2.h, #0
; CHECK-NEXT:    lsrr z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.h, p1/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = lshr <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @lshr_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: lshr_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p1.b, p0/z, z2.b, #0
; CHECK-NEXT:    lsrr z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.b, p1/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = lshr <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @mla_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %z, <vscale x 2 x i64> %n) {
; CHECK-LABEL: mla_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z3.d, #0
; CHECK-NEXT:    mla z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %m = mul <vscale x 2 x i64> %y, %z
  %a = add <vscale x 2 x i64> %x, %m
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @mla_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %z, <vscale x 4 x i32> %n) {
; CHECK-LABEL: mla_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z3.s, #0
; CHECK-NEXT:    mla z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %m = mul <vscale x 4 x i32> %y, %z
  %a = add <vscale x 4 x i32> %x, %m
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @mla_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %z, <vscale x 8 x i16> %n) {
; CHECK-LABEL: mla_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z3.h, #0
; CHECK-NEXT:    mla z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %m = mul <vscale x 8 x i16> %y, %z
  %a = add <vscale x 8 x i16> %x, %m
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @mla_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %z, <vscale x 16 x i8> %n) {
; CHECK-LABEL: mla_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z3.b, #0
; CHECK-NEXT:    mla z0.b, p0/m, z1.b, z2.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %m = mul <vscale x 16 x i8> %y, %z
  %a = add <vscale x 16 x i8> %x, %m
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @mls_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %z, <vscale x 2 x i64> %n) {
; CHECK-LABEL: mls_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z3.d, #0
; CHECK-NEXT:    msb z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %m = mul <vscale x 2 x i64> %x, %y
  %a = sub <vscale x 2 x i64> %z, %m
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @mls_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %z, <vscale x 4 x i32> %n) {
; CHECK-LABEL: mls_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z3.s, #0
; CHECK-NEXT:    msb z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %m = mul <vscale x 4 x i32> %x, %y
  %a = sub <vscale x 4 x i32> %z, %m
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @mls_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %z, <vscale x 8 x i16> %n) {
; CHECK-LABEL: mls_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z3.h, #0
; CHECK-NEXT:    msb z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %m = mul <vscale x 8 x i16> %x, %y
  %a = sub <vscale x 8 x i16> %z, %m
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @mls_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %z, <vscale x 16 x i8> %n) {
; CHECK-LABEL: mls_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z3.b, #0
; CHECK-NEXT:    msb z0.b, p0/m, z1.b, z2.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %m = mul <vscale x 16 x i8> %x, %y
  %a = sub <vscale x 16 x i8> %z, %m
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x float> @fadd_nxv4f32_x(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fadd_nxv4f32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = fadd <vscale x 4 x float> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %x
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fadd_nxv8f16_x(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fadd_nxv8f16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = fadd <vscale x 8 x half> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %x
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fadd_nxv2f64_x(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fadd_nxv2f64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = fadd <vscale x 2 x double> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %x
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fsub_nxv4f32_x(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fsub_nxv4f32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fsub z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = fsub <vscale x 4 x float> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %x
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fsub_nxv8f16_x(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fsub_nxv8f16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fsub z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = fsub <vscale x 8 x half> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %x
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fsub_nxv2f64_x(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fsub_nxv2f64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fsub z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = fsub <vscale x 2 x double> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %x
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fmul_nxv4f32_x(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fmul_nxv4f32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmul z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = fmul <vscale x 4 x float> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %x
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fmul_nxv8f16_x(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fmul_nxv8f16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmul z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = fmul <vscale x 8 x half> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %x
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fmul_nxv2f64_x(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fmul_nxv2f64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmul z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = fmul <vscale x 2 x double> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %x
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fdiv_nxv4f32_x(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fdiv_nxv4f32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fdivr z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = fdiv <vscale x 4 x float> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %x
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fdiv_nxv8f16_x(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fdiv_nxv8f16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fdivr z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = fdiv <vscale x 8 x half> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %x
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fdiv_nxv2f64_x(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fdiv_nxv2f64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fdivr z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    mov z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = fdiv <vscale x 2 x double> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %x
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @minnum_nxv4f32_x(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: minnum_nxv4f32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fminnm z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = call <vscale x 4 x float> @llvm.minnum.nxv4f32(<vscale x 4 x float> %x, <vscale x 4 x float> %y)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %x
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @minnum_nxv8f16_x(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: minnum_nxv8f16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fminnm z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = call <vscale x 8 x half> @llvm.minnum.nxv8f16(<vscale x 8 x half> %x, <vscale x 8 x half> %y)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %x
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @minnum_nxv2f64_x(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: minnum_nxv2f64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fminnm z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = call <vscale x 2 x double> @llvm.minnum.nxv2f64(<vscale x 2 x double> %x, <vscale x 2 x double> %y)
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %x
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @maxnum_nxv4f32_x(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: maxnum_nxv4f32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmaxnm z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = call <vscale x 4 x float> @llvm.maxnum.nxv4f32(<vscale x 4 x float> %x, <vscale x 4 x float> %y)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %x
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @maxnum_nxv8f16_x(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: maxnum_nxv8f16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmaxnm z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = call <vscale x 8 x half> @llvm.maxnum.nxv8f16(<vscale x 8 x half> %x, <vscale x 8 x half> %y)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %x
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @maxnum_nxv2f64_x(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: maxnum_nxv2f64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmaxnm z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = call <vscale x 2 x double> @llvm.maxnum.nxv2f64(<vscale x 2 x double> %x, <vscale x 2 x double> %y)
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %x
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @minimum_nxv4f32_x(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: minimum_nxv4f32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = call <vscale x 4 x float> @llvm.minimum.nxv4f32(<vscale x 4 x float> %x, <vscale x 4 x float> %y)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %x
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @minimum_nxv8f16_x(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: minimum_nxv8f16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = call <vscale x 8 x half> @llvm.minimum.nxv8f16(<vscale x 8 x half> %x, <vscale x 8 x half> %y)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %x
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @minimum_nxv2f64_x(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: minimum_nxv2f64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = call <vscale x 2 x double> @llvm.minimum.nxv2f64(<vscale x 2 x double> %x, <vscale x 2 x double> %y)
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %x
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @maximum_nxv4f32_x(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: maximum_nxv4f32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = call <vscale x 4 x float> @llvm.maximum.nxv4f32(<vscale x 4 x float> %x, <vscale x 4 x float> %y)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %x
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @maximum_nxv8f16_x(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: maximum_nxv8f16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = call <vscale x 8 x half> @llvm.maximum.nxv8f16(<vscale x 8 x half> %x, <vscale x 8 x half> %y)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %x
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @maximum_nxv2f64_x(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: maximum_nxv2f64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = call <vscale x 2 x double> @llvm.maximum.nxv2f64(<vscale x 2 x double> %x, <vscale x 2 x double> %y)
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %x
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fmai_nxv4f32_x(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %z, <vscale x 4 x float> %n) {
; CHECK-LABEL: fmai_nxv4f32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z3.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmla z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = call <vscale x 4 x float> @llvm.fma.nxv4f32(<vscale x 4 x float> %y, <vscale x 4 x float> %z, <vscale x 4 x float> %x)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %x
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fmai_nxv8f16_x(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %z, <vscale x 8 x half> %n) {
; CHECK-LABEL: fmai_nxv8f16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z3.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmla z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = call <vscale x 8 x half> @llvm.fma.nxv8f16(<vscale x 8 x half> %y, <vscale x 8 x half> %z, <vscale x 8 x half> %x)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %x
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fmai_nxv2f64_x(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %z, <vscale x 2 x double> %n) {
; CHECK-LABEL: fmai_nxv2f64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z3.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmla z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = call <vscale x 2 x double> @llvm.fma.nxv2f64(<vscale x 2 x double> %y, <vscale x 2 x double> %z, <vscale x 2 x double> %x)
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %x
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fma_nxv4f32_x(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %z, <vscale x 4 x float> %n) {
; CHECK-LABEL: fma_nxv4f32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z3.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmla z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %m = fmul fast <vscale x 4 x float> %y, %z
  %a = fadd fast <vscale x 4 x float> %m, %x
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %x
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fma_nxv8f16_x(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %z, <vscale x 8 x half> %n) {
; CHECK-LABEL: fma_nxv8f16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z3.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmla z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %m = fmul fast <vscale x 8 x half> %y, %z
  %a = fadd fast <vscale x 8 x half> %m, %x
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %x
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fma_nxv2f64_x(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %z, <vscale x 2 x double> %n) {
; CHECK-LABEL: fma_nxv2f64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z3.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmla z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %m = fmul fast <vscale x 2 x double> %y, %z
  %a = fadd fast <vscale x 2 x double> %m, %x
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %x
  ret <vscale x 2 x double> %b
}

define <vscale x 2 x i64> @add_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: add_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    add z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = add <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @add_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: add_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    add z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = add <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @add_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: add_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    add z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = add <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @add_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: add_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    add z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = add <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @sub_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: sub_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    sub z0.d, z0.d, z1.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = sub <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @sub_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: sub_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sub z0.s, z0.s, z1.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = sub <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @sub_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: sub_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    sub z0.h, z0.h, z1.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = sub <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @sub_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: sub_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    sub z0.b, z0.b, z1.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    sel z0.b, p0, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = sub <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @mul_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: mul_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    mul z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = mul <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @mul_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: mul_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    mul z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = mul <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @mul_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: mul_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    mul z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = mul <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @mul_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: mul_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    mul z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = mul <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @sdiv_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: sdiv_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    sdiv z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = sdiv <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @sdiv_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: sdiv_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = sdiv <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @sdiv_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: sdiv_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sunpkhi z3.s, z1.h
; CHECK-NEXT:    sunpkhi z4.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sdivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    sunpklo z4.s, z1.h
; CHECK-NEXT:    sdiv z0.s, p0/m, z0.s, z4.s
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    uzp1 z0.h, z0.h, z3.h
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = sdiv <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @sdiv_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: sdiv_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sunpkhi z3.h, z1.b
; CHECK-NEXT:    sunpkhi z4.h, z0.b
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sunpklo z0.h, z0.b
; CHECK-NEXT:    sunpkhi z5.s, z3.h
; CHECK-NEXT:    sunpkhi z6.s, z4.h
; CHECK-NEXT:    sunpklo z3.s, z3.h
; CHECK-NEXT:    sunpklo z4.s, z4.h
; CHECK-NEXT:    sunpkhi z7.s, z0.h
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sdivr z5.s, p0/m, z5.s, z6.s
; CHECK-NEXT:    sdivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    sunpklo z4.h, z1.b
; CHECK-NEXT:    sunpkhi z6.s, z4.h
; CHECK-NEXT:    sunpklo z4.s, z4.h
; CHECK-NEXT:    sdivr z6.s, p0/m, z6.s, z7.s
; CHECK-NEXT:    uzp1 z3.h, z3.h, z5.h
; CHECK-NEXT:    sdiv z0.s, p0/m, z0.s, z4.s
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    uzp1 z0.h, z0.h, z6.h
; CHECK-NEXT:    uzp1 z0.b, z0.b, z3.b
; CHECK-NEXT:    sel z0.b, p0, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = sdiv <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @udiv_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: udiv_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    udiv z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = udiv <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @udiv_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: udiv_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    udiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = udiv <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @udiv_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: udiv_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uunpkhi z3.s, z1.h
; CHECK-NEXT:    uunpkhi z4.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    udivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    uunpklo z4.s, z1.h
; CHECK-NEXT:    udiv z0.s, p0/m, z0.s, z4.s
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    uzp1 z0.h, z0.h, z3.h
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = udiv <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @udiv_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: udiv_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uunpkhi z3.h, z1.b
; CHECK-NEXT:    uunpkhi z4.h, z0.b
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpkhi z5.s, z3.h
; CHECK-NEXT:    uunpkhi z6.s, z4.h
; CHECK-NEXT:    uunpklo z3.s, z3.h
; CHECK-NEXT:    uunpklo z4.s, z4.h
; CHECK-NEXT:    uunpkhi z7.s, z0.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    udivr z5.s, p0/m, z5.s, z6.s
; CHECK-NEXT:    udivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    uunpklo z4.h, z1.b
; CHECK-NEXT:    uunpkhi z6.s, z4.h
; CHECK-NEXT:    uunpklo z4.s, z4.h
; CHECK-NEXT:    udivr z6.s, p0/m, z6.s, z7.s
; CHECK-NEXT:    uzp1 z3.h, z3.h, z5.h
; CHECK-NEXT:    udiv z0.s, p0/m, z0.s, z4.s
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    uzp1 z0.h, z0.h, z6.h
; CHECK-NEXT:    uzp1 z0.b, z0.b, z3.b
; CHECK-NEXT:    sel z0.b, p0, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = udiv <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @srem_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: srem_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    sdiv z3.d, p0/m, z3.d, z1.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    msb z1.d, p0/m, z3.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = srem <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @srem_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: srem_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    sdiv z3.s, p0/m, z3.s, z1.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    msb z1.s, p0/m, z3.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = srem <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @srem_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: srem_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sunpkhi z3.s, z1.h
; CHECK-NEXT:    sunpkhi z4.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sunpklo z5.s, z0.h
; CHECK-NEXT:    sdivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    sunpklo z4.s, z1.h
; CHECK-NEXT:    sdivr z4.s, p0/m, z4.s, z5.s
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    uzp1 z2.h, z4.h, z3.h
; CHECK-NEXT:    msb z1.h, p0/m, z2.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = srem <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @srem_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: srem_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sunpkhi z3.h, z1.b
; CHECK-NEXT:    sunpkhi z4.h, z0.b
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sunpkhi z5.s, z3.h
; CHECK-NEXT:    sunpkhi z6.s, z4.h
; CHECK-NEXT:    sunpklo z3.s, z3.h
; CHECK-NEXT:    sunpklo z4.s, z4.h
; CHECK-NEXT:    sdivr z5.s, p0/m, z5.s, z6.s
; CHECK-NEXT:    sunpklo z6.h, z0.b
; CHECK-NEXT:    sunpkhi z24.s, z6.h
; CHECK-NEXT:    sunpklo z6.s, z6.h
; CHECK-NEXT:    sdivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    sunpklo z4.h, z1.b
; CHECK-NEXT:    sunpkhi z7.s, z4.h
; CHECK-NEXT:    sunpklo z4.s, z4.h
; CHECK-NEXT:    sdivr z7.s, p0/m, z7.s, z24.s
; CHECK-NEXT:    uzp1 z3.h, z3.h, z5.h
; CHECK-NEXT:    sdivr z4.s, p0/m, z4.s, z6.s
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    uzp1 z4.h, z4.h, z7.h
; CHECK-NEXT:    uzp1 z2.b, z4.b, z3.b
; CHECK-NEXT:    msb z1.b, p0/m, z2.b, z0.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = srem <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @urem_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: urem_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    udiv z3.d, p0/m, z3.d, z1.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    msb z1.d, p0/m, z3.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = urem <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @urem_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: urem_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    udiv z3.s, p0/m, z3.s, z1.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    msb z1.s, p0/m, z3.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = urem <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @urem_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: urem_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uunpkhi z3.s, z1.h
; CHECK-NEXT:    uunpkhi z4.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uunpklo z5.s, z0.h
; CHECK-NEXT:    udivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    uunpklo z4.s, z1.h
; CHECK-NEXT:    udivr z4.s, p0/m, z4.s, z5.s
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    uzp1 z2.h, z4.h, z3.h
; CHECK-NEXT:    msb z1.h, p0/m, z2.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = urem <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @urem_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: urem_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uunpkhi z3.h, z1.b
; CHECK-NEXT:    uunpkhi z4.h, z0.b
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uunpkhi z5.s, z3.h
; CHECK-NEXT:    uunpkhi z6.s, z4.h
; CHECK-NEXT:    uunpklo z3.s, z3.h
; CHECK-NEXT:    uunpklo z4.s, z4.h
; CHECK-NEXT:    udivr z5.s, p0/m, z5.s, z6.s
; CHECK-NEXT:    uunpklo z6.h, z0.b
; CHECK-NEXT:    uunpkhi z24.s, z6.h
; CHECK-NEXT:    uunpklo z6.s, z6.h
; CHECK-NEXT:    udivr z3.s, p0/m, z3.s, z4.s
; CHECK-NEXT:    uunpklo z4.h, z1.b
; CHECK-NEXT:    uunpkhi z7.s, z4.h
; CHECK-NEXT:    uunpklo z4.s, z4.h
; CHECK-NEXT:    udivr z7.s, p0/m, z7.s, z24.s
; CHECK-NEXT:    uzp1 z3.h, z3.h, z5.h
; CHECK-NEXT:    udivr z4.s, p0/m, z4.s, z6.s
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    uzp1 z4.h, z4.h, z7.h
; CHECK-NEXT:    uzp1 z2.b, z4.b, z3.b
; CHECK-NEXT:    msb z1.b, p0/m, z2.b, z0.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = urem <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @and_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: and_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    and z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = and <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @and_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: and_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    and z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = and <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @and_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: and_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    and z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = and <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @and_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: and_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    and z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = and <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @or_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: or_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    orr z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = or <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @or_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: or_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    orr z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = or <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @or_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: or_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    orr z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = or <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @or_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: or_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    orr z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = or <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @xor_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: xor_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    eor z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = xor <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @xor_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: xor_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    eor z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = xor <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @xor_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: xor_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    eor z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = xor <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @xor_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: xor_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    eor z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = xor <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @shl_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: shl_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p1.d, p0/z, z2.d, #0
; CHECK-NEXT:    lsl z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    sel z0.d, p1, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = shl <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @shl_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: shl_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p1.s, p0/z, z2.s, #0
; CHECK-NEXT:    lsl z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    sel z0.s, p1, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = shl <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @shl_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: shl_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p1.h, p0/z, z2.h, #0
; CHECK-NEXT:    lsl z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    sel z0.h, p1, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = shl <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @shl_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: shl_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p1.b, p0/z, z2.b, #0
; CHECK-NEXT:    lsl z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    sel z0.b, p1, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = shl <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @ashr_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: ashr_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p1.d, p0/z, z2.d, #0
; CHECK-NEXT:    asr z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    sel z0.d, p1, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = ashr <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @ashr_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: ashr_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p1.s, p0/z, z2.s, #0
; CHECK-NEXT:    asr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    sel z0.s, p1, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = ashr <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @ashr_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: ashr_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p1.h, p0/z, z2.h, #0
; CHECK-NEXT:    asr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    sel z0.h, p1, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = ashr <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @ashr_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: ashr_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p1.b, p0/z, z2.b, #0
; CHECK-NEXT:    asr z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    sel z0.b, p1, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = ashr <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @lshr_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: lshr_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p1.d, p0/z, z2.d, #0
; CHECK-NEXT:    lsr z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    sel z0.d, p1, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = lshr <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @lshr_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: lshr_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p1.s, p0/z, z2.s, #0
; CHECK-NEXT:    lsr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    sel z0.s, p1, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = lshr <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @lshr_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: lshr_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p1.h, p0/z, z2.h, #0
; CHECK-NEXT:    lsr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    sel z0.h, p1, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = lshr <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @lshr_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: lshr_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p1.b, p0/z, z2.b, #0
; CHECK-NEXT:    lsr z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    sel z0.b, p1, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = lshr <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @mla_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %z, <vscale x 2 x i64> %n) {
; CHECK-LABEL: mla_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z3.d, #0
; CHECK-NEXT:    mad z1.d, p0/m, z2.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %m = mul <vscale x 2 x i64> %y, %z
  %a = add <vscale x 2 x i64> %x, %m
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @mla_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %z, <vscale x 4 x i32> %n) {
; CHECK-LABEL: mla_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z3.s, #0
; CHECK-NEXT:    mad z1.s, p0/m, z2.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %m = mul <vscale x 4 x i32> %y, %z
  %a = add <vscale x 4 x i32> %x, %m
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @mla_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %z, <vscale x 8 x i16> %n) {
; CHECK-LABEL: mla_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z3.h, #0
; CHECK-NEXT:    mad z1.h, p0/m, z2.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %m = mul <vscale x 8 x i16> %y, %z
  %a = add <vscale x 8 x i16> %x, %m
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @mla_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %z, <vscale x 16 x i8> %n) {
; CHECK-LABEL: mla_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z3.b, #0
; CHECK-NEXT:    mad z1.b, p0/m, z2.b, z0.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %m = mul <vscale x 16 x i8> %y, %z
  %a = add <vscale x 16 x i8> %x, %m
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @mls_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %z, <vscale x 2 x i64> %n) {
; CHECK-LABEL: mls_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z3.d, #0
; CHECK-NEXT:    msb z1.d, p0/m, z0.d, z2.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %m = mul <vscale x 2 x i64> %x, %y
  %a = sub <vscale x 2 x i64> %z, %m
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @mls_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %z, <vscale x 4 x i32> %n) {
; CHECK-LABEL: mls_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z3.s, #0
; CHECK-NEXT:    msb z1.s, p0/m, z0.s, z2.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %m = mul <vscale x 4 x i32> %x, %y
  %a = sub <vscale x 4 x i32> %z, %m
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @mls_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %z, <vscale x 8 x i16> %n) {
; CHECK-LABEL: mls_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z3.h, #0
; CHECK-NEXT:    msb z1.h, p0/m, z0.h, z2.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %m = mul <vscale x 8 x i16> %x, %y
  %a = sub <vscale x 8 x i16> %z, %m
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @mls_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %z, <vscale x 16 x i8> %n) {
; CHECK-LABEL: mls_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z3.b, #0
; CHECK-NEXT:    msb z1.b, p0/m, z0.b, z2.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %m = mul <vscale x 16 x i8> %x, %y
  %a = sub <vscale x 16 x i8> %z, %m
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x float> @fadd_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fadd_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fadd z0.s, z0.s, z1.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = fadd <vscale x 4 x float> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fadd_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fadd_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fadd z0.h, z0.h, z1.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = fadd <vscale x 8 x half> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fadd_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fadd_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fadd z0.d, z0.d, z1.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = fadd <vscale x 2 x double> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %y
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fsub_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fsub_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fsub z0.s, z0.s, z1.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = fsub <vscale x 4 x float> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fsub_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fsub_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fsub z0.h, z0.h, z1.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = fsub <vscale x 8 x half> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fsub_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fsub_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fsub z0.d, z0.d, z1.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = fsub <vscale x 2 x double> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %y
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fmul_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fmul_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fmul z0.s, z0.s, z1.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = fmul <vscale x 4 x float> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fmul_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fmul_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fmul z0.h, z0.h, z1.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = fmul <vscale x 8 x half> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fmul_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fmul_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fmul z0.d, z0.d, z1.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = fmul <vscale x 2 x double> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %y
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fdiv_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fdiv_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = fdiv <vscale x 4 x float> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fdiv_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fdiv_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fdiv z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = fdiv <vscale x 8 x half> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fdiv_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fdiv_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fdiv z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = fdiv <vscale x 2 x double> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %y
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @minnum_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: minnum_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fminnm z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = call <vscale x 4 x float> @llvm.minnum.nxv4f32(<vscale x 4 x float> %x, <vscale x 4 x float> %y)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @minnum_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: minnum_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fminnm z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = call <vscale x 8 x half> @llvm.minnum.nxv8f16(<vscale x 8 x half> %x, <vscale x 8 x half> %y)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @minnum_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: minnum_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fminnm z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = call <vscale x 2 x double> @llvm.minnum.nxv2f64(<vscale x 2 x double> %x, <vscale x 2 x double> %y)
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %y
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @maxnum_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: maxnum_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmaxnm z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = call <vscale x 4 x float> @llvm.maxnum.nxv4f32(<vscale x 4 x float> %x, <vscale x 4 x float> %y)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @maxnum_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: maxnum_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmaxnm z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = call <vscale x 8 x half> @llvm.maxnum.nxv8f16(<vscale x 8 x half> %x, <vscale x 8 x half> %y)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @maxnum_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: maxnum_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmaxnm z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = call <vscale x 2 x double> @llvm.maxnum.nxv2f64(<vscale x 2 x double> %x, <vscale x 2 x double> %y)
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %y
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @minimum_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: minimum_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmin z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = call <vscale x 4 x float> @llvm.minimum.nxv4f32(<vscale x 4 x float> %x, <vscale x 4 x float> %y)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @minimum_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: minimum_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmin z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = call <vscale x 8 x half> @llvm.minimum.nxv8f16(<vscale x 8 x half> %x, <vscale x 8 x half> %y)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @minimum_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: minimum_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmin z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = call <vscale x 2 x double> @llvm.minimum.nxv2f64(<vscale x 2 x double> %x, <vscale x 2 x double> %y)
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %y
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @maximum_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: maximum_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmax z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = call <vscale x 4 x float> @llvm.maximum.nxv4f32(<vscale x 4 x float> %x, <vscale x 4 x float> %y)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @maximum_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: maximum_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmax z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = call <vscale x 8 x half> @llvm.maximum.nxv8f16(<vscale x 8 x half> %x, <vscale x 8 x half> %y)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @maximum_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: maximum_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmax z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = call <vscale x 2 x double> @llvm.maximum.nxv2f64(<vscale x 2 x double> %x, <vscale x 2 x double> %y)
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %y
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fmai_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %z, <vscale x 4 x float> %n) {
; CHECK-LABEL: fmai_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z3.s, #0.0
; CHECK-NEXT:    fmla z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = call <vscale x 4 x float> @llvm.fma.nxv4f32(<vscale x 4 x float> %y, <vscale x 4 x float> %z, <vscale x 4 x float> %x)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fmai_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %z, <vscale x 8 x half> %n) {
; CHECK-LABEL: fmai_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z3.h, #0.0
; CHECK-NEXT:    fmla z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = call <vscale x 8 x half> @llvm.fma.nxv8f16(<vscale x 8 x half> %y, <vscale x 8 x half> %z, <vscale x 8 x half> %x)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fmai_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %z, <vscale x 2 x double> %n) {
; CHECK-LABEL: fmai_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z3.d, #0.0
; CHECK-NEXT:    fmla z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = call <vscale x 2 x double> @llvm.fma.nxv2f64(<vscale x 2 x double> %y, <vscale x 2 x double> %z, <vscale x 2 x double> %x)
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %y
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fma_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %z, <vscale x 4 x float> %n) {
; CHECK-LABEL: fma_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z3.s, #0.0
; CHECK-NEXT:    fmla z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %m = fmul fast <vscale x 4 x float> %y, %z
  %a = fadd fast <vscale x 4 x float> %m, %x
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fma_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %z, <vscale x 8 x half> %n) {
; CHECK-LABEL: fma_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z3.h, #0.0
; CHECK-NEXT:    fmla z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %m = fmul fast <vscale x 8 x half> %y, %z
  %a = fadd fast <vscale x 8 x half> %m, %x
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fma_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %z, <vscale x 2 x double> %n) {
; CHECK-LABEL: fma_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z3.d, #0.0
; CHECK-NEXT:    fmla z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %m = fmul fast <vscale x 2 x double> %y, %z
  %a = fadd fast <vscale x 2 x double> %m, %x
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %y
  ret <vscale x 2 x double> %b
}


define <vscale x 4 x i32> @mul_use_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n, ptr %p) {
; CHECK-LABEL: mul_use_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mul z1.s, z0.s, z1.s
; CHECK-NEXT:    cmpgt p1.s, p0/z, z2.s, #0
; CHECK-NEXT:    st1w { z1.s }, p0, [x0]
; CHECK-NEXT:    mov z0.s, p1/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = mul <vscale x 4 x i32> %x, %y
  store <vscale x 4 x i32> %a, ptr %p
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

declare <vscale x 2 x double> @llvm.fma.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.fma.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 8 x half> @llvm.fma.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 2 x double> @llvm.minnum.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.minnum.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 8 x half> @llvm.minnum.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 2 x double> @llvm.maxnum.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.maxnum.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 8 x half> @llvm.maxnum.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 2 x double> @llvm.minimum.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.minimum.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 8 x half> @llvm.minimum.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 2 x double> @llvm.maximum.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.maximum.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 8 x half> @llvm.maximum.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>)
