; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefixes=CHECK,SSE
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=avx | FileCheck %s --check-prefixes=CHECK,AVX
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=avx512f | FileCheck %s --check-prefixes=CHECK,AVX

define i64 @testmsxs(float %x) {
; SSE-LABEL: testmsxs:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvtss2si %xmm0, %rax
; SSE-NEXT:    retq
;
; AVX-LABEL: testmsxs:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvtss2si %xmm0, %rax
; AVX-NEXT:    retq
entry:
  %0 = tail call i64 @llvm.lrint.i64.f32(float %x)
  ret i64 %0
}

define i64 @testmsxd(double %x) {
; SSE-LABEL: testmsxd:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvtsd2si %xmm0, %rax
; SSE-NEXT:    retq
;
; AVX-LABEL: testmsxd:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvtsd2si %xmm0, %rax
; AVX-NEXT:    retq
entry:
  %0 = tail call i64 @llvm.lrint.i64.f64(double %x)
  ret i64 %0
}

define i64 @testmsll(x86_fp80 %x) {
; CHECK-LABEL: testmsll:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fldt {{[0-9]+}}(%rsp)
; CHECK-NEXT:    fistpll -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movq -{{[0-9]+}}(%rsp), %rax
; CHECK-NEXT:    retq
entry:
  %0 = tail call i64 @llvm.lrint.i64.f80(x86_fp80 %x)
  ret i64 %0
}

declare i64 @llvm.lrint.i64.f32(float) nounwind readnone
declare i64 @llvm.lrint.i64.f64(double) nounwind readnone
declare i64 @llvm.lrint.i64.f80(x86_fp80) nounwind readnone
