; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX512,AVX512BW

declare <1 x i8> @llvm.sadd.sat.v1i8(<1 x i8>, <1 x i8>)
declare <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8>, <2 x i8>)
declare <4 x i8> @llvm.sadd.sat.v4i8(<4 x i8>, <4 x i8>)
declare <8 x i8> @llvm.sadd.sat.v8i8(<8 x i8>, <8 x i8>)
declare <12 x i8> @llvm.sadd.sat.v12i8(<12 x i8>, <12 x i8>)
declare <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8>, <16 x i8>)
declare <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8>, <32 x i8>)
declare <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8>, <64 x i8>)

declare <1 x i16> @llvm.sadd.sat.v1i16(<1 x i16>, <1 x i16>)
declare <2 x i16> @llvm.sadd.sat.v2i16(<2 x i16>, <2 x i16>)
declare <4 x i16> @llvm.sadd.sat.v4i16(<4 x i16>, <4 x i16>)
declare <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16>, <8 x i16>)
declare <12 x i16> @llvm.sadd.sat.v12i16(<12 x i16>, <12 x i16>)
declare <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16>, <16 x i16>)
declare <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16>, <32 x i16>)

declare <16 x i1> @llvm.sadd.sat.v16i1(<16 x i1>, <16 x i1>)
declare <16 x i4> @llvm.sadd.sat.v16i4(<16 x i4>, <16 x i4>)

declare <2 x i32> @llvm.sadd.sat.v2i32(<2 x i32>, <2 x i32>)
declare <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.sadd.sat.v8i32(<8 x i32>, <8 x i32>)
declare <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32>, <16 x i32>)
declare <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64>, <4 x i64>)
declare <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64>, <8 x i64>)

declare <4 x i24> @llvm.sadd.sat.v4i24(<4 x i24>, <4 x i24>)
declare <2 x i128> @llvm.sadd.sat.v2i128(<2 x i128>, <2 x i128>)

; Legal types, depending on architecture.

define <16 x i8> @v16i8(<16 x i8> %x, <16 x i8> %y) nounwind {
; SSE-LABEL: v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> %x, <16 x i8> %y)
  ret <16 x i8> %z
}

define <32 x i8> @v32i8(<32 x i8> %x, <32 x i8> %y) nounwind {
; SSE-LABEL: v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsb %xmm2, %xmm0
; SSE-NEXT:    paddsb %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpaddsb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddsb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddsb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %z = call <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8> %x, <32 x i8> %y)
  ret <32 x i8> %z
}

define <64 x i8> @v64i8(<64 x i8> %x, <64 x i8> %y) nounwind {
; SSE-LABEL: v64i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsb %xmm4, %xmm0
; SSE-NEXT:    paddsb %xmm5, %xmm1
; SSE-NEXT:    paddsb %xmm6, %xmm2
; SSE-NEXT:    paddsb %xmm7, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: v64i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpaddsb %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpaddsb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpaddsb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpaddsb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddsb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddsb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512F-NEXT:    vpaddsb %ymm2, %ymm3, %ymm2
; AVX512F-NEXT:    vpaddsb %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpaddsb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %z = call <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8> %x, <64 x i8> %y)
  ret <64 x i8> %z
}

define <8 x i16> @v8i16(<8 x i16> %x, <8 x i16> %y) nounwind {
; SSE-LABEL: v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> %x, <8 x i16> %y)
  ret <8 x i16> %z
}

define <16 x i16> @v16i16(<16 x i16> %x, <16 x i16> %y) nounwind {
; SSE-LABEL: v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsw %xmm2, %xmm0
; SSE-NEXT:    paddsw %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpaddsw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddsw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddsw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddsw %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %z = call <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16> %x, <16 x i16> %y)
  ret <16 x i16> %z
}

define <32 x i16> @v32i16(<32 x i16> %x, <32 x i16> %y) nounwind {
; SSE-LABEL: v32i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsw %xmm4, %xmm0
; SSE-NEXT:    paddsw %xmm5, %xmm1
; SSE-NEXT:    paddsw %xmm6, %xmm2
; SSE-NEXT:    paddsw %xmm7, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: v32i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpaddsw %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpaddsw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpaddsw %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpaddsw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v32i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddsw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddsw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512F-NEXT:    vpaddsw %ymm2, %ymm3, %ymm2
; AVX512F-NEXT:    vpaddsw %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpaddsw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %z = call <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16> %x, <32 x i16> %y)
  ret <32 x i16> %z
}

; Too narrow vectors, legalized by widening.

define void @v8i8(<8 x i8>* %px, <8 x i8>* %py, <8 x i8>* %pz) nounwind {
; SSE-LABEL: v8i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    paddsb %xmm0, %xmm1
; SSE-NEXT:    movq %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: v8i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovq %xmm0, (%rdx)
; AVX-NEXT:    retq
  %x = load <8 x i8>, <8 x i8>* %px
  %y = load <8 x i8>, <8 x i8>* %py
  %z = call <8 x i8> @llvm.sadd.sat.v8i8(<8 x i8> %x, <8 x i8> %y)
  store <8 x i8> %z, <8 x i8>* %pz
  ret void
}

define void @v4i8(<4 x i8>* %px, <4 x i8>* %py, <4 x i8>* %pz) nounwind {
; SSE-LABEL: v4i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    paddsb %xmm0, %xmm1
; SSE-NEXT:    movd %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: v4i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovd %xmm0, (%rdx)
; AVX-NEXT:    retq
  %x = load <4 x i8>, <4 x i8>* %px
  %y = load <4 x i8>, <4 x i8>* %py
  %z = call <4 x i8> @llvm.sadd.sat.v4i8(<4 x i8> %x, <4 x i8> %y)
  store <4 x i8> %z, <4 x i8>* %pz
  ret void
}

define void @v2i8(<2 x i8>* %px, <2 x i8>* %py, <2 x i8>* %pz) nounwind {
; SSE2-LABEL: v2i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movzwl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    movzwl (%rsi), %eax
; SSE2-NEXT:    movd %eax, %xmm1
; SSE2-NEXT:    paddsb %xmm0, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    movw %ax, (%rdx)
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v2i8:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movzwl (%rdi), %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    movzwl (%rsi), %eax
; SSSE3-NEXT:    movd %eax, %xmm1
; SSSE3-NEXT:    paddsb %xmm0, %xmm1
; SSSE3-NEXT:    movd %xmm1, %eax
; SSSE3-NEXT:    movw %ax, (%rdx)
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v2i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movzwl (%rdi), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    movzwl (%rsi), %eax
; SSE41-NEXT:    movd %eax, %xmm1
; SSE41-NEXT:    paddsb %xmm0, %xmm1
; SSE41-NEXT:    pextrw $0, %xmm1, (%rdx)
; SSE41-NEXT:    retq
;
; AVX-LABEL: v2i8:
; AVX:       # %bb.0:
; AVX-NEXT:    movzwl (%rdi), %eax
; AVX-NEXT:    vmovd %eax, %xmm0
; AVX-NEXT:    movzwl (%rsi), %eax
; AVX-NEXT:    vmovd %eax, %xmm1
; AVX-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpextrw $0, %xmm0, (%rdx)
; AVX-NEXT:    retq
  %x = load <2 x i8>, <2 x i8>* %px
  %y = load <2 x i8>, <2 x i8>* %py
  %z = call <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8> %x, <2 x i8> %y)
  store <2 x i8> %z, <2 x i8>* %pz
  ret void
}

define void @v4i16(<4 x i16>* %px, <4 x i16>* %py, <4 x i16>* %pz) nounwind {
; SSE-LABEL: v4i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    paddsw %xmm0, %xmm1
; SSE-NEXT:    movq %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: v4i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vpaddsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovq %xmm0, (%rdx)
; AVX-NEXT:    retq
  %x = load <4 x i16>, <4 x i16>* %px
  %y = load <4 x i16>, <4 x i16>* %py
  %z = call <4 x i16> @llvm.sadd.sat.v4i16(<4 x i16> %x, <4 x i16> %y)
  store <4 x i16> %z, <4 x i16>* %pz
  ret void
}

define void @v2i16(<2 x i16>* %px, <2 x i16>* %py, <2 x i16>* %pz) nounwind {
; SSE-LABEL: v2i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    paddsw %xmm0, %xmm1
; SSE-NEXT:    movd %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: v2i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX-NEXT:    vpaddsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovd %xmm0, (%rdx)
; AVX-NEXT:    retq
  %x = load <2 x i16>, <2 x i16>* %px
  %y = load <2 x i16>, <2 x i16>* %py
  %z = call <2 x i16> @llvm.sadd.sat.v2i16(<2 x i16> %x, <2 x i16> %y)
  store <2 x i16> %z, <2 x i16>* %pz
  ret void
}

define <12 x i8> @v12i8(<12 x i8> %x, <12 x i8> %y) nounwind {
; SSE-LABEL: v12i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v12i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <12 x i8> @llvm.sadd.sat.v12i8(<12 x i8> %x, <12 x i8> %y)
  ret <12 x i8> %z
}

define void @v12i16(<12 x i16>* %px, <12 x i16>* %py, <12 x i16>* %pz) nounwind {
; SSE-LABEL: v12i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rdi), %xmm1
; SSE-NEXT:    paddsw 16(%rsi), %xmm1
; SSE-NEXT:    paddsw (%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, (%rdx)
; SSE-NEXT:    movq %xmm1, 16(%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v12i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vpaddsw 16(%rsi), %xmm1, %xmm1
; AVX1-NEXT:    vpaddsw (%rsi), %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX1-NEXT:    vmovq %xmm1, 16(%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v12i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpaddsw (%rsi), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vmovq %xmm1, 16(%rdx)
; AVX2-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v12i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vpaddsw (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512-NEXT:    vmovq %xmm1, 16(%rdx)
; AVX512-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %x = load <12 x i16>, <12 x i16>* %px
  %y = load <12 x i16>, <12 x i16>* %py
  %z = call <12 x i16> @llvm.sadd.sat.v12i16(<12 x i16> %x, <12 x i16> %y)
  store <12 x i16> %z, <12 x i16>* %pz
  ret void
}

; Scalarization

define void @v1i8(<1 x i8>* %px, <1 x i8>* %py, <1 x i8>* %pz) nounwind {
; SSE-LABEL: v1i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movb (%rdi), %cl
; SSE-NEXT:    movb (%rsi), %dil
; SSE-NEXT:    xorl %esi, %esi
; SSE-NEXT:    movl %ecx, %eax
; SSE-NEXT:    addb %dil, %al
; SSE-NEXT:    setns %sil
; SSE-NEXT:    addl $127, %esi
; SSE-NEXT:    addb %dil, %cl
; SSE-NEXT:    movzbl %cl, %eax
; SSE-NEXT:    cmovol %esi, %eax
; SSE-NEXT:    movb %al, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: v1i8:
; AVX:       # %bb.0:
; AVX-NEXT:    movb (%rdi), %cl
; AVX-NEXT:    movb (%rsi), %dil
; AVX-NEXT:    xorl %esi, %esi
; AVX-NEXT:    movl %ecx, %eax
; AVX-NEXT:    addb %dil, %al
; AVX-NEXT:    setns %sil
; AVX-NEXT:    addl $127, %esi
; AVX-NEXT:    addb %dil, %cl
; AVX-NEXT:    movzbl %cl, %eax
; AVX-NEXT:    cmovol %esi, %eax
; AVX-NEXT:    movb %al, (%rdx)
; AVX-NEXT:    retq
  %x = load <1 x i8>, <1 x i8>* %px
  %y = load <1 x i8>, <1 x i8>* %py
  %z = call <1 x i8> @llvm.sadd.sat.v1i8(<1 x i8> %x, <1 x i8> %y)
  store <1 x i8> %z, <1 x i8>* %pz
  ret void
}

define void @v1i16(<1 x i16>* %px, <1 x i16>* %py, <1 x i16>* %pz) nounwind {
; SSE-LABEL: v1i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movzwl (%rdi), %eax
; SSE-NEXT:    movzwl (%rsi), %ecx
; SSE-NEXT:    xorl %esi, %esi
; SSE-NEXT:    movl %eax, %edi
; SSE-NEXT:    addw %cx, %di
; SSE-NEXT:    setns %sil
; SSE-NEXT:    addl $32767, %esi # imm = 0x7FFF
; SSE-NEXT:    addw %cx, %ax
; SSE-NEXT:    cmovol %esi, %eax
; SSE-NEXT:    movw %ax, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: v1i16:
; AVX:       # %bb.0:
; AVX-NEXT:    movzwl (%rdi), %eax
; AVX-NEXT:    movzwl (%rsi), %ecx
; AVX-NEXT:    xorl %esi, %esi
; AVX-NEXT:    movl %eax, %edi
; AVX-NEXT:    addw %cx, %di
; AVX-NEXT:    setns %sil
; AVX-NEXT:    addl $32767, %esi # imm = 0x7FFF
; AVX-NEXT:    addw %cx, %ax
; AVX-NEXT:    cmovol %esi, %eax
; AVX-NEXT:    movw %ax, (%rdx)
; AVX-NEXT:    retq
  %x = load <1 x i16>, <1 x i16>* %px
  %y = load <1 x i16>, <1 x i16>* %py
  %z = call <1 x i16> @llvm.sadd.sat.v1i16(<1 x i16> %x, <1 x i16> %y)
  store <1 x i16> %z, <1 x i16>* %pz
  ret void
}

; Promotion

define <16 x i4> @v16i4(<16 x i4> %x, <16 x i4> %y) nounwind {
; SSE-LABEL: v16i4:
; SSE:       # %bb.0:
; SSE-NEXT:    psllw $4, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    psllw $4, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    paddsb %xmm1, %xmm0
; SSE-NEXT:    psrlw $4, %xmm0
; SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    psubb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: v16i4:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsllw $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsllw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v16i4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllw $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm2 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX2-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpsllw $4, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm1 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: v16i4:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsllw $4, %xmm1, %xmm1
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm2 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512F-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX512F-NEXT:    vpsllw $4, %xmm0, %xmm0
; AVX512F-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX512F-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm1 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512F-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: v16i4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllw $4, %xmm1, %xmm1
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm2 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512BW-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX512BW-NEXT:    vpsllw $4, %xmm0, %xmm0
; AVX512BW-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX512BW-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm1 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512BW-NEXT:    vpternlogq $108, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm0
; AVX512BW-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    retq
  %z = call <16 x i4> @llvm.sadd.sat.v16i4(<16 x i4> %x, <16 x i4> %y)
  ret <16 x i4> %z
}

define <16 x i1> @v16i1(<16 x i1> %x, <16 x i1> %y) nounwind {
; SSE-LABEL: v16i1:
; SSE:       # %bb.0:
; SSE-NEXT:    orps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v16i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <16 x i1> @llvm.sadd.sat.v16i1(<16 x i1> %x, <16 x i1> %y)
  ret <16 x i1> %z
}

; Expanded

define <2 x i32> @v2i32(<2 x i32> %x, <2 x i32> %y) nounwind {
; SSE2-LABEL: v2i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE2-NEXT:    paddd %xmm0, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm3, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    psrld $1, %xmm2
; SSE2-NEXT:    por %xmm3, %xmm2
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    pandn %xmm1, %xmm0
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v2i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm3
; SSSE3-NEXT:    paddd %xmm0, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm0
; SSSE3-NEXT:    pxor %xmm3, %xmm0
; SSSE3-NEXT:    movdqa %xmm1, %xmm3
; SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSSE3-NEXT:    psrld $1, %xmm2
; SSSE3-NEXT:    por %xmm3, %xmm2
; SSSE3-NEXT:    pand %xmm0, %xmm2
; SSSE3-NEXT:    pandn %xmm1, %xmm0
; SSSE3-NEXT:    por %xmm2, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v2i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    paddd %xmm1, %xmm3
; SSE41-NEXT:    movaps {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    blendvps %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm4
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm2
; SSE41-NEXT:    pxor %xmm1, %xmm2
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm4, %xmm3
; SSE41-NEXT:    movaps %xmm3, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v2i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovaps {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; AVX1-NEXT:    vblendvps %xmm2, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vblendvps %xmm0, %xmm3, %xmm2, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v2i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm3 = [2147483647,2147483647,2147483647,2147483647]
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; AVX2-NEXT:    vblendvps %xmm2, %xmm3, %xmm4, %xmm3
; AVX2-NEXT:    vpcmpgtd %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vblendvps %xmm0, %xmm3, %xmm2, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: v2i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpaddd %xmm1, %xmm0, %xmm2
; AVX512F-NEXT:    vbroadcastss {{.*#+}} xmm3 = [2147483647,2147483647,2147483647,2147483647]
; AVX512F-NEXT:    vbroadcastss {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; AVX512F-NEXT:    vblendvps %xmm2, %xmm3, %xmm4, %xmm3
; AVX512F-NEXT:    vpcmpgtd %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vpxor %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vblendvps %xmm0, %xmm3, %xmm2, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: v2i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512BW-NEXT:    vpcmpgtd %xmm1, %xmm2, %k0
; AVX512BW-NEXT:    vpaddd %xmm1, %xmm0, %xmm1
; AVX512BW-NEXT:    vpcmpgtd %xmm1, %xmm0, %k1
; AVX512BW-NEXT:    kxorw %k1, %k0, %k1
; AVX512BW-NEXT:    vpcmpgtd %xmm1, %xmm2, %k2
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} xmm0 = [2147483648,2147483648,2147483648,2147483648]
; AVX512BW-NEXT:    vpbroadcastd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0 {%k2}
; AVX512BW-NEXT:    vmovdqa32 %xmm0, %xmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512BW-NEXT:    retq
  %z = call <2 x i32> @llvm.sadd.sat.v2i32(<2 x i32> %x, <2 x i32> %y)
  ret <2 x i32> %z
}

define <4 x i32> @v4i32(<4 x i32> %x, <4 x i32> %y) nounwind {
; SSE2-LABEL: v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE2-NEXT:    paddd %xmm0, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm3, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    psrld $1, %xmm2
; SSE2-NEXT:    por %xmm3, %xmm2
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    pandn %xmm1, %xmm0
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v4i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm3
; SSSE3-NEXT:    paddd %xmm0, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm0
; SSSE3-NEXT:    pxor %xmm3, %xmm0
; SSSE3-NEXT:    movdqa %xmm1, %xmm3
; SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSSE3-NEXT:    psrld $1, %xmm2
; SSSE3-NEXT:    por %xmm3, %xmm2
; SSSE3-NEXT:    pand %xmm0, %xmm2
; SSSE3-NEXT:    pandn %xmm1, %xmm0
; SSSE3-NEXT:    por %xmm2, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v4i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    paddd %xmm1, %xmm3
; SSE41-NEXT:    movaps {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    blendvps %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm4
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm2
; SSE41-NEXT:    pxor %xmm1, %xmm2
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm4, %xmm3
; SSE41-NEXT:    movaps %xmm3, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovaps {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; AVX1-NEXT:    vblendvps %xmm2, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vblendvps %xmm0, %xmm3, %xmm2, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm3 = [2147483647,2147483647,2147483647,2147483647]
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; AVX2-NEXT:    vblendvps %xmm2, %xmm3, %xmm4, %xmm3
; AVX2-NEXT:    vpcmpgtd %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vblendvps %xmm0, %xmm3, %xmm2, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpaddd %xmm1, %xmm0, %xmm2
; AVX512F-NEXT:    vbroadcastss {{.*#+}} xmm3 = [2147483647,2147483647,2147483647,2147483647]
; AVX512F-NEXT:    vbroadcastss {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; AVX512F-NEXT:    vblendvps %xmm2, %xmm3, %xmm4, %xmm3
; AVX512F-NEXT:    vpcmpgtd %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vpxor %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vblendvps %xmm0, %xmm3, %xmm2, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: v4i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512BW-NEXT:    vpcmpgtd %xmm1, %xmm2, %k0
; AVX512BW-NEXT:    vpaddd %xmm1, %xmm0, %xmm1
; AVX512BW-NEXT:    vpcmpgtd %xmm1, %xmm0, %k1
; AVX512BW-NEXT:    kxorw %k1, %k0, %k1
; AVX512BW-NEXT:    vpcmpgtd %xmm1, %xmm2, %k2
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} xmm0 = [2147483648,2147483648,2147483648,2147483648]
; AVX512BW-NEXT:    vpbroadcastd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0 {%k2}
; AVX512BW-NEXT:    vmovdqa32 %xmm0, %xmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512BW-NEXT:    retq
  %z = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> %x, <4 x i32> %y)
  ret <4 x i32> %z
}

define <8 x i32> @v8i32(<8 x i32> %x, <8 x i32> %y) nounwind {
; SSE2-LABEL: v8i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE2-NEXT:    paddd %xmm0, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm0
; SSE2-NEXT:    pxor %xmm5, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm2, %xmm6
; SSE2-NEXT:    pandn %xmm5, %xmm6
; SSE2-NEXT:    pxor %xmm7, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm7
; SSE2-NEXT:    psrld $1, %xmm7
; SSE2-NEXT:    por %xmm6, %xmm7
; SSE2-NEXT:    pand %xmm0, %xmm7
; SSE2-NEXT:    pandn %xmm2, %xmm0
; SSE2-NEXT:    por %xmm7, %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm2
; SSE2-NEXT:    paddd %xmm1, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm1
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    pandn %xmm5, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE2-NEXT:    psrld $1, %xmm4
; SSE2-NEXT:    por %xmm2, %xmm4
; SSE2-NEXT:    pand %xmm1, %xmm4
; SSE2-NEXT:    pandn %xmm3, %xmm1
; SSE2-NEXT:    por %xmm4, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v8i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pxor %xmm5, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm5
; SSSE3-NEXT:    paddd %xmm0, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm0
; SSSE3-NEXT:    pxor %xmm5, %xmm0
; SSSE3-NEXT:    movdqa {{.*#+}} xmm5 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm2, %xmm6
; SSSE3-NEXT:    pandn %xmm5, %xmm6
; SSSE3-NEXT:    pxor %xmm7, %xmm7
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm7
; SSSE3-NEXT:    psrld $1, %xmm7
; SSSE3-NEXT:    por %xmm6, %xmm7
; SSSE3-NEXT:    pand %xmm0, %xmm7
; SSSE3-NEXT:    pandn %xmm2, %xmm0
; SSSE3-NEXT:    por %xmm7, %xmm0
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm2
; SSSE3-NEXT:    paddd %xmm1, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm1
; SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSSE3-NEXT:    pandn %xmm5, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm4
; SSSE3-NEXT:    psrld $1, %xmm4
; SSSE3-NEXT:    por %xmm2, %xmm4
; SSSE3-NEXT:    pand %xmm1, %xmm4
; SSSE3-NEXT:    pandn %xmm3, %xmm1
; SSSE3-NEXT:    por %xmm4, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v8i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm4
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    paddd %xmm2, %xmm5
; SSE41-NEXT:    movaps {{.*#+}} xmm8 = [2147483647,2147483647,2147483647,2147483647]
; SSE41-NEXT:    movaps {{.*#+}} xmm6 = [2147483648,2147483648,2147483648,2147483648]
; SSE41-NEXT:    movaps %xmm6, %xmm7
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm8, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE41-NEXT:    pxor %xmm2, %xmm4
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm7, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm2
; SSE41-NEXT:    paddd %xmm3, %xmm2
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm8, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE41-NEXT:    pxor %xmm3, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm6, %xmm2
; SSE41-NEXT:    movaps %xmm5, %xmm0
; SSE41-NEXT:    movaps %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpaddd %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm5
; AVX1-NEXT:    vmovaps {{.*#+}} ymm6 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; AVX1-NEXT:    vblendvps %ymm5, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm6, %ymm6
; AVX1-NEXT:    vpcmpgtd %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpgtd %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vblendvps %ymm0, %ymm6, %ymm5, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647]
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm4 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; AVX2-NEXT:    vblendvps %ymm2, %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vpcmpgtd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vblendvps %ymm0, %ymm3, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: v8i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpaddd %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vbroadcastss {{.*#+}} ymm3 = [2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647]
; AVX512F-NEXT:    vbroadcastss {{.*#+}} ymm4 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; AVX512F-NEXT:    vblendvps %ymm2, %ymm3, %ymm4, %ymm3
; AVX512F-NEXT:    vpcmpgtd %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpxor %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    vblendvps %ymm0, %ymm3, %ymm2, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: v8i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512BW-NEXT:    vpcmpgtd %ymm1, %ymm2, %k0
; AVX512BW-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; AVX512BW-NEXT:    vpcmpgtd %ymm1, %ymm0, %k1
; AVX512BW-NEXT:    kxorw %k1, %k0, %k1
; AVX512BW-NEXT:    vpcmpgtd %ymm1, %ymm2, %k2
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} ymm0 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; AVX512BW-NEXT:    vpbroadcastd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0 {%k2}
; AVX512BW-NEXT:    vmovdqa32 %ymm0, %ymm1 {%k1}
; AVX512BW-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512BW-NEXT:    retq
  %z = call <8 x i32> @llvm.sadd.sat.v8i32(<8 x i32> %x, <8 x i32> %y)
  ret <8 x i32> %z
}

define <16 x i32> @v16i32(<16 x i32> %x, <16 x i32> %y) nounwind {
; SSE2-LABEL: v16i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm9
; SSE2-NEXT:    paddd %xmm0, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm0
; SSE2-NEXT:    pxor %xmm9, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm9 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm4, %xmm10
; SSE2-NEXT:    pandn %xmm9, %xmm10
; SSE2-NEXT:    pxor %xmm11, %xmm11
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm11
; SSE2-NEXT:    psrld $1, %xmm11
; SSE2-NEXT:    por %xmm10, %xmm11
; SSE2-NEXT:    pand %xmm0, %xmm11
; SSE2-NEXT:    pandn %xmm4, %xmm0
; SSE2-NEXT:    por %xmm11, %xmm0
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE2-NEXT:    paddd %xmm1, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm1
; SSE2-NEXT:    pxor %xmm4, %xmm1
; SSE2-NEXT:    movdqa %xmm5, %xmm10
; SSE2-NEXT:    pandn %xmm9, %xmm10
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE2-NEXT:    psrld $1, %xmm4
; SSE2-NEXT:    por %xmm10, %xmm4
; SSE2-NEXT:    pand %xmm1, %xmm4
; SSE2-NEXT:    pandn %xmm5, %xmm1
; SSE2-NEXT:    por %xmm4, %xmm1
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm4
; SSE2-NEXT:    paddd %xmm2, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm2
; SSE2-NEXT:    movdqa %xmm6, %xmm4
; SSE2-NEXT:    pandn %xmm9, %xmm4
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm5
; SSE2-NEXT:    psrld $1, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    pand %xmm2, %xmm5
; SSE2-NEXT:    pandn %xmm6, %xmm2
; SSE2-NEXT:    por %xmm5, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm7, %xmm4
; SSE2-NEXT:    paddd %xmm3, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm7, %xmm3
; SSE2-NEXT:    pxor %xmm4, %xmm3
; SSE2-NEXT:    movdqa %xmm7, %xmm4
; SSE2-NEXT:    pandn %xmm9, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm7, %xmm8
; SSE2-NEXT:    psrld $1, %xmm8
; SSE2-NEXT:    por %xmm4, %xmm8
; SSE2-NEXT:    pand %xmm3, %xmm8
; SSE2-NEXT:    pandn %xmm7, %xmm3
; SSE2-NEXT:    por %xmm8, %xmm3
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v16i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pxor %xmm8, %xmm8
; SSSE3-NEXT:    pxor %xmm9, %xmm9
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm9
; SSSE3-NEXT:    paddd %xmm0, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm0
; SSSE3-NEXT:    pxor %xmm9, %xmm0
; SSSE3-NEXT:    movdqa {{.*#+}} xmm9 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm4, %xmm10
; SSSE3-NEXT:    pandn %xmm9, %xmm10
; SSSE3-NEXT:    pxor %xmm11, %xmm11
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm11
; SSSE3-NEXT:    psrld $1, %xmm11
; SSSE3-NEXT:    por %xmm10, %xmm11
; SSSE3-NEXT:    pand %xmm0, %xmm11
; SSSE3-NEXT:    pandn %xmm4, %xmm0
; SSSE3-NEXT:    por %xmm11, %xmm0
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm4
; SSSE3-NEXT:    paddd %xmm1, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm1
; SSSE3-NEXT:    pxor %xmm4, %xmm1
; SSSE3-NEXT:    movdqa %xmm5, %xmm10
; SSSE3-NEXT:    pandn %xmm9, %xmm10
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm4
; SSSE3-NEXT:    psrld $1, %xmm4
; SSSE3-NEXT:    por %xmm10, %xmm4
; SSSE3-NEXT:    pand %xmm1, %xmm4
; SSSE3-NEXT:    pandn %xmm5, %xmm1
; SSSE3-NEXT:    por %xmm4, %xmm1
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm6, %xmm4
; SSSE3-NEXT:    paddd %xmm2, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm6, %xmm2
; SSSE3-NEXT:    pxor %xmm4, %xmm2
; SSSE3-NEXT:    movdqa %xmm6, %xmm4
; SSSE3-NEXT:    pandn %xmm9, %xmm4
; SSSE3-NEXT:    pxor %xmm5, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm6, %xmm5
; SSSE3-NEXT:    psrld $1, %xmm5
; SSSE3-NEXT:    por %xmm4, %xmm5
; SSSE3-NEXT:    pand %xmm2, %xmm5
; SSSE3-NEXT:    pandn %xmm6, %xmm2
; SSSE3-NEXT:    por %xmm5, %xmm2
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm7, %xmm4
; SSSE3-NEXT:    paddd %xmm3, %xmm7
; SSSE3-NEXT:    pcmpgtd %xmm7, %xmm3
; SSSE3-NEXT:    pxor %xmm4, %xmm3
; SSSE3-NEXT:    movdqa %xmm7, %xmm4
; SSSE3-NEXT:    pandn %xmm9, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm7, %xmm8
; SSSE3-NEXT:    psrld $1, %xmm8
; SSSE3-NEXT:    por %xmm4, %xmm8
; SSSE3-NEXT:    pand %xmm3, %xmm8
; SSSE3-NEXT:    pandn %xmm7, %xmm3
; SSSE3-NEXT:    por %xmm8, %xmm3
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v16i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm3, %xmm8
; SSE41-NEXT:    movdqa %xmm2, %xmm12
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm0, %xmm9
; SSE41-NEXT:    paddd %xmm4, %xmm9
; SSE41-NEXT:    movaps {{.*#+}} xmm11 = [2147483647,2147483647,2147483647,2147483647]
; SSE41-NEXT:    movaps {{.*#+}} xmm10 = [2147483648,2147483648,2147483648,2147483648]
; SSE41-NEXT:    movaps %xmm10, %xmm2
; SSE41-NEXT:    movdqa %xmm9, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm11, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm9, %xmm3
; SSE41-NEXT:    pxor %xmm4, %xmm3
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm2, %xmm9
; SSE41-NEXT:    movdqa %xmm1, %xmm4
; SSE41-NEXT:    paddd %xmm5, %xmm4
; SSE41-NEXT:    movaps %xmm10, %xmm2
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm11, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm4, %xmm1
; SSE41-NEXT:    pxor %xmm5, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm2, %xmm4
; SSE41-NEXT:    movdqa %xmm12, %xmm3
; SSE41-NEXT:    paddd %xmm6, %xmm3
; SSE41-NEXT:    movaps %xmm10, %xmm1
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm11, %xmm1
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm12
; SSE41-NEXT:    pxor %xmm6, %xmm12
; SSE41-NEXT:    movdqa %xmm12, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm1, %xmm3
; SSE41-NEXT:    movdqa %xmm8, %xmm5
; SSE41-NEXT:    paddd %xmm7, %xmm5
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm11, %xmm10
; SSE41-NEXT:    pcmpgtd %xmm5, %xmm8
; SSE41-NEXT:    pxor %xmm7, %xmm8
; SSE41-NEXT:    movdqa %xmm8, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm10, %xmm5
; SSE41-NEXT:    movaps %xmm9, %xmm0
; SSE41-NEXT:    movaps %xmm4, %xmm1
; SSE41-NEXT:    movaps %xmm3, %xmm2
; SSE41-NEXT:    movaps %xmm5, %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v16i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpaddd %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpaddd %xmm2, %xmm0, %xmm6
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm6, %ymm7
; AVX1-NEXT:    vmovaps {{.*#+}} ymm8 = [2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647]
; AVX1-NEXT:    vmovaps {{.*#+}} ymm9 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; AVX1-NEXT:    vblendvps %ymm7, %ymm8, %ymm9, %ymm10
; AVX1-NEXT:    vpcmpgtd %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpcmpgtd %xmm6, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %ymm0, %ymm2, %ymm0
; AVX1-NEXT:    vblendvps %ymm0, %ymm10, %ymm7, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpaddd %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpaddd %xmm3, %xmm1, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm5, %ymm6
; AVX1-NEXT:    vblendvps %ymm6, %ymm8, %ymm9, %ymm7
; AVX1-NEXT:    vpcmpgtd %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpcmpgtd %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vxorps %ymm1, %ymm3, %ymm1
; AVX1-NEXT:    vblendvps %ymm1, %ymm7, %ymm6, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd %ymm2, %ymm0, %ymm4
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm5 = [2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647]
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm6 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; AVX2-NEXT:    vblendvps %ymm4, %ymm5, %ymm6, %ymm7
; AVX2-NEXT:    vpcmpgtd %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vblendvps %ymm0, %ymm7, %ymm4, %ymm0
; AVX2-NEXT:    vpaddd %ymm3, %ymm1, %ymm2
; AVX2-NEXT:    vblendvps %ymm2, %ymm5, %ymm6, %ymm4
; AVX2-NEXT:    vpcmpgtd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vblendvps %ymm1, %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512-NEXT:    vpcmpgtd %zmm1, %zmm2, %k0
; AVX512-NEXT:    vpaddd %zmm1, %zmm0, %zmm1
; AVX512-NEXT:    vpcmpgtd %zmm1, %zmm0, %k1
; AVX512-NEXT:    kxorw %k1, %k0, %k1
; AVX512-NEXT:    vpcmpgtd %zmm1, %zmm2, %k2
; AVX512-NEXT:    vpbroadcastd {{.*#+}} zmm0 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; AVX512-NEXT:    vpbroadcastd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0 {%k2}
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-NEXT:    retq
  %z = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> %x, <16 x i32> %y)
  ret <16 x i32> %z
}

define <2 x i64> @v2i64(<2 x i64> %x, <2 x i64> %y) nounwind {
; SSE2-LABEL: v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pxor %xmm2, %xmm3
; SSE2-NEXT:    paddq %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm0, %xmm2
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-NEXT:    pand %xmm5, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE2-NEXT:    pxor %xmm3, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm1
; SSE2-NEXT:    pandn %xmm0, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm2
; SSE2-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v2i64:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    pxor %xmm2, %xmm3
; SSSE3-NEXT:    paddq %xmm1, %xmm0
; SSSE3-NEXT:    pxor %xmm0, %xmm2
; SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm3, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSSE3-NEXT:    pand %xmm5, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,1,3,3]
; SSSE3-NEXT:    por %xmm2, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm4
; SSSE3-NEXT:    pxor %xmm3, %xmm4
; SSSE3-NEXT:    movdqa %xmm4, %xmm1
; SSSE3-NEXT:    pandn %xmm0, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm2
; SSSE3-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; SSSE3-NEXT:    por %xmm2, %xmm0
; SSSE3-NEXT:    pand %xmm4, %xmm0
; SSSE3-NEXT:    por %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v2i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm2, %xmm4
; SSE41-NEXT:    pxor %xmm0, %xmm4
; SSE41-NEXT:    paddq %xmm1, %xmm2
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm3
; SSE41-NEXT:    por %xmm4, %xmm3
; SSE41-NEXT:    pxor %xmm1, %xmm3
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [9223372036854775808,9223372036854775808]
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    movapd %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpaddq %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovapd {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vblendvpd %xmm2, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vblendvpd %xmm0, %xmm3, %xmm2, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vmovapd {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vblendvpd %xmm2, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3, %xmm3
; AVX2-NEXT:    vpcmpgtq %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vblendvpd %xmm0, %xmm3, %xmm2, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: v2i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpaddq %xmm1, %xmm0, %xmm2
; AVX512F-NEXT:    vmovapd {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; AVX512F-NEXT:    vblendvpd %xmm2, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3, %xmm3
; AVX512F-NEXT:    vpcmpgtq %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vpxor %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vblendvpd %xmm0, %xmm3, %xmm2, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: v2i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512BW-NEXT:    vpcmpgtq %xmm1, %xmm2, %k0
; AVX512BW-NEXT:    vpaddq %xmm1, %xmm0, %xmm1
; AVX512BW-NEXT:    vpcmpgtq %xmm1, %xmm0, %k1
; AVX512BW-NEXT:    kxorw %k1, %k0, %k1
; AVX512BW-NEXT:    vpcmpgtq %xmm1, %xmm2, %k2
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm0 = [9223372036854775808,9223372036854775808]
; AVX512BW-NEXT:    vmovdqa64 {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %xmm0, %xmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512BW-NEXT:    retq
  %z = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> %x, <2 x i64> %y)
  ret <2 x i64> %z
}

define <4 x i64> @v4i64(<4 x i64> %x, <4 x i64> %y) nounwind {
; SSE2-LABEL: v4i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    pxor %xmm4, %xmm5
; SSE2-NEXT:    paddq %xmm2, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm6
; SSE2-NEXT:    pxor %xmm4, %xmm6
; SSE2-NEXT:    movdqa %xmm5, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSE2-NEXT:    pand %xmm8, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[1,1,3,3]
; SSE2-NEXT:    por %xmm5, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[1,1,3,3]
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm7, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm7
; SSE2-NEXT:    pxor %xmm6, %xmm7
; SSE2-NEXT:    movdqa %xmm7, %xmm5
; SSE2-NEXT:    pandn %xmm0, %xmm5
; SSE2-NEXT:    movdqa {{.*#+}} xmm8 = [9223372036854775808,9223372036854775808]
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[1,1,3,3]
; SSE2-NEXT:    pandn %xmm8, %xmm0
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm9, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm9 = [9223372036854775807,9223372036854775807]
; SSE2-NEXT:    pand %xmm9, %xmm6
; SSE2-NEXT:    por %xmm6, %xmm0
; SSE2-NEXT:    pand %xmm7, %xmm0
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    pxor %xmm4, %xmm5
; SSE2-NEXT:    paddq %xmm3, %xmm1
; SSE2-NEXT:    pxor %xmm1, %xmm4
; SSE2-NEXT:    movdqa %xmm5, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    pand %xmm7, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE2-NEXT:    pxor %xmm5, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm3
; SSE2-NEXT:    pandn %xmm1, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[1,1,3,3]
; SSE2-NEXT:    pandn %xmm8, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm2
; SSE2-NEXT:    pand %xmm9, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm1
; SSE2-NEXT:    pand %xmm4, %xmm1
; SSE2-NEXT:    por %xmm3, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v4i64:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm0, %xmm5
; SSSE3-NEXT:    pxor %xmm4, %xmm5
; SSSE3-NEXT:    paddq %xmm2, %xmm0
; SSSE3-NEXT:    movdqa %xmm0, %xmm6
; SSSE3-NEXT:    pxor %xmm4, %xmm6
; SSSE3-NEXT:    movdqa %xmm5, %xmm7
; SSSE3-NEXT:    pcmpgtd %xmm6, %xmm7
; SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm6
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSSE3-NEXT:    pand %xmm8, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[1,1,3,3]
; SSSE3-NEXT:    por %xmm5, %xmm6
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[1,1,3,3]
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pxor %xmm7, %xmm7
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm7
; SSSE3-NEXT:    pxor %xmm6, %xmm7
; SSSE3-NEXT:    movdqa %xmm7, %xmm5
; SSSE3-NEXT:    pandn %xmm0, %xmm5
; SSSE3-NEXT:    movdqa {{.*#+}} xmm8 = [9223372036854775808,9223372036854775808]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[1,1,3,3]
; SSSE3-NEXT:    pandn %xmm8, %xmm0
; SSSE3-NEXT:    pxor %xmm6, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm9, %xmm6
; SSSE3-NEXT:    movdqa {{.*#+}} xmm9 = [9223372036854775807,9223372036854775807]
; SSSE3-NEXT:    pand %xmm9, %xmm6
; SSSE3-NEXT:    por %xmm6, %xmm0
; SSSE3-NEXT:    pand %xmm7, %xmm0
; SSSE3-NEXT:    por %xmm5, %xmm0
; SSSE3-NEXT:    movdqa %xmm1, %xmm5
; SSSE3-NEXT:    pxor %xmm4, %xmm5
; SSSE3-NEXT:    paddq %xmm3, %xmm1
; SSSE3-NEXT:    pxor %xmm1, %xmm4
; SSSE3-NEXT:    movdqa %xmm5, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm6
; SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    pand %xmm7, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSSE3-NEXT:    por %xmm4, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm4
; SSSE3-NEXT:    pxor %xmm5, %xmm4
; SSSE3-NEXT:    movdqa %xmm4, %xmm3
; SSSE3-NEXT:    pandn %xmm1, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pandn %xmm8, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm2
; SSSE3-NEXT:    pand %xmm9, %xmm2
; SSSE3-NEXT:    por %xmm2, %xmm1
; SSSE3-NEXT:    pand %xmm4, %xmm1
; SSSE3-NEXT:    por %xmm3, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v4i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm4
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm6, %xmm0
; SSE41-NEXT:    paddq %xmm2, %xmm4
; SSE41-NEXT:    movdqa %xmm4, %xmm5
; SSE41-NEXT:    pxor %xmm6, %xmm5
; SSE41-NEXT:    movdqa %xmm0, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm5, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm5, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm5
; SSE41-NEXT:    por %xmm0, %xmm5
; SSE41-NEXT:    pxor %xmm2, %xmm5
; SSE41-NEXT:    movapd {{.*#+}} xmm8 = [9223372036854775807,9223372036854775807]
; SSE41-NEXT:    movapd {{.*#+}} xmm7 = [9223372036854775808,9223372036854775808]
; SSE41-NEXT:    movapd %xmm7, %xmm2
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm2
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm4
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm6, %xmm0
; SSE41-NEXT:    paddq %xmm3, %xmm1
; SSE41-NEXT:    pxor %xmm1, %xmm6
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm2
; SSE41-NEXT:    por %xmm0, %xmm2
; SSE41-NEXT:    pxor %xmm3, %xmm2
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm7
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm7, %xmm1
; SSE41-NEXT:    movapd %xmm4, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddq %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm5
; AVX1-NEXT:    vmovapd {{.*#+}} ymm6 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vblendvpd %ymm5, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm6, %ymm6
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vxorpd %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vblendvpd %ymm0, %ymm6, %ymm5, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm3 = [9223372036854775807,9223372036854775807,9223372036854775807,9223372036854775807]
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm4 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vblendvpd %ymm2, %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vblendvpd %ymm0, %ymm3, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: v4i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpaddq %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vbroadcastsd {{.*#+}} ymm3 = [9223372036854775807,9223372036854775807,9223372036854775807,9223372036854775807]
; AVX512F-NEXT:    vbroadcastsd {{.*#+}} ymm4 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX512F-NEXT:    vblendvpd %ymm2, %ymm3, %ymm4, %ymm3
; AVX512F-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpxor %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    vblendvpd %ymm0, %ymm3, %ymm2, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: v4i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512BW-NEXT:    vpcmpgtq %ymm1, %ymm2, %k0
; AVX512BW-NEXT:    vpaddq %ymm1, %ymm0, %ymm1
; AVX512BW-NEXT:    vpcmpgtq %ymm1, %ymm0, %k1
; AVX512BW-NEXT:    kxorw %k1, %k0, %k1
; AVX512BW-NEXT:    vpcmpgtq %ymm1, %ymm2, %k2
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} ymm0 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX512BW-NEXT:    vpbroadcastq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %ymm0, %ymm1 {%k1}
; AVX512BW-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512BW-NEXT:    retq
  %z = call <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64> %x, <4 x i64> %y)
  ret <4 x i64> %z
}

define <8 x i64> @v8i64(<8 x i64> %x, <8 x i64> %y) nounwind {
; SSE2-LABEL: v8i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm8 = [2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm0, %xmm9
; SSE2-NEXT:    pxor %xmm8, %xmm9
; SSE2-NEXT:    paddq %xmm4, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm10
; SSE2-NEXT:    pxor %xmm8, %xmm10
; SSE2-NEXT:    movdqa %xmm9, %xmm11
; SSE2-NEXT:    pcmpgtd %xmm10, %xmm11
; SSE2-NEXT:    pshufd {{.*#+}} xmm12 = xmm11[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm10
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm10[1,1,3,3]
; SSE2-NEXT:    pand %xmm12, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm11[1,1,3,3]
; SSE2-NEXT:    por %xmm9, %xmm10
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm4[1,1,3,3]
; SSE2-NEXT:    pxor %xmm11, %xmm11
; SSE2-NEXT:    pxor %xmm13, %xmm13
; SSE2-NEXT:    pcmpgtd %xmm9, %xmm13
; SSE2-NEXT:    pxor %xmm10, %xmm13
; SSE2-NEXT:    movdqa %xmm13, %xmm12
; SSE2-NEXT:    pandn %xmm0, %xmm12
; SSE2-NEXT:    movdqa {{.*#+}} xmm9 = [9223372036854775808,9223372036854775808]
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm0[1,1,3,3]
; SSE2-NEXT:    pandn %xmm9, %xmm0
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm10, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [9223372036854775807,9223372036854775807]
; SSE2-NEXT:    pand %xmm10, %xmm4
; SSE2-NEXT:    por %xmm4, %xmm0
; SSE2-NEXT:    pand %xmm13, %xmm0
; SSE2-NEXT:    por %xmm12, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm12
; SSE2-NEXT:    pxor %xmm8, %xmm12
; SSE2-NEXT:    paddq %xmm5, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    pxor %xmm8, %xmm4
; SSE2-NEXT:    movdqa %xmm12, %xmm13
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm13
; SSE2-NEXT:    pshufd {{.*#+}} xmm14 = xmm13[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm12, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    pand %xmm14, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm12 = xmm13[1,1,3,3]
; SSE2-NEXT:    por %xmm4, %xmm12
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[1,1,3,3]
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm5
; SSE2-NEXT:    pxor %xmm12, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm13
; SSE2-NEXT:    pandn %xmm1, %xmm13
; SSE2-NEXT:    pshufd {{.*#+}} xmm12 = xmm1[1,1,3,3]
; SSE2-NEXT:    pandn %xmm9, %xmm1
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm12, %xmm4
; SSE2-NEXT:    pand %xmm10, %xmm4
; SSE2-NEXT:    por %xmm4, %xmm1
; SSE2-NEXT:    pand %xmm5, %xmm1
; SSE2-NEXT:    por %xmm13, %xmm1
; SSE2-NEXT:    movdqa %xmm2, %xmm12
; SSE2-NEXT:    pxor %xmm8, %xmm12
; SSE2-NEXT:    paddq %xmm6, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm5
; SSE2-NEXT:    pxor %xmm8, %xmm5
; SSE2-NEXT:    movdqa %xmm12, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm12, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-NEXT:    pand %xmm13, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    por %xmm5, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm6
; SSE2-NEXT:    pxor %xmm4, %xmm6
; SSE2-NEXT:    movdqa %xmm6, %xmm4
; SSE2-NEXT:    pandn %xmm2, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm12 = xmm2[1,1,3,3]
; SSE2-NEXT:    pandn %xmm9, %xmm2
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm12, %xmm5
; SSE2-NEXT:    pand %xmm10, %xmm5
; SSE2-NEXT:    por %xmm5, %xmm2
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    por %xmm4, %xmm2
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    pxor %xmm8, %xmm4
; SSE2-NEXT:    paddq %xmm7, %xmm3
; SSE2-NEXT:    pxor %xmm3, %xmm8
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm8, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm8[1,1,3,3]
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[1,1,3,3]
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE2-NEXT:    pxor %xmm5, %xmm6
; SSE2-NEXT:    movdqa %xmm6, %xmm4
; SSE2-NEXT:    pandn %xmm3, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,1,3,3]
; SSE2-NEXT:    pandn %xmm9, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm11
; SSE2-NEXT:    pand %xmm10, %xmm11
; SSE2-NEXT:    por %xmm11, %xmm3
; SSE2-NEXT:    pand %xmm6, %xmm3
; SSE2-NEXT:    por %xmm4, %xmm3
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v8i64:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm8 = [2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm0, %xmm9
; SSSE3-NEXT:    pxor %xmm8, %xmm9
; SSSE3-NEXT:    paddq %xmm4, %xmm0
; SSSE3-NEXT:    movdqa %xmm0, %xmm10
; SSSE3-NEXT:    pxor %xmm8, %xmm10
; SSSE3-NEXT:    movdqa %xmm9, %xmm11
; SSSE3-NEXT:    pcmpgtd %xmm10, %xmm11
; SSSE3-NEXT:    pshufd {{.*#+}} xmm12 = xmm11[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm10
; SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm10[1,1,3,3]
; SSSE3-NEXT:    pand %xmm12, %xmm9
; SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm11[1,1,3,3]
; SSSE3-NEXT:    por %xmm9, %xmm10
; SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm4[1,1,3,3]
; SSSE3-NEXT:    pxor %xmm11, %xmm11
; SSSE3-NEXT:    pxor %xmm13, %xmm13
; SSSE3-NEXT:    pcmpgtd %xmm9, %xmm13
; SSSE3-NEXT:    pxor %xmm10, %xmm13
; SSSE3-NEXT:    movdqa %xmm13, %xmm12
; SSSE3-NEXT:    pandn %xmm0, %xmm12
; SSSE3-NEXT:    movdqa {{.*#+}} xmm9 = [9223372036854775808,9223372036854775808]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm0[1,1,3,3]
; SSSE3-NEXT:    pandn %xmm9, %xmm0
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm10, %xmm4
; SSSE3-NEXT:    movdqa {{.*#+}} xmm10 = [9223372036854775807,9223372036854775807]
; SSSE3-NEXT:    pand %xmm10, %xmm4
; SSSE3-NEXT:    por %xmm4, %xmm0
; SSSE3-NEXT:    pand %xmm13, %xmm0
; SSSE3-NEXT:    por %xmm12, %xmm0
; SSSE3-NEXT:    movdqa %xmm1, %xmm12
; SSSE3-NEXT:    pxor %xmm8, %xmm12
; SSSE3-NEXT:    paddq %xmm5, %xmm1
; SSSE3-NEXT:    movdqa %xmm1, %xmm4
; SSSE3-NEXT:    pxor %xmm8, %xmm4
; SSSE3-NEXT:    movdqa %xmm12, %xmm13
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm13
; SSSE3-NEXT:    pshufd {{.*#+}} xmm14 = xmm13[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm12, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    pand %xmm14, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm12 = xmm13[1,1,3,3]
; SSSE3-NEXT:    por %xmm4, %xmm12
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[1,1,3,3]
; SSSE3-NEXT:    pxor %xmm5, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm5
; SSSE3-NEXT:    pxor %xmm12, %xmm5
; SSSE3-NEXT:    movdqa %xmm5, %xmm13
; SSSE3-NEXT:    pandn %xmm1, %xmm13
; SSSE3-NEXT:    pshufd {{.*#+}} xmm12 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pandn %xmm9, %xmm1
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm12, %xmm4
; SSSE3-NEXT:    pand %xmm10, %xmm4
; SSSE3-NEXT:    por %xmm4, %xmm1
; SSSE3-NEXT:    pand %xmm5, %xmm1
; SSSE3-NEXT:    por %xmm13, %xmm1
; SSSE3-NEXT:    movdqa %xmm2, %xmm12
; SSSE3-NEXT:    pxor %xmm8, %xmm12
; SSSE3-NEXT:    paddq %xmm6, %xmm2
; SSSE3-NEXT:    movdqa %xmm2, %xmm5
; SSSE3-NEXT:    pxor %xmm8, %xmm5
; SSSE3-NEXT:    movdqa %xmm12, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm12, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSSE3-NEXT:    pand %xmm13, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    por %xmm5, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSSE3-NEXT:    pxor %xmm6, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm6
; SSSE3-NEXT:    pxor %xmm4, %xmm6
; SSSE3-NEXT:    movdqa %xmm6, %xmm4
; SSSE3-NEXT:    pandn %xmm2, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm12 = xmm2[1,1,3,3]
; SSSE3-NEXT:    pandn %xmm9, %xmm2
; SSSE3-NEXT:    pxor %xmm5, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm12, %xmm5
; SSSE3-NEXT:    pand %xmm10, %xmm5
; SSSE3-NEXT:    por %xmm5, %xmm2
; SSSE3-NEXT:    pand %xmm6, %xmm2
; SSSE3-NEXT:    por %xmm4, %xmm2
; SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSSE3-NEXT:    pxor %xmm8, %xmm4
; SSSE3-NEXT:    paddq %xmm7, %xmm3
; SSSE3-NEXT:    pxor %xmm3, %xmm8
; SSSE3-NEXT:    movdqa %xmm4, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm8, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm4, %xmm8
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm8[1,1,3,3]
; SSSE3-NEXT:    pand %xmm6, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSSE3-NEXT:    por %xmm4, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[1,1,3,3]
; SSSE3-NEXT:    pxor %xmm6, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm6
; SSSE3-NEXT:    pxor %xmm5, %xmm6
; SSSE3-NEXT:    movdqa %xmm6, %xmm4
; SSSE3-NEXT:    pandn %xmm3, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,1,3,3]
; SSSE3-NEXT:    pandn %xmm9, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm11
; SSSE3-NEXT:    pand %xmm10, %xmm11
; SSSE3-NEXT:    por %xmm11, %xmm3
; SSSE3-NEXT:    pand %xmm6, %xmm3
; SSSE3-NEXT:    por %xmm4, %xmm3
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v8i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm8
; SSE41-NEXT:    movdqa {{.*#+}} xmm10 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm10, %xmm0
; SSE41-NEXT:    paddq %xmm4, %xmm8
; SSE41-NEXT:    movdqa %xmm8, %xmm9
; SSE41-NEXT:    pxor %xmm10, %xmm9
; SSE41-NEXT:    movdqa %xmm0, %xmm11
; SSE41-NEXT:    pcmpeqd %xmm9, %xmm11
; SSE41-NEXT:    pcmpgtd %xmm9, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[0,0,2,2]
; SSE41-NEXT:    pand %xmm11, %xmm9
; SSE41-NEXT:    por %xmm0, %xmm9
; SSE41-NEXT:    pxor %xmm4, %xmm9
; SSE41-NEXT:    movapd {{.*#+}} xmm12 = [9223372036854775807,9223372036854775807]
; SSE41-NEXT:    movapd {{.*#+}} xmm11 = [9223372036854775808,9223372036854775808]
; SSE41-NEXT:    movapd %xmm11, %xmm4
; SSE41-NEXT:    movdqa %xmm8, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm12, %xmm4
; SSE41-NEXT:    movdqa %xmm9, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm8
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm10, %xmm0
; SSE41-NEXT:    paddq %xmm5, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm4
; SSE41-NEXT:    pxor %xmm10, %xmm4
; SSE41-NEXT:    movdqa %xmm0, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm4, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[0,0,2,2]
; SSE41-NEXT:    pand %xmm9, %xmm4
; SSE41-NEXT:    por %xmm0, %xmm4
; SSE41-NEXT:    pxor %xmm5, %xmm4
; SSE41-NEXT:    movapd %xmm11, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm12, %xmm5
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm10, %xmm0
; SSE41-NEXT:    paddq %xmm6, %xmm2
; SSE41-NEXT:    movdqa %xmm2, %xmm4
; SSE41-NEXT:    pxor %xmm10, %xmm4
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm4, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm4
; SSE41-NEXT:    por %xmm0, %xmm4
; SSE41-NEXT:    pxor %xmm6, %xmm4
; SSE41-NEXT:    movapd %xmm11, %xmm5
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm12, %xmm5
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm2
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    pxor %xmm10, %xmm0
; SSE41-NEXT:    paddq %xmm7, %xmm3
; SSE41-NEXT:    pxor %xmm3, %xmm10
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm10, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm4
; SSE41-NEXT:    por %xmm0, %xmm4
; SSE41-NEXT:    pxor %xmm7, %xmm4
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm12, %xmm11
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm11, %xmm3
; SSE41-NEXT:    movapd %xmm8, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v8i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpaddq %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpaddq %xmm2, %xmm0, %xmm6
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm6, %ymm7
; AVX1-NEXT:    vmovapd {{.*#+}} ymm8 = [9223372036854775807,9223372036854775807,9223372036854775807,9223372036854775807]
; AVX1-NEXT:    vmovapd {{.*#+}} ymm9 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vblendvpd %ymm7, %ymm8, %ymm9, %ymm10
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vxorpd %ymm0, %ymm2, %ymm0
; AVX1-NEXT:    vblendvpd %ymm0, %ymm10, %ymm7, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpaddq %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpaddq %xmm3, %xmm1, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm5, %ymm6
; AVX1-NEXT:    vblendvpd %ymm6, %ymm8, %ymm9, %ymm7
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vxorpd %ymm1, %ymm3, %ymm1
; AVX1-NEXT:    vblendvpd %ymm1, %ymm7, %ymm6, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v8i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm4
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm5 = [9223372036854775807,9223372036854775807,9223372036854775807,9223372036854775807]
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vblendvpd %ymm4, %ymm5, %ymm6, %ymm7
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vblendvpd %ymm0, %ymm7, %ymm4, %ymm0
; AVX2-NEXT:    vpaddq %ymm3, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm5, %ymm6, %ymm4
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vblendvpd %ymm1, %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512-NEXT:    vpcmpgtq %zmm1, %zmm2, %k0
; AVX512-NEXT:    vpaddq %zmm1, %zmm0, %zmm1
; AVX512-NEXT:    vpcmpgtq %zmm1, %zmm0, %k1
; AVX512-NEXT:    kxorw %k1, %k0, %k1
; AVX512-NEXT:    vpcmpgtq %zmm1, %zmm2, %k2
; AVX512-NEXT:    vpbroadcastq {{.*#+}} zmm0 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX512-NEXT:    vpbroadcastq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0 {%k2}
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-NEXT:    retq
  %z = call <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64> %x, <8 x i64> %y)
  ret <8 x i64> %z
}

define <2 x i128> @v2i128(<2 x i128> %x, <2 x i128> %y) nounwind {
; SSE-LABEL: v2i128:
; SSE:       # %bb.0:
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    movq %rdi, %rax
; SSE-NEXT:    addq {{[0-9]+}}(%rsp), %rcx
; SSE-NEXT:    adcq {{[0-9]+}}(%rsp), %r8
; SSE-NEXT:    seto %r10b
; SSE-NEXT:    movq %r8, %rbx
; SSE-NEXT:    sarq $63, %rbx
; SSE-NEXT:    testb %r10b, %r10b
; SSE-NEXT:    cmoveq %rcx, %rbx
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    testq %r8, %r8
; SSE-NEXT:    setns %cl
; SSE-NEXT:    movabsq $9223372036854775807, %r11 # imm = 0x7FFFFFFFFFFFFFFF
; SSE-NEXT:    addq %r11, %rcx
; SSE-NEXT:    testb %r10b, %r10b
; SSE-NEXT:    cmoveq %r8, %rcx
; SSE-NEXT:    addq %r9, %rsi
; SSE-NEXT:    adcq {{[0-9]+}}(%rsp), %rdx
; SSE-NEXT:    seto %r8b
; SSE-NEXT:    movq %rdx, %rdi
; SSE-NEXT:    sarq $63, %rdi
; SSE-NEXT:    testb %r8b, %r8b
; SSE-NEXT:    cmoveq %rsi, %rdi
; SSE-NEXT:    xorl %esi, %esi
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    setns %sil
; SSE-NEXT:    addq %r11, %rsi
; SSE-NEXT:    testb %r8b, %r8b
; SSE-NEXT:    cmoveq %rdx, %rsi
; SSE-NEXT:    movq %rbx, 16(%rax)
; SSE-NEXT:    movq %rdi, (%rax)
; SSE-NEXT:    movq %rcx, 24(%rax)
; SSE-NEXT:    movq %rsi, 8(%rax)
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    retq
;
; AVX-LABEL: v2i128:
; AVX:       # %bb.0:
; AVX-NEXT:    pushq %rbx
; AVX-NEXT:    movq %rdi, %rax
; AVX-NEXT:    addq {{[0-9]+}}(%rsp), %rcx
; AVX-NEXT:    adcq {{[0-9]+}}(%rsp), %r8
; AVX-NEXT:    seto %r10b
; AVX-NEXT:    movq %r8, %rbx
; AVX-NEXT:    sarq $63, %rbx
; AVX-NEXT:    testb %r10b, %r10b
; AVX-NEXT:    cmoveq %rcx, %rbx
; AVX-NEXT:    xorl %ecx, %ecx
; AVX-NEXT:    testq %r8, %r8
; AVX-NEXT:    setns %cl
; AVX-NEXT:    movabsq $9223372036854775807, %r11 # imm = 0x7FFFFFFFFFFFFFFF
; AVX-NEXT:    addq %r11, %rcx
; AVX-NEXT:    testb %r10b, %r10b
; AVX-NEXT:    cmoveq %r8, %rcx
; AVX-NEXT:    addq %r9, %rsi
; AVX-NEXT:    adcq {{[0-9]+}}(%rsp), %rdx
; AVX-NEXT:    seto %r8b
; AVX-NEXT:    movq %rdx, %rdi
; AVX-NEXT:    sarq $63, %rdi
; AVX-NEXT:    testb %r8b, %r8b
; AVX-NEXT:    cmoveq %rsi, %rdi
; AVX-NEXT:    xorl %esi, %esi
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    setns %sil
; AVX-NEXT:    addq %r11, %rsi
; AVX-NEXT:    testb %r8b, %r8b
; AVX-NEXT:    cmoveq %rdx, %rsi
; AVX-NEXT:    movq %rbx, 16(%rax)
; AVX-NEXT:    movq %rdi, (%rax)
; AVX-NEXT:    movq %rcx, 24(%rax)
; AVX-NEXT:    movq %rsi, 8(%rax)
; AVX-NEXT:    popq %rbx
; AVX-NEXT:    retq
  %z = call <2 x i128> @llvm.sadd.sat.v2i128(<2 x i128> %x, <2 x i128> %y)
  ret <2 x i128> %z
}
