; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -amdgpu-atomic-optimizations=true -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefix=GFX7LESS %s
; RUN: llc -march=amdgcn -mcpu=tonga -mattr=-flat-for-global -amdgpu-atomic-optimizations=true -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX89,GFX8 %s
; RUN: llc -march=amdgcn -mcpu=gfx900 -mattr=-flat-for-global -amdgpu-atomic-optimizations=true -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX89,GFX9 %s
; RUN: llc -march=amdgcn -mcpu=gfx1010 -mattr=-wavefrontsize32,+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizations=true -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX10,GFX1064 %s
; RUN: llc -march=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32,-wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizations=true -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX10,GFX1032 %s

declare i32 @llvm.amdgcn.workitem.id.x()

; Show what the atomic optimization pass will do for global pointers.

define amdgpu_kernel void @add_i32_constant(i32 addrspace(1)* %out, i32 addrspace(1)* %inout) {
; GFX7LESS-LABEL: add_i32_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz BB0_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_mul_i32 s6, s6, 5
; GFX7LESS-NEXT:    s_mov_b32 s10, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  BB0_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_mad_u32_u24 v0, v0, 5, s4
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX89-LABEL: add_i32_constant:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX89-NEXT:    s_mov_b64 s[6:7], exec
; GFX89-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX89-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX89-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX89-NEXT:    ; implicit-def: $vgpr1
; GFX89-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX89-NEXT:    s_cbranch_execz BB0_2
; GFX89-NEXT:  ; %bb.1:
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_mov_b32 s8, s2
; GFX89-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX89-NEXT:    s_mul_i32 s2, s2, 5
; GFX89-NEXT:    s_mov_b32 s11, 0xf000
; GFX89-NEXT:    s_mov_b32 s10, -1
; GFX89-NEXT:    s_mov_b32 s9, s3
; GFX89-NEXT:    v_mov_b32_e32 v1, s2
; GFX89-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX89-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    buffer_wbinvl1_vol
; GFX89-NEXT:  BB0_2:
; GFX89-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX89-NEXT:    v_readfirstlane_b32 s4, v1
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_mov_b32 s3, 0xf000
; GFX89-NEXT:    s_mov_b32 s2, -1
; GFX89-NEXT:    v_mad_u32_u24 v0, v0, 5, s4
; GFX89-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX89-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i32_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz BB0_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_mul_i32 s6, s6, 5
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    v_mov_b32_e32 v1, s6
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  BB0_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i32_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1032-NEXT:    s_mov_b32 s5, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s5, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz BB0_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_mul_i32 s5, s5, 5
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s5
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  BB0_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
entry:
  %old = atomicrmw add i32 addrspace(1)* %inout, i32 5 acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @add_i32_uniform(i32 addrspace(1)* %out, i32 addrspace(1)* %inout, i32 %additive) {
; GFX7LESS-LABEL: add_i32_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7LESS-NEXT:    s_load_dword s0, s[0:1], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX7LESS-NEXT:    s_cbranch_execz BB1_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s1, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mul_i32 s1, s0, s1
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_mov_b32 s12, s6
; GFX7LESS-NEXT:    s_mov_b32 s13, s7
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_atomic_add v1, off, s[12:15], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  BB1_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s1, v1
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s0, v0
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s1, v0
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i32_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dword s0, s[0:1], 0x34
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX8-NEXT:    s_cbranch_execz BB1_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s1, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mul_i32 s1, s0, s1
; GFX8-NEXT:    s_mov_b32 s15, 0xf000
; GFX8-NEXT:    s_mov_b32 s14, -1
; GFX8-NEXT:    s_mov_b32 s12, s6
; GFX8-NEXT:    s_mov_b32 s13, s7
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_atomic_add v1, off, s[12:15], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  BB1_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v0, s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v1
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i32_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[8:9], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s9, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz BB1_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s3, s[8:9]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s3, s2, s3
; GFX9-NEXT:    s_mov_b32 s15, 0xf000
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    s_mov_b32 s12, s6
; GFX9-NEXT:    s_mov_b32 s13, s7
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_atomic_add v1, off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  BB1_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v0, s2, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v1
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i32_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1064-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX1064-NEXT:    s_mov_b64 s[8:9], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s9, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz BB1_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s3, s[8:9]
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s3, s2, s3
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    v_mov_b32_e32 v1, s3
; GFX1064-NEXT:    s_mov_b32 s8, s6
; GFX1064-NEXT:    s_mov_b32 s9, s7
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  BB1_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mul_lo_u32 v0, s2, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX1064-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i32_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1032-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX1032-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz BB1_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s1, s3
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s1, s2, s1
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s1
; GFX1032-NEXT:    s_mov_b32 s8, s6
; GFX1032-NEXT:    s_mov_b32 s9, s7
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  BB1_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mul_lo_u32 v0, s2, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX1032-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX1032-NEXT:    s_endpgm
entry:
  %old = atomicrmw add i32 addrspace(1)* %inout, i32 %additive acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @add_i32_varying(i32 addrspace(1)* %out, i32 addrspace(1)* %inout) {
; GFX7LESS-LABEL: add_i32_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    s_mov_b32 s10, s6
; GFX7LESS-NEXT:    s_mov_b32 s11, s7
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:    s_mov_b32 s4, s0
; GFX7LESS-NEXT:    s_mov_b32 s5, s1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i32_varying:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b64 exec, s[4:5]
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8-NEXT:    v_readlane_b32 s6, v2, 63
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_mov_b64 exec, s[4:5]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz BB2_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_mov_b32 s11, 0xf000
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s8, s2
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  BB2_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i32_varying:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-NEXT:    v_readlane_b32 s6, v2, 63
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz BB2_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  BB2_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_add_u32_e32 v0, s4, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i32_varying:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v1
; GFX1064-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1064-NEXT:    v_mov_b32_e32 v2, s4
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1064-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1064-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1064-NEXT:    v_writelane_b32 v3, s6, 16
; GFX1064-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1064-NEXT:    v_readlane_b32 s9, v1, 63
; GFX1064-NEXT:    v_writelane_b32 v3, s7, 32
; GFX1064-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1064-NEXT:    s_mov_b32 s4, s9
; GFX1064-NEXT:    v_writelane_b32 v3, s8, 48
; GFX1064-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX1064-NEXT:    s_cbranch_execz BB2_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, s4
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s4, s2
; GFX1064-NEXT:    s_mov_b32 s5, s3
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    buffer_atomic_add v0, off, s[4:7], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  BB2_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; GFX1064-NEXT:    s_mov_b32 s2, s6
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i32_varying:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v1
; GFX1032-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1032-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    v_readlane_b32 s5, v1, 15
; GFX1032-NEXT:    v_readlane_b32 s6, v1, 31
; GFX1032-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    s_mov_b32 exec_lo, s4
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1032-NEXT:    v_writelane_b32 v3, s5, 16
; GFX1032-NEXT:    s_mov_b32 exec_lo, s4
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_mov_b32 s4, s6
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    s_and_saveexec_b32 s8, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz BB2_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, s4
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s4, s2
; GFX1032-NEXT:    s_mov_b32 s5, s3
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    buffer_atomic_add v0, off, s[4:7], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  BB2_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; GFX1032-NEXT:    s_mov_b32 s2, s6
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw add i32 addrspace(1)* %inout, i32 %lane acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @add_i64_constant(i64 addrspace(1)* %out, i64 addrspace(1)* %inout) {
; GFX7LESS-LABEL: add_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz BB3_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_mul_i32 s6, s6, 5
; GFX7LESS-NEXT:    s_mov_b32 s10, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, 0
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_atomic_add_x2 v[1:2], off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  BB3_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v0
; GFX7LESS-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s5
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s4, v0
; GFX7LESS-NEXT:    v_addc_u32_e32 v1, vcc, v2, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX89-LABEL: add_i64_constant:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX89-NEXT:    s_mov_b64 s[6:7], exec
; GFX89-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX89-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX89-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX89-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX89-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX89-NEXT:    s_cbranch_execz BB3_2
; GFX89-NEXT:  ; %bb.1:
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_mov_b32 s8, s2
; GFX89-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX89-NEXT:    s_mul_i32 s2, s2, 5
; GFX89-NEXT:    s_mov_b32 s11, 0xf000
; GFX89-NEXT:    s_mov_b32 s10, -1
; GFX89-NEXT:    s_mov_b32 s9, s3
; GFX89-NEXT:    v_mov_b32_e32 v1, s2
; GFX89-NEXT:    v_mov_b32_e32 v2, 0
; GFX89-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX89-NEXT:    buffer_atomic_add_x2 v[1:2], off, s[8:11], 0 glc
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    buffer_wbinvl1_vol
; GFX89-NEXT:  BB3_2:
; GFX89-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_readfirstlane_b32 s2, v1
; GFX89-NEXT:    v_readfirstlane_b32 s3, v2
; GFX89-NEXT:    v_mov_b32_e32 v1, s2
; GFX89-NEXT:    v_mov_b32_e32 v2, s3
; GFX89-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], v0, 5, v[1:2]
; GFX89-NEXT:    s_mov_b32 s3, 0xf000
; GFX89-NEXT:    s_mov_b32 s2, -1
; GFX89-NEXT:    s_nop 2
; GFX89-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX89-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz BB3_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    s_mul_i32 s6, s6, 5
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    v_mov_b32_e32 v1, s6
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    buffer_atomic_add_x2 v[1:2], off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  BB3_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v2
; GFX1064-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], v0, 5, s[2:3]
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1032-NEXT:    s_mov_b32 s5, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s5, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz BB3_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    s_mul_i32 s5, s5, 5
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    v_mov_b32_e32 v1, s5
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    buffer_atomic_add_x2 v[1:2], off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  BB3_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v2
; GFX1032-NEXT:    v_mad_u64_u32 v[0:1], s2, v0, 5, s[2:3]
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
entry:
  %old = atomicrmw add i64 addrspace(1)* %inout, i64 5 acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @add_i64_uniform(i64 addrspace(1)* %out, i64 addrspace(1)* %inout, i64 %additive) {
; GFX7LESS-LABEL: add_i64_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[8:9], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s8, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s9, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-NEXT:    s_cbranch_execz BB4_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s12, s6
; GFX7LESS-NEXT:    s_mov_b32 s13, s7
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[8:9]
; GFX7LESS-NEXT:    s_mul_i32 s7, s1, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    v_mul_hi_u32 v1, s0, v1
; GFX7LESS-NEXT:    s_mul_i32 s6, s0, s6
; GFX7LESS-NEXT:    v_add_i32_e32 v2, vcc, s7, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_atomic_add_x2 v[1:2], off, s[12:15], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  BB4_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s2, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s3, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mul_lo_u32 v1, s1, v0
; GFX7LESS-NEXT:    v_mul_hi_u32 v2, s0, v0
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s0, v0
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, v2, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s3
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s2, v0
; GFX7LESS-NEXT:    v_addc_u32_e32 v1, vcc, v2, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i64_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    s_mov_b64 s[8:9], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s9, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz BB4_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s12, s6
; GFX8-NEXT:    s_bcnt1_i32_b64 s6, s[8:9]
; GFX8-NEXT:    v_mov_b32_e32 v1, s6
; GFX8-NEXT:    v_mul_hi_u32 v1, s0, v1
; GFX8-NEXT:    s_mov_b32 s13, s7
; GFX8-NEXT:    s_mul_i32 s7, s1, s6
; GFX8-NEXT:    s_mul_i32 s6, s0, s6
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s7, v1
; GFX8-NEXT:    s_mov_b32 s15, 0xf000
; GFX8-NEXT:    s_mov_b32 s14, -1
; GFX8-NEXT:    v_mov_b32_e32 v1, s6
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_atomic_add_x2 v[1:2], off, s[12:15], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  BB4_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    v_readfirstlane_b32 s2, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v1, s1, v0
; GFX8-NEXT:    v_mul_hi_u32 v3, s0, v0
; GFX8-NEXT:    v_mul_lo_u32 v0, s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, v2, v1, vcc
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i64_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[8:9], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s9, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz BB4_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s6
; GFX9-NEXT:    s_bcnt1_i32_b64 s6, s[8:9]
; GFX9-NEXT:    s_mov_b32 s13, s7
; GFX9-NEXT:    s_mul_i32 s7, s3, s6
; GFX9-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX9-NEXT:    s_add_i32 s8, s8, s7
; GFX9-NEXT:    s_mul_i32 s6, s2, s6
; GFX9-NEXT:    s_mov_b32 s15, 0xf000
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_atomic_add_x2 v[1:2], off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  BB4_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v3, s3, v0
; GFX9-NEXT:    v_mul_hi_u32 v4, s2, v0
; GFX9-NEXT:    v_mul_lo_u32 v0, s2, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v1
; GFX9-NEXT:    v_readfirstlane_b32 s1, v2
; GFX9-NEXT:    v_add_u32_e32 v1, v4, v3
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, s0, v0
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i64_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1064-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX1064-NEXT:    s_mov_b64 s[8:9], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s9, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz BB4_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s8, s[8:9]
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s9, s3, s8
; GFX1064-NEXT:    s_mul_hi_u32 s10, s2, s8
; GFX1064-NEXT:    s_mul_i32 s8, s2, s8
; GFX1064-NEXT:    s_add_i32 s10, s10, s9
; GFX1064-NEXT:    v_mov_b32_e32 v1, s8
; GFX1064-NEXT:    v_mov_b32_e32 v2, s10
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_mov_b32 s8, s6
; GFX1064-NEXT:    s_mov_b32 s9, s7
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    buffer_atomic_add_x2 v[1:2], off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  BB4_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mul_lo_u32 v3, s3, v0
; GFX1064-NEXT:    v_mul_hi_u32 v4, s2, v0
; GFX1064-NEXT:    v_mul_lo_u32 v0, s2, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1064-NEXT:    v_readfirstlane_b32 s1, v2
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    v_add_nc_u32_e32 v1, v4, v3
; GFX1064-NEXT:    v_add_co_u32 v0, vcc, s0, v0
; GFX1064-NEXT:    v_add_co_ci_u32_e32 v1, vcc, s1, v1, vcc
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i64_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1032-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX1032-NEXT:    s_mov_b32 s8, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz BB4_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s1, s8
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s8, s3, s1
; GFX1032-NEXT:    s_mul_hi_u32 s9, s2, s1
; GFX1032-NEXT:    s_mul_i32 s1, s2, s1
; GFX1032-NEXT:    s_add_i32 s9, s9, s8
; GFX1032-NEXT:    v_mov_b32_e32 v1, s1
; GFX1032-NEXT:    v_mov_b32_e32 v2, s9
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_mov_b32 s8, s6
; GFX1032-NEXT:    s_mov_b32 s9, s7
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    buffer_atomic_add_x2 v[1:2], off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  BB4_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mul_lo_u32 v3, s3, v0
; GFX1032-NEXT:    v_mul_hi_u32 v4, s2, v0
; GFX1032-NEXT:    v_mul_lo_u32 v0, s2, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1032-NEXT:    v_readfirstlane_b32 s1, v2
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    v_add_nc_u32_e32 v1, v4, v3
; GFX1032-NEXT:    v_add_co_u32 v0, vcc_lo, s0, v0
; GFX1032-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, s1, v1, vcc_lo
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX1032-NEXT:    s_endpgm
entry:
  %old = atomicrmw add i64 addrspace(1)* %inout, i64 %additive acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @add_i64_varying(i64 addrspace(1)* %out, i64 addrspace(1)* %inout) {
; GFX7LESS-LABEL: add_i64_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 s10, s6
; GFX7LESS-NEXT:    s_mov_b32 s11, s7
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:    s_mov_b32 s4, s0
; GFX7LESS-NEXT:    s_mov_b32 s5, s1
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX89-LABEL: add_i64_varying:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX89-NEXT:    s_mov_b32 s3, 0xf000
; GFX89-NEXT:    s_mov_b32 s2, -1
; GFX89-NEXT:    v_mov_b32_e32 v1, 0
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_mov_b32 s0, s4
; GFX89-NEXT:    s_mov_b32 s1, s5
; GFX89-NEXT:    s_mov_b32 s4, s6
; GFX89-NEXT:    s_mov_b32 s5, s7
; GFX89-NEXT:    s_mov_b32 s6, s2
; GFX89-NEXT:    s_mov_b32 s7, s3
; GFX89-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX89-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[4:7], 0 glc
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    buffer_wbinvl1_vol
; GFX89-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX89-NEXT:    s_endpgm
;
; GFX10-LABEL: add_i64_varying:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_mov_b32 s7, 0x31016000
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    s_mov_b32 s11, s7
; GFX10-NEXT:    s_mov_b32 s10, s6
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s8, s2
; GFX10-NEXT:    s_mov_b32 s9, s3
; GFX10-NEXT:    s_mov_b32 s4, s0
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    s_mov_b32 s5, s1
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX10-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %zext = zext i32 %lane to i64
  %old = atomicrmw add i64 addrspace(1)* %inout, i64 %zext acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @sub_i32_constant(i32 addrspace(1)* %out, i32 addrspace(1)* %inout) {
; GFX7LESS-LABEL: sub_i32_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz BB6_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_mul_i32 s6, s6, 5
; GFX7LESS-NEXT:    s_mov_b32 s10, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  BB6_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s4, v0
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i32_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz BB6_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s8, s2
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX8-NEXT:    s_mul_i32 s2, s2, 5
; GFX8-NEXT:    s_mov_b32 s11, 0xf000
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  BB6_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s4, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i32_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz BB6_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX9-NEXT:    s_mul_i32 s2, s2, 5
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  BB6_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_sub_u32_e32 v0, s4, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i32_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz BB6_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_mul_i32 s6, s6, 5
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    v_mov_b32_e32 v1, s6
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  BB6_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i32_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1032-NEXT:    s_mov_b32 s5, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s5, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz BB6_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_mul_i32 s5, s5, 5
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s5
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  BB6_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1032-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub i32 addrspace(1)* %inout, i32 5 acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @sub_i32_uniform(i32 addrspace(1)* %out, i32 addrspace(1)* %inout, i32 %subitive) {
; GFX7LESS-LABEL: sub_i32_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7LESS-NEXT:    s_load_dword s0, s[0:1], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX7LESS-NEXT:    s_cbranch_execz BB7_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s1, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mul_i32 s1, s0, s1
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_mov_b32 s12, s6
; GFX7LESS-NEXT:    s_mov_b32 s13, s7
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_atomic_sub v1, off, s[12:15], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  BB7_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s1, v1
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s0, v0
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s1, v0
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i32_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dword s0, s[0:1], 0x34
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX8-NEXT:    s_cbranch_execz BB7_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s1, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mul_i32 s1, s0, s1
; GFX8-NEXT:    s_mov_b32 s15, 0xf000
; GFX8-NEXT:    s_mov_b32 s14, -1
; GFX8-NEXT:    s_mov_b32 s12, s6
; GFX8-NEXT:    s_mov_b32 s13, s7
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_atomic_sub v1, off, s[12:15], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  BB7_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v0, s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v1
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i32_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[8:9], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s9, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz BB7_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s3, s[8:9]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s3, s2, s3
; GFX9-NEXT:    s_mov_b32 s15, 0xf000
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    s_mov_b32 s12, s6
; GFX9-NEXT:    s_mov_b32 s13, s7
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_atomic_sub v1, off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  BB7_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v0, s2, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v1
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    v_sub_u32_e32 v0, s0, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i32_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1064-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX1064-NEXT:    s_mov_b64 s[8:9], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s9, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz BB7_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s3, s[8:9]
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s3, s2, s3
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    v_mov_b32_e32 v1, s3
; GFX1064-NEXT:    s_mov_b32 s8, s6
; GFX1064-NEXT:    s_mov_b32 s9, s7
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  BB7_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mul_lo_u32 v0, s2, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1064-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i32_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1032-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX1032-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz BB7_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s1, s3
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s1, s2, s1
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s1
; GFX1032-NEXT:    s_mov_b32 s8, s6
; GFX1032-NEXT:    s_mov_b32 s9, s7
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  BB7_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mul_lo_u32 v0, s2, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1032-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX1032-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub i32 addrspace(1)* %inout, i32 %subitive acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @sub_i32_varying(i32 addrspace(1)* %out, i32 addrspace(1)* %inout) {
; GFX7LESS-LABEL: sub_i32_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    s_mov_b32 s10, s6
; GFX7LESS-NEXT:    s_mov_b32 s11, s7
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:    s_mov_b32 s4, s0
; GFX7LESS-NEXT:    s_mov_b32 s5, s1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i32_varying:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_mov_b64 exec, s[4:5]
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    s_not_b64 exec, exec
; GFX8-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8-NEXT:    v_readlane_b32 s6, v2, 63
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8-NEXT:    s_mov_b64 exec, s[4:5]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz BB8_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_mov_b32 s11, 0xf000
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s8, s2
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  BB8_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s4, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i32_varying:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_not_b64 exec, exec
; GFX9-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_add_u32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-NEXT:    v_readlane_b32 s6, v2, 63
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz BB8_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  BB8_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_sub_u32_e32 v0, s4, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i32_varying:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_not_b64 exec, exec
; GFX1064-NEXT:    s_or_saveexec_b64 s[2:3], -1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v1
; GFX1064-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1064-NEXT:    v_mov_b32_e32 v2, s4
; GFX1064-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1064-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064-NEXT:    s_mov_b64 exec, s[2:3]
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1064-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1064-NEXT:    v_writelane_b32 v3, s6, 16
; GFX1064-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1064-NEXT:    v_readlane_b32 s9, v1, 63
; GFX1064-NEXT:    v_writelane_b32 v3, s7, 32
; GFX1064-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1064-NEXT:    s_mov_b32 s4, s9
; GFX1064-NEXT:    v_writelane_b32 v3, s8, 48
; GFX1064-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX1064-NEXT:    s_cbranch_execz BB8_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    v_mov_b32_e32 v0, s4
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s4, s2
; GFX1064-NEXT:    s_mov_b32 s5, s3
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    buffer_atomic_sub v0, off, s[4:7], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  BB8_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1064-NEXT:    s_mov_b32 s2, s6
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i32_varying:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_not_b32 exec_lo, exec_lo
; GFX1032-NEXT:    s_or_saveexec_b32 s2, -1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v1
; GFX1032-NEXT:    v_permlanex16_b32 v2, v2, -1, -1
; GFX1032-NEXT:    s_mov_b32 exec_lo, s2
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1032-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1032-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    v_readlane_b32 s5, v1, 15
; GFX1032-NEXT:    v_readlane_b32 s6, v1, 31
; GFX1032-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032-NEXT:    s_mov_b32 exec_lo, s4
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1032-NEXT:    v_writelane_b32 v3, s5, 16
; GFX1032-NEXT:    s_mov_b32 exec_lo, s4
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_mov_b32 s4, s6
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    s_and_saveexec_b32 s8, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz BB8_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    v_mov_b32_e32 v0, s4
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s4, s2
; GFX1032-NEXT:    s_mov_b32 s5, s3
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    buffer_atomic_sub v0, off, s[4:7], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  BB8_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1032-NEXT:    s_mov_b32 s2, s6
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw sub i32 addrspace(1)* %inout, i32 %lane acq_rel
  store i32 %old, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @sub_i64_constant(i64 addrspace(1)* %out, i64 addrspace(1)* %inout) {
; GFX7LESS-LABEL: sub_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz BB9_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_mul_i32 s6, s6, 5
; GFX7LESS-NEXT:    s_mov_b32 s10, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, 0
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_atomic_sub_x2 v[1:2], off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  BB9_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v0
; GFX7LESS-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s5
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s4, v0
; GFX7LESS-NEXT:    v_subb_u32_e32 v1, vcc, v2, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz BB9_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s8, s2
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX8-NEXT:    s_mul_i32 s2, s2, 5
; GFX8-NEXT:    s_mov_b32 s11, 0xf000
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_atomic_sub_x2 v[1:2], off, s[8:11], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  BB9_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_readfirstlane_b32 s5, v2
; GFX8-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v0
; GFX8-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s4, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_subb_u32_e32 v1, vcc, v2, v1, vcc
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz BB9_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX9-NEXT:    s_mul_i32 s2, s2, 5
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_atomic_sub_x2 v[1:2], off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  BB9_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_readfirstlane_b32 s5, v2
; GFX9-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v0
; GFX9-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, s4, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz BB9_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    s_mul_i32 s6, s6, 5
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    v_mov_b32_e32 v1, s6
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    buffer_atomic_sub_x2 v[1:2], off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  BB9_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    v_mul_u32_u24_e32 v1, 5, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v2
; GFX1064-NEXT:    v_mul_hi_u32_u24_e32 v2, 5, v0
; GFX1064-NEXT:    v_sub_co_u32 v0, vcc, s2, v1
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s3, v2, vcc
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1032-NEXT:    s_mov_b32 s5, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s5, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz BB9_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    s_mul_i32 s5, s5, 5
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    v_mov_b32_e32 v1, s5
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    buffer_atomic_sub_x2 v[1:2], off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  BB9_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1032-NEXT:    v_mul_u32_u24_e32 v1, 5, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v2
; GFX1032-NEXT:    v_mul_hi_u32_u24_e32 v2, 5, v0
; GFX1032-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v1
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s3, v2, vcc_lo
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub i64 addrspace(1)* %inout, i64 5 acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @sub_i64_uniform(i64 addrspace(1)* %out, i64 addrspace(1)* %inout, i64 %subitive) {
; GFX7LESS-LABEL: sub_i64_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[8:9], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s8, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s9, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-NEXT:    s_cbranch_execz BB10_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s12, s6
; GFX7LESS-NEXT:    s_mov_b32 s13, s7
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[8:9]
; GFX7LESS-NEXT:    s_mul_i32 s7, s1, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    v_mul_hi_u32 v1, s0, v1
; GFX7LESS-NEXT:    s_mul_i32 s6, s0, s6
; GFX7LESS-NEXT:    v_add_i32_e32 v2, vcc, s7, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_atomic_sub_x2 v[1:2], off, s[12:15], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  BB10_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s2, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s3, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mul_lo_u32 v1, s1, v0
; GFX7LESS-NEXT:    v_mul_hi_u32 v2, s0, v0
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s0, v0
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, v2, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s3
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s2, v0
; GFX7LESS-NEXT:    v_subb_u32_e32 v1, vcc, v2, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i64_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    s_mov_b64 s[8:9], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s9, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz BB10_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s12, s6
; GFX8-NEXT:    s_bcnt1_i32_b64 s6, s[8:9]
; GFX8-NEXT:    v_mov_b32_e32 v1, s6
; GFX8-NEXT:    v_mul_hi_u32 v1, s0, v1
; GFX8-NEXT:    s_mov_b32 s13, s7
; GFX8-NEXT:    s_mul_i32 s7, s1, s6
; GFX8-NEXT:    s_mul_i32 s6, s0, s6
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s7, v1
; GFX8-NEXT:    s_mov_b32 s15, 0xf000
; GFX8-NEXT:    s_mov_b32 s14, -1
; GFX8-NEXT:    v_mov_b32_e32 v1, s6
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_atomic_sub_x2 v[1:2], off, s[12:15], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  BB10_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    v_readfirstlane_b32 s2, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v1, s1, v0
; GFX8-NEXT:    v_mul_hi_u32 v3, s0, v0
; GFX8-NEXT:    v_mul_lo_u32 v0, s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s2, v0
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    v_subb_u32_e32 v1, vcc, v2, v1, vcc
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i64_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[8:9], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s9, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz BB10_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s6
; GFX9-NEXT:    s_bcnt1_i32_b64 s6, s[8:9]
; GFX9-NEXT:    s_mov_b32 s13, s7
; GFX9-NEXT:    s_mul_i32 s7, s3, s6
; GFX9-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX9-NEXT:    s_add_i32 s8, s8, s7
; GFX9-NEXT:    s_mul_i32 s6, s2, s6
; GFX9-NEXT:    s_mov_b32 s15, 0xf000
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_atomic_sub_x2 v[1:2], off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  BB10_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v3, s3, v0
; GFX9-NEXT:    v_mul_hi_u32 v4, s2, v0
; GFX9-NEXT:    v_mul_lo_u32 v0, s2, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v1
; GFX9-NEXT:    v_readfirstlane_b32 s1, v2
; GFX9-NEXT:    v_add_u32_e32 v1, v4, v3
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, s0, v0
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i64_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1064-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX1064-NEXT:    s_mov_b64 s[8:9], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s9, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz BB10_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s8, s[8:9]
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s9, s3, s8
; GFX1064-NEXT:    s_mul_hi_u32 s10, s2, s8
; GFX1064-NEXT:    s_mul_i32 s8, s2, s8
; GFX1064-NEXT:    s_add_i32 s10, s10, s9
; GFX1064-NEXT:    v_mov_b32_e32 v1, s8
; GFX1064-NEXT:    v_mov_b32_e32 v2, s10
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_mov_b32 s8, s6
; GFX1064-NEXT:    s_mov_b32 s9, s7
; GFX1064-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1064-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1064-NEXT:    buffer_atomic_sub_x2 v[1:2], off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  BB10_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mul_lo_u32 v3, s3, v0
; GFX1064-NEXT:    v_mul_hi_u32 v4, s2, v0
; GFX1064-NEXT:    v_mul_lo_u32 v0, s2, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1064-NEXT:    v_readfirstlane_b32 s1, v2
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    v_add_nc_u32_e32 v1, v4, v3
; GFX1064-NEXT:    v_sub_co_u32 v0, vcc, s0, v0
; GFX1064-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s1, v1, vcc
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i64_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1032-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX1032-NEXT:    s_mov_b32 s8, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz BB10_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s1, s8
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s8, s3, s1
; GFX1032-NEXT:    s_mul_hi_u32 s9, s2, s1
; GFX1032-NEXT:    s_mul_i32 s1, s2, s1
; GFX1032-NEXT:    s_add_i32 s9, s9, s8
; GFX1032-NEXT:    v_mov_b32_e32 v1, s1
; GFX1032-NEXT:    v_mov_b32_e32 v2, s9
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_mov_b32 s8, s6
; GFX1032-NEXT:    s_mov_b32 s9, s7
; GFX1032-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1032-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1032-NEXT:    buffer_atomic_sub_x2 v[1:2], off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  BB10_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mul_lo_u32 v3, s3, v0
; GFX1032-NEXT:    v_mul_hi_u32 v4, s2, v0
; GFX1032-NEXT:    v_mul_lo_u32 v0, s2, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1032-NEXT:    v_readfirstlane_b32 s1, v2
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    v_add_nc_u32_e32 v1, v4, v3
; GFX1032-NEXT:    v_sub_co_u32 v0, vcc_lo, s0, v0
; GFX1032-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s1, v1, vcc_lo
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX1032-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub i64 addrspace(1)* %inout, i64 %subitive acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @sub_i64_varying(i64 addrspace(1)* %out, i64 addrspace(1)* %inout) {
; GFX7LESS-LABEL: sub_i64_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 s10, s6
; GFX7LESS-NEXT:    s_mov_b32 s11, s7
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:    s_mov_b32 s4, s0
; GFX7LESS-NEXT:    s_mov_b32 s5, s1
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX89-LABEL: sub_i64_varying:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX89-NEXT:    s_mov_b32 s3, 0xf000
; GFX89-NEXT:    s_mov_b32 s2, -1
; GFX89-NEXT:    v_mov_b32_e32 v1, 0
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_mov_b32 s0, s4
; GFX89-NEXT:    s_mov_b32 s1, s5
; GFX89-NEXT:    s_mov_b32 s4, s6
; GFX89-NEXT:    s_mov_b32 s5, s7
; GFX89-NEXT:    s_mov_b32 s6, s2
; GFX89-NEXT:    s_mov_b32 s7, s3
; GFX89-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX89-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[4:7], 0 glc
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    buffer_wbinvl1_vol
; GFX89-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX89-NEXT:    s_endpgm
;
; GFX10-LABEL: sub_i64_varying:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_mov_b32 s7, 0x31016000
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    s_mov_b32 s11, s7
; GFX10-NEXT:    s_mov_b32 s10, s6
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s8, s2
; GFX10-NEXT:    s_mov_b32 s9, s3
; GFX10-NEXT:    s_mov_b32 s4, s0
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    s_mov_b32 s5, s1
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX10-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %zext = zext i32 %lane to i64
  %old = atomicrmw sub i64 addrspace(1)* %inout, i64 %zext acq_rel
  store i64 %old, i64 addrspace(1)* %out
  ret void
}
