/* file-dict.c generated by valac 0.40.8, the Vala compiler
 * generated from file-dict.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>


#define SKK_TYPE_DICT (skk_dict_get_type ())
#define SKK_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_DICT, SkkDict))
#define SKK_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_DICT, SkkDictClass))
#define SKK_IS_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_DICT))
#define SKK_IS_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_DICT))
#define SKK_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_DICT, SkkDictClass))

typedef struct _SkkDict SkkDict;
typedef struct _SkkDictClass SkkDictClass;
typedef struct _SkkDictPrivate SkkDictPrivate;

#define SKK_TYPE_CANDIDATE (skk_candidate_get_type ())
#define SKK_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_CANDIDATE, SkkCandidate))
#define SKK_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_CANDIDATE, SkkCandidateClass))
#define SKK_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_CANDIDATE))
#define SKK_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_CANDIDATE))
#define SKK_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_CANDIDATE, SkkCandidateClass))

typedef struct _SkkCandidate SkkCandidate;
typedef struct _SkkCandidateClass SkkCandidateClass;

#define SKK_TYPE_FILE_DICT (skk_file_dict_get_type ())
#define SKK_FILE_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_FILE_DICT, SkkFileDict))
#define SKK_FILE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_FILE_DICT, SkkFileDictClass))
#define SKK_IS_FILE_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_FILE_DICT))
#define SKK_IS_FILE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_FILE_DICT))
#define SKK_FILE_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_FILE_DICT, SkkFileDictClass))

typedef struct _SkkFileDict SkkFileDict;
typedef struct _SkkFileDictClass SkkFileDictClass;
typedef struct _SkkFileDictPrivate SkkFileDictPrivate;

#define SKK_TYPE_MEMORY_MAPPED_FILE (skk_memory_mapped_file_get_type ())
#define SKK_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFile))
#define SKK_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))
#define SKK_IS_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_IS_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_MEMORY_MAPPED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))

typedef struct _SkkMemoryMappedFile SkkMemoryMappedFile;
typedef struct _SkkMemoryMappedFileClass SkkMemoryMappedFileClass;

#define SKK_TYPE_ENCODING_CONVERTER (skk_encoding_converter_get_type ())
#define SKK_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter))
#define SKK_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))
#define SKK_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))

typedef struct _SkkEncodingConverter SkkEncodingConverter;
typedef struct _SkkEncodingConverterClass SkkEncodingConverterClass;
enum  {
	SKK_FILE_DICT_0_PROPERTY,
	SKK_FILE_DICT_READ_ONLY_PROPERTY,
	SKK_FILE_DICT_NUM_PROPERTIES
};
static GParamSpec* skk_file_dict_properties[SKK_FILE_DICT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SkkDict {
	GObject parent_instance;
	SkkDictPrivate * priv;
};

struct _SkkDictClass {
	GObjectClass parent_class;
	void (*reload) (SkkDict* self, GError** error);
	SkkCandidate** (*lookup) (SkkDict* self, const gchar* midasi, gboolean okuri, int* result_length1);
	gchar** (*complete) (SkkDict* self, const gchar* midasi, int* result_length1);
	gboolean (*select_candidate) (SkkDict* self, SkkCandidate* candidate);
	gboolean (*purge_candidate) (SkkDict* self, SkkCandidate* candidate);
	void (*save) (SkkDict* self, GError** error);
	gboolean (*get_read_only) (SkkDict* self);
};

struct _SkkFileDict {
	SkkDict parent_instance;
	SkkFileDictPrivate * priv;
};

struct _SkkFileDictClass {
	SkkDictClass parent_class;
};

struct _SkkFileDictPrivate {
	GFile* file;
	SkkMemoryMappedFile* mmap;
	gchar* etag;
	SkkEncodingConverter* converter;
	glong okuri_ari_offset;
	glong okuri_nasi_offset;
};

typedef enum  {
	SKK_SKK_DICT_ERROR_NOT_READABLE,
	SKK_SKK_DICT_ERROR_MALFORMED_INPUT
} SkkSkkDictError;
#define SKK_SKK_DICT_ERROR skk_skk_dict_error_quark ()

static gpointer skk_file_dict_parent_class = NULL;

GType skk_dict_get_type (void) G_GNUC_CONST;
GType skk_candidate_get_type (void) G_GNUC_CONST;
GType skk_file_dict_get_type (void) G_GNUC_CONST;
GType skk_memory_mapped_file_get_type (void) G_GNUC_CONST;
GType skk_encoding_converter_get_type (void) G_GNUC_CONST;
#define SKK_FILE_DICT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_FILE_DICT, SkkFileDictPrivate))
static gchar* skk_file_dict_read_line (SkkFileDict* self,
                                glong* offset);
gsize skk_memory_mapped_file_get_length (SkkMemoryMappedFile* self);
void* skk_memory_mapped_file_get_memory (SkkMemoryMappedFile* self);
static gchar* skk_file_dict_read_previous_line (SkkFileDict* self,
                                         glong* pos,
                                         const gchar* line);
static gchar* skk_file_dict_read_next_line (SkkFileDict* self,
                                     glong* pos,
                                     const gchar* line);
static gboolean skk_file_dict_read_until (SkkFileDict* self,
                                   glong* offset,
                                   const gchar* line);
GQuark skk_skk_dict_error_quark (void);
static void skk_file_dict_load (SkkFileDict* self,
                         GError** error);
void skk_memory_mapped_file_remap (SkkMemoryMappedFile* self,
                                   GError** error);
gchar* skk_encoding_converter_extract_coding_system (const gchar* line);
SkkEncodingConverter* skk_encoding_converter_new_from_coding_system (const gchar* coding,
                                                                     GError** error);
SkkEncodingConverter* skk_encoding_converter_construct_from_coding_system (GType object_type,
                                                                           const gchar* coding,
                                                                           GError** error);
static void skk_file_dict_real_reload (SkkDict* base,
                                GError** error);
static gboolean skk_file_dict_search_pos (SkkFileDict* self,
                                   const gchar* midasi,
                                   glong start_offset,
                                   glong end_offset,
                                   GCompareFunc cmp,
                                   glong* pos,
                                   gchar* * line,
                                   gint direction);
static SkkCandidate** skk_file_dict_real_lookup (SkkDict* base,
                                          const gchar* midasi,
                                          gboolean okuri,
                                          int* result_length1);
gchar* skk_encoding_converter_encode (SkkEncodingConverter* self,
                                      const gchar* internal_str,
                                      GError** error);
gchar* skk_encoding_converter_decode (SkkEncodingConverter* self,
                                      const gchar* external_str,
                                      GError** error);
SkkCandidate** skk_dict_split_candidates (SkkDict* self,
                                          const gchar* midasi,
                                          gboolean okuri,
                                          const gchar* line,
                                          int* result_length1);
static gint skk_file_dict_strcmp_prefix (const gchar* a,
                                  const gchar* b);
static gchar** skk_file_dict_real_complete (SkkDict* base,
                                     const gchar* midasi,
                                     int* result_length1);
static gint _skk_file_dict_strcmp_prefix_gcompare_func (gconstpointer a,
                                                 gconstpointer b);
SkkFileDict* skk_file_dict_new (const gchar* path,
                                const gchar* encoding,
                                GError** error);
SkkFileDict* skk_file_dict_construct (GType object_type,
                                      const gchar* path,
                                      const gchar* encoding,
                                      GError** error);
SkkDict* skk_dict_construct (GType object_type);
SkkMemoryMappedFile* skk_memory_mapped_file_new (GFile* file);
SkkMemoryMappedFile* skk_memory_mapped_file_construct (GType object_type,
                                                       GFile* file);
SkkEncodingConverter* skk_encoding_converter_new (const gchar* encoding,
                                                  GError** error);
SkkEncodingConverter* skk_encoding_converter_construct (GType object_type,
                                                        const gchar* encoding,
                                                        GError** error);
void skk_dict_reload (SkkDict* self,
                      GError** error);
static void skk_file_dict_finalize (GObject * obj);
gboolean skk_dict_get_read_only (SkkDict* self);
static void _vala_skk_file_dict_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);


static gchar*
skk_file_dict_read_line (SkkFileDict* self,
                         glong* offset)
{
	gchar* result = NULL;
	SkkMemoryMappedFile* _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	gchar* p = NULL;
	SkkMemoryMappedFile* _tmp3_;
	void* _tmp4_;
	void* _tmp5_;
	GString* builder = NULL;
	GString* _tmp12_;
	glong _offset = 0L;
	GString* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = skk_memory_mapped_file_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (((gsize) (*offset)) < _tmp2_, NULL);
	_tmp3_ = self->priv->mmap;
	_tmp4_ = skk_memory_mapped_file_get_memory (_tmp3_);
	_tmp5_ = _tmp4_;
	p = ((gchar*) _tmp5_) + (*offset);
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			gchar* _tmp9_;
			if (!_tmp6_) {
				glong _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = *offset;
				*offset = _tmp7_ - 1;
				_tmp8_ = p;
				p = _tmp8_ - 1;
			}
			_tmp6_ = FALSE;
			if (!((*offset) > ((glong) 0))) {
				break;
			}
			_tmp9_ = p;
			if ((*_tmp9_) == '\n') {
				break;
			}
		}
	}
	if ((*offset) > ((glong) 0)) {
		glong _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = *offset;
		*offset = _tmp10_ + 1;
		_tmp11_ = p;
		p = _tmp11_ + 1;
	}
	_tmp12_ = g_string_new ("");
	builder = _tmp12_;
	_offset = *offset;
	{
		gboolean _tmp13_ = FALSE;
		_tmp13_ = TRUE;
		while (TRUE) {
			glong _tmp16_;
			SkkMemoryMappedFile* _tmp17_;
			gsize _tmp18_;
			gsize _tmp19_;
			gchar* _tmp20_;
			GString* _tmp21_;
			gchar* _tmp22_;
			if (!_tmp13_) {
				glong _tmp14_;
				gchar* _tmp15_;
				_tmp14_ = _offset;
				_offset = _tmp14_ + 1;
				_tmp15_ = p;
				p = _tmp15_ + 1;
			}
			_tmp13_ = FALSE;
			_tmp16_ = _offset;
			_tmp17_ = self->priv->mmap;
			_tmp18_ = skk_memory_mapped_file_get_length (_tmp17_);
			_tmp19_ = _tmp18_;
			if (!(((gsize) _tmp16_) < _tmp19_)) {
				break;
			}
			_tmp20_ = p;
			if ((*_tmp20_) == '\n') {
				break;
			}
			_tmp21_ = builder;
			_tmp22_ = p;
			g_string_append_c (_tmp21_, *_tmp22_);
		}
	}
	_tmp23_ = builder;
	_tmp24_ = _tmp23_->str;
	_tmp25_ = g_strdup (_tmp24_);
	result = _tmp25_;
	_g_string_free0 (builder);
	return result;
}


static gchar*
skk_file_dict_read_previous_line (SkkFileDict* self,
                                  glong* pos,
                                  const gchar* line)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	if ((*pos) < ((glong) 2)) {
		result = NULL;
		return result;
	}
	*pos = (*pos) - 2;
	_tmp0_ = skk_file_dict_read_line (self, pos);
	result = _tmp0_;
	return result;
}


static gchar*
skk_file_dict_read_next_line (SkkFileDict* self,
                              glong* pos,
                              const gchar* line)
{
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	SkkMemoryMappedFile* _tmp2_;
	gsize _tmp3_;
	gsize _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = strlen (line);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->mmap;
	_tmp3_ = skk_memory_mapped_file_get_length (_tmp2_);
	_tmp4_ = _tmp3_;
	if (((gsize) (((*pos) + _tmp1_) + 1)) >= _tmp4_) {
		result = NULL;
		return result;
	}
	_tmp5_ = strlen (line);
	_tmp6_ = _tmp5_;
	*pos = (*pos) + (_tmp6_ + 1);
	_tmp7_ = skk_file_dict_read_line (self, pos);
	result = _tmp7_;
	return result;
}


static gboolean
skk_file_dict_read_until (SkkFileDict* self,
                          glong* offset,
                          const gchar* line)
{
	gboolean result = FALSE;
	SkkMemoryMappedFile* _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = skk_memory_mapped_file_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (((gsize) (*offset)) < _tmp2_, NULL);
	while (TRUE) {
		gint _tmp3_;
		gint _tmp4_;
		SkkMemoryMappedFile* _tmp5_;
		gsize _tmp6_;
		gsize _tmp7_;
		gchar* p = NULL;
		SkkMemoryMappedFile* _tmp8_;
		void* _tmp9_;
		void* _tmp10_;
		gboolean _tmp11_ = FALSE;
		gchar* _tmp12_;
		glong _tmp18_;
		_tmp3_ = strlen (line);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->mmap;
		_tmp6_ = skk_memory_mapped_file_get_length (_tmp5_);
		_tmp7_ = _tmp6_;
		if (!(((gsize) ((*offset) + _tmp4_)) < _tmp7_)) {
			break;
		}
		_tmp8_ = self->priv->mmap;
		_tmp9_ = skk_memory_mapped_file_get_memory (_tmp8_);
		_tmp10_ = _tmp9_;
		p = ((gchar*) _tmp10_) + (*offset);
		_tmp12_ = p;
		if ((*_tmp12_) == '\n') {
			gchar* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp13_ = p;
			_tmp14_ = strlen (line);
			_tmp15_ = _tmp14_;
			_tmp11_ = memcmp (_tmp13_ + 1, (void*) line, (gsize) _tmp15_) == 0;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			gint _tmp16_;
			gint _tmp17_;
			_tmp16_ = strlen (line);
			_tmp17_ = _tmp16_;
			*offset = (*offset) + _tmp17_;
			result = TRUE;
			return result;
		}
		_tmp18_ = *offset;
		*offset = _tmp18_ + 1;
	}
	result = FALSE;
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
skk_file_dict_load (SkkFileDict* self,
                    GError** error)
{
	SkkMemoryMappedFile* _tmp0_;
	glong offset = 0L;
	gchar* line = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* coding = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp15_;
	glong _tmp17_;
	gboolean _tmp18_;
	glong _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mmap;
	skk_memory_mapped_file_remap (_tmp0_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	offset = (glong) 0;
	_tmp1_ = skk_file_dict_read_line (self, &offset);
	line = _tmp1_;
	_tmp2_ = line;
	if (_tmp2_ == NULL) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "can't read the first line");
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			return;
		} else {
			_g_free0 (line);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = line;
	_tmp5_ = skk_encoding_converter_extract_coding_system (_tmp4_);
	coding = _tmp5_;
	_tmp6_ = coding;
	if (_tmp6_ != NULL) {
		{
			SkkEncodingConverter* _converter = NULL;
			const gchar* _tmp7_;
			SkkEncodingConverter* _tmp8_;
			SkkEncodingConverter* _tmp9_;
			_tmp7_ = coding;
			_tmp8_ = skk_encoding_converter_new_from_coding_system (_tmp7_, &_inner_error_);
			_converter = _tmp8_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp9_ = _converter;
			if (_tmp9_ != NULL) {
				SkkEncodingConverter* _tmp10_;
				SkkEncodingConverter* _tmp11_;
				_tmp10_ = _converter;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				_g_object_unref0 (self->priv->converter);
				self->priv->converter = _tmp11_;
			}
			_g_object_unref0 (_converter);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp12_;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = coding;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			g_warning ("file-dict.vala:105: can't create converter from coding system %s: %s", _tmp12_, _tmp14_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (coding);
				_g_free0 (line);
				return;
			} else {
				_g_free0 (coding);
				_g_free0 (line);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	offset = (glong) 0;
	_tmp15_ = skk_file_dict_read_until (self, &offset, ";; okuri-ari entries.\n");
	if (!_tmp15_) {
		GError* _tmp16_;
		_tmp16_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "no okuri-ari boundary");
		_inner_error_ = _tmp16_;
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (coding);
			_g_free0 (line);
			return;
		} else {
			_g_free0 (coding);
			_g_free0 (line);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp17_ = offset;
	self->priv->okuri_ari_offset = _tmp17_;
	_tmp18_ = skk_file_dict_read_until (self, &offset, ";; okuri-nasi entries.\n");
	if (!_tmp18_) {
		GError* _tmp19_;
		_tmp19_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "no okuri-nasi boundary");
		_inner_error_ = _tmp19_;
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (coding);
			_g_free0 (line);
			return;
		} else {
			_g_free0 (coding);
			_g_free0 (line);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp20_ = offset;
	self->priv->okuri_nasi_offset = _tmp20_;
	_g_free0 (coding);
	_g_free0 (line);
}


/**
         * {@inheritDoc}
         */
static void
skk_file_dict_real_reload (SkkDict* base,
                           GError** error)
{
	SkkFileDict * self;
	gchar* attributes = NULL;
	gchar* _tmp0_;
	GFileInfo* info = NULL;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (SkkFileDict*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_query_info (_tmp1_, attributes, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attributes);
		return;
	}
	_tmp3_ = g_file_info_get_etag (info);
	_tmp4_ = self->priv->etag;
	if (g_strcmp0 (_tmp3_, _tmp4_) != 0) {
		{
			const gchar* _tmp5_;
			gchar* _tmp6_;
			skk_file_dict_load (self, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
					goto __catch3_skk_skk_dict_error;
				}
				_g_object_unref0 (info);
				_g_free0 (attributes);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp5_ = g_file_info_get_etag (info);
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (self->priv->etag);
			self->priv->etag = _tmp6_;
		}
		goto __finally3;
		__catch3_skk_skk_dict_error:
		{
			GError* e = NULL;
			GFile* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp7_ = self->priv->file;
			_tmp8_ = g_file_get_path (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("file-dict.vala:140: error loading file dictionary %s %s", _tmp9_, _tmp11_);
			_g_free0 (_tmp9_);
			_g_error_free0 (e);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
	}
	_g_object_unref0 (info);
	_g_free0 (attributes);
}


static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = string_length;
		start = _tmp2_ + start;
	}
	if (end < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		end = _tmp3_ + end;
	}
	if (start >= ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		_tmp4_ = start <= _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_val_if_fail (_tmp4_, NULL);
	if (end >= ((glong) 0)) {
		glong _tmp7_;
		_tmp7_ = string_length;
		_tmp6_ = end <= _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_val_if_fail (_tmp6_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp8_;
	return result;
}


static gboolean
skk_file_dict_search_pos (SkkFileDict* self,
                          const gchar* midasi,
                          glong start_offset,
                          glong end_offset,
                          GCompareFunc cmp,
                          glong* pos,
                          gchar* * line,
                          gint direction)
{
	glong _vala_pos = 0L;
	gchar* _vala_line = NULL;
	gboolean result = FALSE;
	glong offset = 0L;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (midasi != NULL, FALSE);
	offset = start_offset + ((end_offset - start_offset) / 2);
	while (TRUE) {
		glong _tmp0_;
		SkkMemoryMappedFile* _tmp1_;
		gsize _tmp2_;
		gsize _tmp3_;
		gchar* _line = NULL;
		gchar* _tmp4_;
		gint index = 0;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint r = 0;
		const gchar* _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp17_;
		if (!(start_offset <= end_offset)) {
			break;
		}
		_tmp0_ = offset;
		_tmp1_ = self->priv->mmap;
		_tmp2_ = skk_memory_mapped_file_get_length (_tmp1_);
		_tmp3_ = _tmp2_;
		_vala_assert (((gsize) _tmp0_) < _tmp3_, "offset < mmap.length");
		_tmp4_ = skk_file_dict_read_line (self, &offset);
		_line = _tmp4_;
		_tmp5_ = _line;
		index = string_index_of (_tmp5_, " ", 0);
		_tmp6_ = index;
		if (_tmp6_ < 1) {
			const gchar* _tmp7_;
			_tmp7_ = _line;
			g_warning ("file-dict.vala:160: corrupted dictionary entry: %s", _tmp7_);
			_g_free0 (_line);
			break;
		}
		_tmp8_ = _line;
		_tmp9_ = index;
		_tmp10_ = string_slice (_tmp8_, (glong) 0, (glong) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = cmp (_tmp11_, midasi);
		_g_free0 (_tmp11_);
		r = _tmp12_;
		_tmp13_ = r;
		if (_tmp13_ == 0) {
			glong _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp14_ = offset;
			_vala_pos = _tmp14_;
			_tmp15_ = _line;
			_tmp16_ = g_strdup (_tmp15_);
			_g_free0 (_vala_line);
			_vala_line = _tmp16_;
			result = TRUE;
			_g_free0 (_line);
			if (pos) {
				*pos = _vala_pos;
			}
			if (line) {
				*line = _vala_line;
			} else {
				_g_free0 (_vala_line);
			}
			return result;
		}
		_tmp17_ = r;
		if ((_tmp17_ * direction) > 0) {
			glong _tmp18_;
			_tmp18_ = offset;
			end_offset = _tmp18_ - 2;
		} else {
			glong _tmp19_;
			const gchar* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			_tmp19_ = offset;
			_tmp20_ = _line;
			_tmp21_ = strlen (_tmp20_);
			_tmp22_ = _tmp21_;
			start_offset = (_tmp19_ + _tmp22_) + 1;
		}
		offset = start_offset + ((end_offset - start_offset) / 2);
		_g_free0 (_line);
	}
	_vala_pos = (glong) -1;
	_g_free0 (_vala_line);
	_vala_line = NULL;
	result = FALSE;
	if (pos) {
		*pos = _vala_pos;
	}
	if (line) {
		*line = _vala_line;
	} else {
		_g_free0 (_vala_line);
	}
	return result;
}


/**
         * {@inheritDoc}
         */
static SkkCandidate**
skk_file_dict_real_lookup (SkkDict* base,
                           const gchar* midasi,
                           gboolean okuri,
                           int* result_length1)
{
	SkkFileDict * self;
	SkkCandidate** result = NULL;
	SkkMemoryMappedFile* _tmp0_;
	void* _tmp1_;
	void* _tmp2_;
	glong start_offset = 0L;
	glong end_offset = 0L;
	gchar* _midasi = NULL;
	glong pos = 0L;
	gchar* line = NULL;
	gint _tmp19_ = 0;
	const gchar* _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	GCompareFunc _tmp23_;
	glong _tmp24_ = 0L;
	gchar* _tmp25_ = NULL;
	gboolean _tmp26_;
	SkkCandidate** _tmp50_;
	SkkCandidate** _tmp51_;
	gint _tmp51__length1;
	GError * _inner_error_ = NULL;
	self = (SkkFileDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = skk_memory_mapped_file_get_memory (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		SkkCandidate** _tmp3_;
		SkkCandidate** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	if (okuri) {
		glong _tmp5_;
		glong _tmp6_;
		_tmp5_ = self->priv->okuri_ari_offset;
		start_offset = _tmp5_;
		_tmp6_ = self->priv->okuri_nasi_offset;
		end_offset = _tmp6_;
	} else {
		glong _tmp7_;
		SkkMemoryMappedFile* _tmp8_;
		gsize _tmp9_;
		gsize _tmp10_;
		_tmp7_ = self->priv->okuri_nasi_offset;
		start_offset = _tmp7_;
		_tmp8_ = self->priv->mmap;
		_tmp9_ = skk_memory_mapped_file_get_length (_tmp8_);
		_tmp10_ = _tmp9_;
		end_offset = ((glong) _tmp10_) - 1;
	}
	{
		gchar* _tmp11_ = NULL;
		SkkEncodingConverter* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = self->priv->converter;
		_tmp13_ = skk_encoding_converter_encode (_tmp12_, midasi, &_inner_error_);
		_tmp11_ = _tmp13_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp14_ = _tmp11_;
		_tmp11_ = NULL;
		_g_free0 (_midasi);
		_midasi = _tmp14_;
		_g_free0 (_tmp11_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		SkkCandidate** _tmp17_;
		SkkCandidate** _tmp18_;
		gint _tmp18__length1;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_warning ("file-dict.vala:202: can't encode %s: %s", midasi, _tmp16_);
		_tmp17_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp18_ = _tmp17_;
		_tmp18__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp18__length1;
		}
		result = _tmp18_;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (_midasi);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	if (okuri) {
		_tmp19_ = -1;
	} else {
		_tmp19_ = 1;
	}
	_tmp20_ = _midasi;
	_tmp21_ = start_offset;
	_tmp22_ = end_offset;
	_tmp23_ = g_strcmp0;
	_tmp26_ = skk_file_dict_search_pos (self, _tmp20_, _tmp21_, _tmp22_, _tmp23_, &_tmp24_, &_tmp25_, _tmp19_);
	pos = _tmp24_;
	_g_free0 (line);
	line = _tmp25_;
	if (_tmp26_) {
		gint index = 0;
		const gchar* _tmp27_;
		gchar* _line = NULL;
		gint _tmp28_;
		_tmp27_ = line;
		index = string_index_of (_tmp27_, " ", 0);
		_tmp28_ = index;
		if (_tmp28_ > 0) {
			const gchar* _tmp46_;
			gint _tmp47_;
			SkkCandidate** _tmp48_;
			SkkCandidate** _tmp49_;
			gint _tmp49__length1;
			{
				gchar* _tmp29_ = NULL;
				SkkEncodingConverter* _tmp30_;
				const gchar* _tmp31_;
				gint _tmp32_;
				const gchar* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp30_ = self->priv->converter;
				_tmp31_ = line;
				_tmp32_ = index;
				_tmp33_ = line;
				_tmp34_ = strlen (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = string_slice (_tmp31_, (glong) _tmp32_, (glong) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = skk_encoding_converter_decode (_tmp30_, _tmp37_, &_inner_error_);
				_tmp39_ = _tmp38_;
				_g_free0 (_tmp37_);
				_tmp29_ = _tmp39_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch5_g_error;
				}
				_tmp40_ = _tmp29_;
				_tmp29_ = NULL;
				_g_free0 (_line);
				_line = _tmp40_;
				_g_free0 (_tmp29_);
			}
			goto __finally5;
			__catch5_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp41_;
				GError* _tmp42_;
				const gchar* _tmp43_;
				SkkCandidate** _tmp44_;
				SkkCandidate** _tmp45_;
				gint _tmp45__length1;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp41_ = line;
				_tmp42_ = e;
				_tmp43_ = _tmp42_->message;
				g_warning ("file-dict.vala:221: can't decode line %s: %s", _tmp41_, _tmp43_);
				_tmp44_ = g_new0 (SkkCandidate*, 0 + 1);
				_tmp45_ = _tmp44_;
				_tmp45__length1 = 0;
				if (result_length1) {
					*result_length1 = _tmp45__length1;
				}
				result = _tmp45_;
				_g_error_free0 (e);
				_g_free0 (_line);
				_g_free0 (line);
				_g_free0 (_midasi);
				return result;
			}
			__finally5:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (_line);
				_g_free0 (line);
				_g_free0 (_midasi);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp46_ = _line;
			_tmp48_ = skk_dict_split_candidates ((SkkDict*) self, midasi, okuri, _tmp46_, &_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp49__length1 = _tmp47_;
			if (result_length1) {
				*result_length1 = _tmp49__length1;
			}
			result = _tmp49_;
			_g_free0 (_line);
			_g_free0 (line);
			_g_free0 (_midasi);
			return result;
		}
		_g_free0 (_line);
	}
	_tmp50_ = g_new0 (SkkCandidate*, 0 + 1);
	_tmp51_ = _tmp50_;
	_tmp51__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp51__length1;
	}
	result = _tmp51_;
	_g_free0 (line);
	_g_free0 (_midasi);
	return result;
}


static gint
skk_file_dict_strcmp_prefix (const gchar* a,
                             const gchar* b)
{
	gint result = 0;
	GCompareFunc _tmp0_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if (g_str_has_prefix (a, b)) {
		result = 0;
		return result;
	}
	_tmp0_ = g_strcmp0;
	result = _tmp0_ (a, b);
	return result;
}


/**
         * {@inheritDoc}
         */
static gint
_skk_file_dict_strcmp_prefix_gcompare_func (gconstpointer a,
                                            gconstpointer b)
{
	gint result;
	result = skk_file_dict_strcmp_prefix ((const gchar*) a, (const gchar*) b);
	return result;
}


static gchar**
skk_file_dict_real_complete (SkkDict* base,
                             const gchar* midasi,
                             int* result_length1)
{
	SkkFileDict * self;
	gchar** result = NULL;
	SkkMemoryMappedFile* _tmp0_;
	void* _tmp1_;
	void* _tmp2_;
	GeeArrayList* completion = NULL;
	GeeArrayList* _tmp5_;
	glong start_offset = 0L;
	glong end_offset = 0L;
	glong _tmp6_;
	SkkMemoryMappedFile* _tmp7_;
	gsize _tmp8_;
	gsize _tmp9_;
	gchar* _midasi = NULL;
	glong pos = 0L;
	gchar* line = NULL;
	const gchar* _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	glong _tmp23_ = 0L;
	gchar* _tmp24_ = NULL;
	gboolean _tmp25_;
	GeeArrayList* _tmp77_;
	gint _tmp78_;
	gpointer* _tmp79_;
	gchar** _tmp80_;
	gint _tmp80__length1;
	GError * _inner_error_ = NULL;
	self = (SkkFileDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = skk_memory_mapped_file_get_memory (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (gchar*, 0 + 1);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	completion = _tmp5_;
	_tmp6_ = self->priv->okuri_nasi_offset;
	start_offset = _tmp6_;
	_tmp7_ = self->priv->mmap;
	_tmp8_ = skk_memory_mapped_file_get_length (_tmp7_);
	_tmp9_ = _tmp8_;
	end_offset = ((glong) _tmp9_) - 1;
	{
		gchar* _tmp10_ = NULL;
		SkkEncodingConverter* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = self->priv->converter;
		_tmp12_ = skk_encoding_converter_encode (_tmp11_, midasi, &_inner_error_);
		_tmp10_ = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp13_ = _tmp10_;
		_tmp10_ = NULL;
		_g_free0 (_midasi);
		_midasi = _tmp13_;
		_g_free0 (_tmp10_);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gpointer* _tmp18_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("file-dict.vala:254: can't decode %s: %s", midasi, _tmp15_);
		_tmp16_ = completion;
		_tmp18_ = gee_collection_to_array ((GeeCollection*) _tmp16_, &_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp19__length1 = _tmp17_;
		if (result_length1) {
			*result_length1 = _tmp19__length1;
		}
		result = _tmp19_;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		_g_object_unref0 (completion);
		return result;
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (_midasi);
		_g_object_unref0 (completion);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp20_ = _midasi;
	_tmp21_ = start_offset;
	_tmp22_ = end_offset;
	_tmp25_ = skk_file_dict_search_pos (self, _tmp20_, _tmp21_, _tmp22_, _skk_file_dict_strcmp_prefix_gcompare_func, &_tmp23_, &_tmp24_, 1);
	pos = _tmp23_;
	_g_free0 (line);
	line = _tmp24_;
	if (_tmp25_) {
		glong _pos = 0L;
		glong _tmp26_;
		gchar* _line = NULL;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		glong _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp26_ = pos;
		_pos = _tmp26_;
		_tmp27_ = line;
		_tmp28_ = g_strdup (_tmp27_);
		_line = _tmp28_;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				gint index = 0;
				const gchar* _tmp36_;
				gint _tmp37_;
				if (!_tmp29_) {
					gboolean _tmp30_ = FALSE;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					const gchar* _tmp33_;
					_tmp31_ = line;
					_tmp32_ = skk_file_dict_read_previous_line (self, &pos, _tmp31_);
					_g_free0 (line);
					line = _tmp32_;
					_tmp33_ = line;
					if (_tmp33_ != NULL) {
						const gchar* _tmp34_;
						const gchar* _tmp35_;
						_tmp34_ = line;
						_tmp35_ = _midasi;
						_tmp30_ = g_str_has_prefix (_tmp34_, _tmp35_);
					} else {
						_tmp30_ = FALSE;
					}
					if (!_tmp30_) {
						break;
					}
				}
				_tmp29_ = FALSE;
				_tmp36_ = line;
				index = string_index_of (_tmp36_, " ", 0);
				_tmp37_ = index;
				if (_tmp37_ < 0) {
					const gchar* _tmp38_;
					_tmp38_ = line;
					g_warning ("file-dict.vala:274: corrupted dictionary entry: %s", _tmp38_);
				} else {
					gchar* completed = NULL;
					const gchar* _tmp39_;
					gint _tmp40_;
					gchar* _tmp41_;
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					_tmp39_ = line;
					_tmp40_ = index;
					_tmp41_ = string_slice (_tmp39_, (glong) 0, (glong) _tmp40_);
					completed = _tmp41_;
					_tmp42_ = completed;
					_tmp43_ = _midasi;
					if (g_strcmp0 (_tmp42_, _tmp43_) != 0) {
						{
							gchar* decoded = NULL;
							SkkEncodingConverter* _tmp44_;
							const gchar* _tmp45_;
							gchar* _tmp46_;
							GeeArrayList* _tmp47_;
							const gchar* _tmp48_;
							_tmp44_ = self->priv->converter;
							_tmp45_ = completed;
							_tmp46_ = skk_encoding_converter_decode (_tmp44_, _tmp45_, &_inner_error_);
							decoded = _tmp46_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								goto __catch7_g_error;
							}
							_tmp47_ = completion;
							_tmp48_ = decoded;
							gee_abstract_list_insert ((GeeAbstractList*) _tmp47_, 0, _tmp48_);
							_g_free0 (decoded);
						}
						goto __finally7;
						__catch7_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp49_;
							GError* _tmp50_;
							const gchar* _tmp51_;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp49_ = line;
							_tmp50_ = e;
							_tmp51_ = _tmp50_->message;
							g_warning ("file-dict.vala:284: can't decode line %s: %s", _tmp49_, _tmp51_);
							_g_error_free0 (e);
						}
						__finally7:
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_free0 (completed);
							_g_free0 (_line);
							_g_free0 (line);
							_g_free0 (_midasi);
							_g_object_unref0 (completion);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_g_free0 (completed);
				}
			}
		}
		_tmp52_ = _pos;
		pos = _tmp52_;
		_tmp53_ = _line;
		_tmp54_ = g_strdup (_tmp53_);
		_g_free0 (line);
		line = _tmp54_;
		while (TRUE) {
			gboolean _tmp55_ = FALSE;
			const gchar* _tmp56_;
			gchar* _tmp57_;
			const gchar* _tmp58_;
			gint index = 0;
			const gchar* _tmp61_;
			gint _tmp62_;
			_tmp56_ = line;
			_tmp57_ = skk_file_dict_read_next_line (self, &pos, _tmp56_);
			_g_free0 (line);
			line = _tmp57_;
			_tmp58_ = line;
			if (_tmp58_ != NULL) {
				const gchar* _tmp59_;
				const gchar* _tmp60_;
				_tmp59_ = line;
				_tmp60_ = _midasi;
				_tmp55_ = g_str_has_prefix (_tmp59_, _tmp60_);
			} else {
				_tmp55_ = FALSE;
			}
			if (!_tmp55_) {
				break;
			}
			_tmp61_ = line;
			index = string_index_of (_tmp61_, " ", 0);
			_tmp62_ = index;
			if (_tmp62_ < 0) {
				const gchar* _tmp63_;
				_tmp63_ = line;
				g_warning ("file-dict.vala:299: corrupted dictionary entry: %s", _tmp63_);
			} else {
				gchar* completed = NULL;
				const gchar* _tmp64_;
				gint _tmp65_;
				gchar* _tmp66_;
				const gchar* _tmp67_;
				const gchar* _tmp68_;
				_tmp64_ = line;
				_tmp65_ = index;
				_tmp66_ = string_slice (_tmp64_, (glong) 0, (glong) _tmp65_);
				completed = _tmp66_;
				_tmp67_ = completed;
				_tmp68_ = _midasi;
				if (g_strcmp0 (_tmp67_, _tmp68_) != 0) {
					{
						gchar* decoded = NULL;
						SkkEncodingConverter* _tmp69_;
						const gchar* _tmp70_;
						gchar* _tmp71_;
						GeeArrayList* _tmp72_;
						const gchar* _tmp73_;
						_tmp69_ = self->priv->converter;
						_tmp70_ = completed;
						_tmp71_ = skk_encoding_converter_decode (_tmp69_, _tmp70_, &_inner_error_);
						decoded = _tmp71_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							goto __catch8_g_error;
						}
						_tmp72_ = completion;
						_tmp73_ = decoded;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp72_, _tmp73_);
						_g_free0 (decoded);
					}
					goto __finally8;
					__catch8_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp74_;
						GError* _tmp75_;
						const gchar* _tmp76_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp74_ = line;
						_tmp75_ = e;
						_tmp76_ = _tmp75_->message;
						g_warning ("file-dict.vala:309: can't decode line %s: %s", _tmp74_, _tmp76_);
						_g_error_free0 (e);
					}
					__finally8:
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (completed);
						_g_free0 (_line);
						_g_free0 (line);
						_g_free0 (_midasi);
						_g_object_unref0 (completion);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_g_free0 (completed);
			}
		}
		_g_free0 (_line);
	}
	_tmp77_ = completion;
	_tmp79_ = gee_collection_to_array ((GeeCollection*) _tmp77_, &_tmp78_);
	_tmp80_ = _tmp79_;
	_tmp80__length1 = _tmp78_;
	if (result_length1) {
		*result_length1 = _tmp80__length1;
	}
	result = _tmp80_;
	_g_free0 (line);
	_g_free0 (_midasi);
	_g_object_unref0 (completion);
	return result;
}


/**
         * Create a new FileDict.
         *
         * @param path a path to the file
         * @param encoding encoding of the file (default EUC-JP)
         *
         * @return a new FileDict
         * @throws GLib.Error if opening the file is failed
         */
SkkFileDict*
skk_file_dict_construct (GType object_type,
                         const gchar* path,
                         const gchar* encoding,
                         GError** error)
{
	SkkFileDict * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	SkkMemoryMappedFile* _tmp2_;
	gchar* _tmp3_;
	SkkEncodingConverter* _tmp4_ = NULL;
	SkkEncodingConverter* _tmp5_;
	SkkEncodingConverter* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (encoding != NULL, NULL);
	self = (SkkFileDict*) skk_dict_construct (object_type);
	_tmp0_ = g_file_new_for_path (path);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = skk_memory_mapped_file_new (_tmp1_);
	_g_object_unref0 (self->priv->mmap);
	self->priv->mmap = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp3_;
	_tmp5_ = skk_encoding_converter_new (encoding, &_inner_error_);
	_tmp4_ = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp6_ = _tmp4_;
	_tmp4_ = NULL;
	_g_object_unref0 (self->priv->converter);
	self->priv->converter = _tmp6_;
	skk_dict_reload ((SkkDict*) self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (_tmp4_);
	return self;
}


SkkFileDict*
skk_file_dict_new (const gchar* path,
                   const gchar* encoding,
                   GError** error)
{
	return skk_file_dict_construct (SKK_TYPE_FILE_DICT, path, encoding, error);
}


static gboolean
skk_file_dict_real_get_read_only (SkkDict* base)
{
	gboolean result;
	SkkFileDict* self;
	self = (SkkFileDict*) base;
	result = TRUE;
	return result;
}


static void
skk_file_dict_class_init (SkkFileDictClass * klass)
{
	skk_file_dict_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkFileDictPrivate));
	((SkkDictClass *) klass)->reload = (void (*) (SkkDict *, GError**)) skk_file_dict_real_reload;
	((SkkDictClass *) klass)->lookup = (SkkCandidate** (*) (SkkDict *, const gchar*, gboolean, int*)) skk_file_dict_real_lookup;
	((SkkDictClass *) klass)->complete = (gchar** (*) (SkkDict *, const gchar*, int*)) skk_file_dict_real_complete;
	SKK_DICT_CLASS (klass)->get_read_only = skk_file_dict_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_file_dict_get_property;
	G_OBJECT_CLASS (klass)->finalize = skk_file_dict_finalize;
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_FILE_DICT_READ_ONLY_PROPERTY, skk_file_dict_properties[SKK_FILE_DICT_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
skk_file_dict_instance_init (SkkFileDict * self)
{
	self->priv = SKK_FILE_DICT_GET_PRIVATE (self);
}


static void
skk_file_dict_finalize (GObject * obj)
{
	SkkFileDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_FILE_DICT, SkkFileDict);
	_g_object_unref0 (self->priv->file);
	_g_object_unref0 (self->priv->mmap);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->converter);
	G_OBJECT_CLASS (skk_file_dict_parent_class)->finalize (obj);
}


/**
     * Read-only file based implementation of Dict.
     */
GType
skk_file_dict_get_type (void)
{
	static volatile gsize skk_file_dict_type_id__volatile = 0;
	if (g_once_init_enter (&skk_file_dict_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkFileDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_file_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkFileDict), 0, (GInstanceInitFunc) skk_file_dict_instance_init, NULL };
		GType skk_file_dict_type_id;
		skk_file_dict_type_id = g_type_register_static (SKK_TYPE_DICT, "SkkFileDict", &g_define_type_info, 0);
		g_once_init_leave (&skk_file_dict_type_id__volatile, skk_file_dict_type_id);
	}
	return skk_file_dict_type_id__volatile;
}


static void
_vala_skk_file_dict_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	SkkFileDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_FILE_DICT, SkkFileDict);
	switch (property_id) {
		case SKK_FILE_DICT_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, skk_dict_get_read_only ((SkkDict*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



