#include "widgets.h"


namespace Dict {

QString elide(const QString &text, int len)
{
	return (text.length() > len) ? (text.left(len) + "...") : text;
}

Entry::Entry(QWidget *parent)
	: QComboBox(parent)
{
	setEditable(true);
	setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
	setCompleter(0);
	lineEdit()->setMaxLength(maxLen);
}

void Entry::define()
{
	emit textActivated(currentText());
}

void Entry::match()
{
	emit matchText(currentText());
}

}
