Black Hole Solitaire Solver
===========================

This is a solver for the Solitaire/Patience card games "Golf" (3 variants),
"Black Hole", and "All in a Row" - implemented in C as a command line application. For
more information about these games, see:

* https://en.wikipedia.org/wiki/Golf_%28patience%29

* http://en.wikipedia.org/wiki/Black_Hole_%28solitaire%29

* http://en.wikipedia.org/wiki/All_in_a_Row_%28Solitaire%29

Installation
------------

To install this program, see the INSTALL file.

Support and Documentation
-------------------------

After installation, you can find documentation for this command with the
`--help` command

    black-hole-solve --help

You can also look for information at:

* [The Black Hole Solitaire Solver Homepage](https://www.shlomifish.org/open-source/projects/black-hole-solitaire-solver/

Usage
-----

The format of a Black Hole board is similar to that:

```
Foundations: AS
QD JC TC
QC 8C 2S
KC 6C 3S
3C 8S TS
4C 4S 9H
2C 5D 2H
KD QH 3H
5C 7S AD
4D 9D 7H
JD KS 3D
JS 7C 5H
6H 6S 8D
QS 4H KH
6D AC 7D
2D 8H 5S
9C AH TH
TD 9S JH
```

Namely, the Foundations with the card at the foundation followed by the 17
columns, with up to three cards in each column. The initial boards for PySol
and PySolFC deals can be generated by the make_pysol_freecell_board.py
utility included in the Freecell Solver archive
( https://fc-solve.shlomifish.org/ ). Just remember to add the `-t` flag (and
`-F` if you want to generate PySolFC deals instead of the original PySol ones).

The solver can be called with such a board layout like this:

    ./black-hole-solve --game black_hole 2.bh.board

Or:

    make_pysol_freecell_board.py -F -t 2 black_hole | ./black-hole-solve --game black_hole

Similarly "All in a Row" deals can be dealt using:

    make_pysol_freecell_board.py -F -t 24 all_in_a_row | ./black-hole-solve --game all_in_a_row -

Copyright and Licence
---------------------

Copyright (C) 2010 Shlomi Fish.

This program is distributed under the Expat License:
L<http://www.opensource.org/licenses/mit-license.php>
