/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.tmf.ui.TmfUiPlugin;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDWidget;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.TimeCompressionBar;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.BaseMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.SyncMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.SyncMessageReturn;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ConfigureMinMax;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.FirstPage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.KeyBindingsManager;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.LastPage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.MoveToMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.NextPage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.OpenSDFiltersDialog;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.OpenSDFindDialog;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.OpenSDPagesDialog;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.PrevPage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.Print;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeEnd;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeStart;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.Zoom;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.IExtendedFilterProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.IExtendedFindProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDAdvancedPagingProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDCollapseProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDExtendedActionBarProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDFilterProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDFindProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDPagingProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDPropertiesProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.load.IUml2SDLoader;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.load.LoadersManager;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDMessages;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class SDView
extends ViewPart {
    protected SDWidget sdWidget = null;
    protected TimeCompressionBar timeCompressionBar = null;
    protected ISDFindProvider sdFindProvider = null;
    protected ISDPagingProvider sdPagingProvider = null;
    protected ISDFilterProvider sdFilterProvider = null;
    protected IExtendedFilterProvider sdExFilterProvider = null;
    protected IExtendedFindProvider sdExFindProvider = null;
    protected ISDExtendedActionBarProvider sdExtendedActionBarProvider = null;
    protected ISDPropertiesProvider sdPropertiesProvider = null;
    protected NextPage nextPageButton = null;
    protected PrevPage prevPageButton = null;
    protected FirstPage firstPageButton = null;
    protected LastPage lastPageButton = null;
    protected MenuManager menuMgr = null;
    protected boolean needInit = true;
    protected Cursor waitCursor;

    public void createPartControl(Composite c) {
        Composite parent = new Composite(c, 0);
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 2;
        parentLayout.marginWidth = 0;
        parentLayout.marginHeight = 0;
        parent.setLayout((Layout)parentLayout);
        GridData timeLayoutdata = new GridData(1040);
        timeLayoutdata.widthHint = 10;
        GridData seqDiagLayoutData = new GridData(1808);
        this.timeCompressionBar = new TimeCompressionBar(parent, 0);
        this.timeCompressionBar.setLayoutData(timeLayoutdata);
        this.sdWidget = new SDWidget(parent, 0);
        this.sdWidget.setLayoutData(seqDiagLayoutData);
        this.sdWidget.setSite(this);
        this.sdWidget.setTimeBar(this.timeCompressionBar);
        KeyBindingsManager.getInstance().add(this.getSite().getId());
        this.createCoolbarContent();
        this.hookContextMenu();
        this.timeCompressionBar.setVisible(false);
        parent.layout(true);
        Print print = new Print(this);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)print);
        this.needInit = this.restoreLoader();
    }

    protected void loadBlank() {
        IUml2SDLoader l = new IUml2SDLoader(){

            @Override
            public void setViewer(SDView viewer) {
                Frame f = new Frame();
                f.setName("");
                viewer.setFrame(f);
            }

            @Override
            public String getTitleString() {
                return "";
            }

            @Override
            public void dispose() {
            }
        };
        l.setViewer(this);
        this.setContentDescription(l.getTitleString());
    }

    public void setFocus() {
        if (this.sdWidget != null) {
            KeyBindingsManager.getInstance().setSdView(this);
            this.sdWidget.setFocus();
        }
        if (this.isViewReady() && this.needInit) {
            this.needInit = this.restoreLoader();
        }
    }

    public void dispose() {
        KeyBindingsManager.getInstance().remove(this.getSite().getId());
        super.dispose();
    }

    public SDWidget getSDWidget() {
        return this.sdWidget;
    }

    public void setSDFindProvider(ISDFindProvider provider) {
        this.sdFindProvider = provider;
        this.sdExFindProvider = null;
        this.createCoolbarContent();
        if (provider != null) {
            KeyBindingsManager.getInstance().setFindEnabled(true);
        } else {
            KeyBindingsManager.getInstance().setFindEnabled(false);
        }
    }

    public void setExtendedFindProvider(IExtendedFindProvider provider) {
        this.sdExFindProvider = provider;
        this.sdFindProvider = null;
        this.createCoolbarContent();
        if (provider != null) {
            KeyBindingsManager.getInstance().setFindEnabled(true);
        } else {
            KeyBindingsManager.getInstance().setFindEnabled(false);
        }
    }

    public IExtendedFindProvider getExtendedFindProvider() {
        return this.sdExFindProvider;
    }

    public void resetProviders() {
        KeyBindingsManager.getInstance().setFindEnabled(false);
        this.sdFindProvider = null;
        this.sdExFindProvider = null;
        this.sdFilterProvider = null;
        this.sdExFilterProvider = null;
        this.sdPagingProvider = null;
        this.sdExtendedActionBarProvider = null;
        this.sdPropertiesProvider = null;
        if (this.sdWidget != null && !this.sdWidget.isDisposed()) {
            this.sdWidget.setCollapseProvider(null);
        }
    }

    public void setSDFilterProvider(ISDFilterProvider provider) {
        this.sdFilterProvider = provider;
        this.createCoolbarContent();
    }

    public void setExtendedFilterProvider(IExtendedFilterProvider provider) {
        this.sdExFilterProvider = provider;
        this.createCoolbarContent();
    }

    public IExtendedFilterProvider getExtendedFilterProvider() {
        return this.sdExFilterProvider;
    }

    public void setCollapsingProvider(ISDCollapseProvider provider) {
        if (this.sdWidget != null && !this.sdWidget.isDisposed()) {
            this.sdWidget.setCollapseProvider(provider);
        }
    }

    public void setSDPagingProvider(ISDPagingProvider provider) {
        this.sdPagingProvider = provider;
        this.createCoolbarContent();
    }

    public ISDPagingProvider getSDPagingProvider() {
        return this.sdPagingProvider;
    }

    public ISDFindProvider getSDFindProvider() {
        return this.sdFindProvider;
    }

    public ISDFilterProvider getSDFilterProvider() {
        return this.sdFilterProvider;
    }

    public void setSDExtendedActionBarProvider(ISDExtendedActionBarProvider provider) {
        this.sdExtendedActionBarProvider = provider;
        this.createCoolbarContent();
    }

    public ISDExtendedActionBarProvider getSDExtendedActionBarProvider() {
        return this.sdExtendedActionBarProvider;
    }

    public void setSDPropertiesProvider(ISDPropertiesProvider provider) {
        this.sdPropertiesProvider = provider;
    }

    public ISDPropertiesProvider getSDPropertiesProvider() {
        return this.sdPropertiesProvider;
    }

    protected void hookContextMenu() {
        this.menuMgr = new MenuManager("#PopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SDView.this.fillContextMenu(manager);
            }
        });
        Menu menu = this.menuMgr.createContextMenu(this.sdWidget.getViewControl());
        this.sdWidget.getViewControl().setMenu(menu);
        this.getSite().registerContextMenu(this.menuMgr, this.sdWidget.getSelectionProvider());
    }

    public MenuManager getMenuManager() {
        return this.menuMgr;
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("Additions"));
        if (this.getSDWidget() != null && this.getSDWidget().currentGraphNode != null) {
            MoveToMessage goToMessage;
            Object node2;
            ISelectionProvider selProvider = this.sdWidget.getSelectionProvider();
            ISelection sel = selProvider.getSelection();
            int nbMessage = 0;
            for (Object node2 : (StructuredSelection)sel) {
                if (!(node2 instanceof BaseMessage)) continue;
                ++nbMessage;
            }
            if (nbMessage != 1) {
                return;
            }
            node2 = this.getSDWidget().currentGraphNode;
            if (node2 instanceof SyncMessageReturn && ((SyncMessageReturn)node2).getMessage() != null) {
                goToMessage = new MoveToMessage(this);
                goToMessage.setText(SDMessages._39);
                manager.add((IAction)goToMessage);
            }
            if (node2 instanceof SyncMessage && ((SyncMessage)node2).getMessageReturn() != null) {
                goToMessage = new MoveToMessage(this);
                goToMessage.setText(SDMessages._40);
                manager.add((IAction)goToMessage);
            }
        }
        manager.add((IContributionItem)new Separator("MultiSelectAdditions"));
    }

    public void setEnableAction(String actionName, boolean state) {
        IContributionItem item;
        IActionBars bar = this.getViewSite().getActionBars();
        if (bar != null && (item = bar.getMenuManager().find(actionName)) != null && item instanceof ActionContributionItem) {
            IAction action = ((ActionContributionItem)item).getAction();
            if (action != null) {
                action.setEnabled(state);
            }
            item.setVisible(state);
            bar.updateActionBars();
        }
    }

    protected void createCoolbarContent() {
        Action action;
        IActionBars bar = this.getViewSite().getActionBars();
        bar.getMenuManager().removeAll();
        bar.getToolBarManager().removeAll();
        this.createMenuGroup();
        Zoom resetZoom = new Zoom(this, Zoom.ZoomType.ZOOM_RESET);
        bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)resetZoom);
        bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)resetZoom);
        Zoom noZoom = new Zoom(this, Zoom.ZoomType.ZOOM_NONE);
        noZoom.setChecked(true);
        bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)noZoom);
        bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)noZoom);
        Zoom zoomIn = new Zoom(this, Zoom.ZoomType.ZOOM_IN);
        bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)zoomIn);
        bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)zoomIn);
        Zoom zoomOut = new Zoom(this, Zoom.ZoomType.ZOOM_OUT);
        bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)zoomOut);
        bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)zoomOut);
        MenuManager navigation = new MenuManager(SDMessages._77);
        ShowNodeStart showNodeStart = new ShowNodeStart((IViewPart)this);
        showNodeStart.setText(SDMessages.uml_25);
        showNodeStart.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeStart");
        showNodeStart.setActionDefinitionId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeStart");
        navigation.add((IAction)showNodeStart);
        ShowNodeEnd showNodeEnd = new ShowNodeEnd((IViewPart)this);
        showNodeEnd.setText(SDMessages.uml_23);
        showNodeEnd.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeEnd");
        showNodeEnd.setActionDefinitionId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeEnd");
        navigation.add((IAction)showNodeEnd);
        bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IContributionItem)navigation);
        ConfigureMinMax minMax = new ConfigureMinMax((IViewPart)this);
        minMax.setText(SDMessages.uml_45);
        minMax.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ConfigureMinMax");
        bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)minMax);
        if (this.sdWidget.getFrame() != null && this.sdWidget.getFrame().hasTimeInfo()) {
            minMax.setEnabled(true);
        } else {
            minMax.setEnabled(false);
        }
        if (this.sdPagingProvider != null) {
            this.nextPageButton = new NextPage(this);
            bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.nextPageButton);
            this.nextPageButton.setEnabled(this.sdPagingProvider.hasNextPage());
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.nextPageButton);
            this.prevPageButton = new PrevPage(this);
            bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.prevPageButton);
            this.prevPageButton.setEnabled(this.sdPagingProvider.hasPrevPage());
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.prevPageButton);
            this.firstPageButton = new FirstPage(this);
            bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.firstPageButton);
            this.firstPageButton.setEnabled(this.sdPagingProvider.hasPrevPage());
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.firstPageButton);
            this.lastPageButton = new LastPage(this);
            bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.lastPageButton);
            this.lastPageButton.setEnabled(this.sdPagingProvider.hasNextPage());
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.lastPageButton);
        }
        if (this.sdExFilterProvider != null && (action = this.sdExFilterProvider.getFilterAction()) != null) {
            if (action.getId() == null) {
                action.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.extendedFilter");
            }
            if (action.getImageDescriptor() == null) {
                action.setImageDescriptor(TmfUiPlugin.getDefault().getImageDescripterFromPath("icons/elcl16/filter_items.gif"));
            }
            if (action.getText() == null || action.getText().length() == 0) {
                action.setText(SDMessages._42);
            }
            bar.getMenuManager().prependToGroup("UML2SD_FILTERING", (IAction)action);
            bar.getToolBarManager().prependToGroup("UML2SD_FILTERING", (IAction)action);
        }
        if (this.sdFilterProvider != null) {
            bar.getMenuManager().appendToGroup("UML2SD_FILTERING", (IAction)new OpenSDFiltersDialog(this, this.sdFilterProvider));
        }
        if (this.sdPagingProvider != null && this.sdPagingProvider instanceof ISDAdvancedPagingProvider) {
            IContributionItem sdPaging = bar.getMenuManager().find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.sdPaging");
            if (sdPaging != null) {
                bar.getMenuManager().remove(sdPaging);
                sdPaging = null;
            }
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)new OpenSDPagesDialog(this, (ISDAdvancedPagingProvider)this.sdPagingProvider));
            this.updatePagesMenuItem(bar);
        }
        if (this.sdExFindProvider != null) {
            action = this.sdExFindProvider.getFindAction();
            if (action != null) {
                if (action.getId() == null) {
                    action.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.extendedFind");
                }
                if (action.getImageDescriptor() == null) {
                    action.setImageDescriptor(TmfUiPlugin.getDefault().getImageDescripterFromPath("icons/elcl16/search_seqdiag_menu.gif"));
                }
                if (action.getText() == null) {
                    action.setText(SDMessages._41);
                }
                bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)action);
                bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)action);
            }
        } else if (this.sdFindProvider != null) {
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)new OpenSDFindDialog(this));
            bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)new OpenSDFindDialog(this));
        }
        if (this.sdExtendedActionBarProvider != null) {
            this.sdExtendedActionBarProvider.supplementCoolbarContent(bar);
        }
        bar.updateActionBars();
    }

    public void updateCoolBar() {
        if (this.sdPagingProvider != null) {
            IAction lastPageAction;
            IContributionItem lastPage;
            IAction firstPageAction;
            IContributionItem firstPage;
            IAction prevPageAction;
            IContributionItem prevPage;
            IAction nextPageAction;
            IActionBars bar = this.getViewSite().getActionBars();
            if (bar == null) {
                return;
            }
            IToolBarManager barManager = bar.getToolBarManager();
            if (barManager == null) {
                return;
            }
            IContributionItem nextPage = barManager.find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.nextpage");
            if (nextPage != null && nextPage instanceof ActionContributionItem && (nextPageAction = ((ActionContributionItem)nextPage).getAction()) != null && nextPageAction instanceof NextPage) {
                ((NextPage)nextPageAction).setEnabled(this.sdPagingProvider.hasNextPage());
            }
            if ((prevPage = barManager.find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.prevpage")) != null && prevPage instanceof ActionContributionItem && (prevPageAction = ((ActionContributionItem)prevPage).getAction()) != null && prevPageAction instanceof PrevPage) {
                ((PrevPage)prevPageAction).setEnabled(this.sdPagingProvider.hasPrevPage());
            }
            if ((firstPage = barManager.find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.firstpage")) != null && firstPage instanceof ActionContributionItem && (firstPageAction = ((ActionContributionItem)firstPage).getAction()) != null && firstPageAction instanceof FirstPage) {
                ((FirstPage)firstPageAction).setEnabled(this.sdPagingProvider.hasPrevPage());
            }
            if ((lastPage = barManager.find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.lastpage")) != null && lastPage instanceof ActionContributionItem && (lastPageAction = ((ActionContributionItem)lastPage).getAction()) != null && lastPageAction instanceof LastPage) {
                ((LastPage)lastPageAction).setEnabled(this.sdPagingProvider.hasNextPage());
            }
            this.updatePagesMenuItem(bar);
        }
    }

    protected void updatePagesMenuItem(IActionBars bar) {
        if (this.sdPagingProvider instanceof ISDAdvancedPagingProvider) {
            IMenuManager menuManager = bar.getMenuManager();
            ActionContributionItem contributionItem = (ActionContributionItem)menuManager.find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.sdPaging");
            IAction openSDPagesDialog = null;
            if (contributionItem != null) {
                openSDPagesDialog = contributionItem.getAction();
            }
            if (openSDPagesDialog != null && openSDPagesDialog instanceof OpenSDPagesDialog) {
                openSDPagesDialog.setEnabled(((ISDAdvancedPagingProvider)this.sdPagingProvider).pagesCount() > 1);
            }
        }
    }

    public void setFrame(Frame frame) {
        this.setFrame(frame, true);
    }

    protected void setFrame(Frame frame, boolean resetPosition) {
        Composite parent;
        if (this.sdWidget == null) {
            return;
        }
        if (frame == null) {
            this.loadBlank();
            return;
        }
        IUml2SDLoader l = LoadersManager.getInstance().getCurrentLoader(this.getViewSite().getId(), this);
        if (l != null && l.getTitleString() != null) {
            this.setContentDescription(l.getTitleString());
        }
        if (this.getSDWidget() != null) {
            this.getSDWidget().setFrame(frame, resetPosition);
        }
        if (this.timeCompressionBar != null) {
            this.timeCompressionBar.setFrame(frame);
        }
        this.updateCoolBar();
        if (!frame.hasTimeInfo()) {
            parent = this.timeCompressionBar.getParent();
            this.timeCompressionBar.setVisible(false);
            parent.layout(true);
        } else {
            parent = this.timeCompressionBar.getParent();
            this.timeCompressionBar.setVisible(true);
            parent.layout(true);
        }
        IContributionItem shortKeysMenu = this.getViewSite().getActionBars().getMenuManager().find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers");
        MenuManager shortKeys = (MenuManager)shortKeysMenu;
        if (shortKeys != null) {
            IContributionItem[] items = shortKeys.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                if (items[i] instanceof ActionContributionItem && (action = ((ActionContributionItem)items[i]).getAction()) != null) {
                    action.setEnabled(true);
                }
                ++i;
            }
        }
        this.createCoolbarContent();
    }

    public void setEnableCommand(String id, boolean value) {
        IAction action;
        IContributionItem shortKeysMenu = this.getViewSite().getActionBars().getMenuManager().find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers");
        MenuManager shortKeys = (MenuManager)shortKeysMenu;
        if (shortKeys == null) {
            return;
        }
        IContributionItem item = shortKeys.find(id);
        if (item != null && item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) != null) {
            action.setEnabled(value);
        }
    }

    public void setFrameSync(final Frame frame) {
        if (this.getSDWidget() == null || this.getSDWidget().isDisposed()) {
            return;
        }
        this.getSDWidget().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (SDView.this.getSDWidget() == null || SDView.this.getSDWidget().isDisposed()) {
                    return;
                }
                SDView.this.setFrame(frame);
            }
        });
    }

    public void ensureVisibleSync(final GraphNode sm) {
        this.getSDWidget().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (SDView.this.getSDWidget() == null || SDView.this.getSDWidget().isDisposed()) {
                    return;
                }
                SDView.this.getSDWidget().ensureVisible(sm);
            }
        });
    }

    public void setFrameAndEnsureVisibleSync(final Frame frame, final GraphNode sm) {
        if (this.getSDWidget() == null || this.getSDWidget().isDisposed()) {
            return;
        }
        this.getSDWidget().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (SDView.this.getSDWidget() == null || SDView.this.getSDWidget().isDisposed()) {
                    return;
                }
                SDView.this.setFrameAndEnsureVisible(frame, sm);
            }
        });
    }

    public void setFrameAndEnsureVisible(Frame frame, GraphNode sm) {
        this.getSDWidget().clearSelection();
        this.setFrame(frame, false);
        this.getSDWidget().ensureVisible(sm);
    }

    public void setFrameAndEnsureVisibleSync(final Frame frame, final int x, final int y) {
        if (this.getSDWidget() == null || this.getSDWidget().isDisposed()) {
            return;
        }
        this.getSDWidget().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SDView.this.setFrameAndEnsureVisible(frame, x, y);
            }
        });
    }

    public void setFrameAndEnsureVisible(Frame frame, int x, int y) {
        this.getSDWidget().clearSelection();
        this.setFrame(frame, false);
        this.getSDWidget().ensureVisible(x, y);
        this.getSDWidget().redraw();
    }

    public void toggleWaitCursorAsync(final boolean wait_) {
        if (this.getSDWidget() == null || this.getSDWidget().isDisposed()) {
            return;
        }
        this.getSDWidget().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SDView.this.getSDWidget() == null || SDView.this.getSDWidget().isDisposed()) {
                    return;
                }
                if (wait_) {
                    if (SDView.this.waitCursor != null && !SDView.this.waitCursor.isDisposed()) {
                        SDView.this.waitCursor.dispose();
                    }
                    SDView.this.waitCursor = new Cursor((Device)SDView.this.getSDWidget().getDisplay(), 1);
                    SDView.this.getSDWidget().setCursor(SDView.this.waitCursor);
                    SDView.this.getSDWidget().getDisplay().update();
                } else {
                    if (SDView.this.waitCursor != null && !SDView.this.waitCursor.isDisposed()) {
                        SDView.this.waitCursor.dispose();
                    }
                    SDView.this.waitCursor = null;
                    SDView.this.getSDWidget().setCursor(null);
                    SDView.this.getSDWidget().getDisplay().update();
                }
            }
        });
    }

    public TimeCompressionBar getTimeCompressionBar() {
        return this.timeCompressionBar;
    }

    public Frame getFrame() {
        if (this.getSDWidget() != null) {
            return this.getSDWidget().getFrame();
        }
        return null;
    }

    protected boolean restoreLoader() {
        String id = this.getViewSite().getId();
        if (id == null) {
            return true;
        }
        IUml2SDLoader l = LoadersManager.getInstance().getCurrentLoader(id, this);
        if (l != null) {
            l.setViewer(this);
            return false;
        }
        this.loadBlank();
        return true;
    }

    protected boolean isViewReady() {
        IWorkbenchPage persp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (persp == null) {
            return false;
        }
        IViewReference[] ref = persp.getViewReferences();
        int i = 0;
        while (i < ref.length) {
            if (ref[i].getView(false) == this) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void createMenuGroup() {
        IActionBars bar = this.getViewSite().getActionBars();
        if (bar == null) {
            return;
        }
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_VIEW_MODES"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_WORKING_SET"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_SORTING"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_FILTERING"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_VIEW_LAYOUT"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_LINK_EDITOR"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_OTHER_COMMANDS"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_OTHER_PLUGINS_COMMANDS"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_VIEW_MODES"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_WORKING_SET"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_SORTING"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_FILTERING"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_VIEW_LAYOUT"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_LINK_EDITOR"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_OTHER_COMMANDS"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_OTHER_PLUGINS_COMMANDS"));
    }

    public Object getAdapter(Class _adapter) {
        Object obj = super.getAdapter(_adapter);
        if (this.sdPropertiesProvider != null && _adapter.equals(IPropertySheetPage.class)) {
            return this.sdPropertiesProvider.getPropertySheetEntry();
        }
        return obj;
    }
}

