/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.core.control.model.impl;

import org.eclipse.linuxtools.internal.lttng2.core.control.model.IEventInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceEnablement;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.BaseEventInfo;

public class EventInfo
extends BaseEventInfo
implements IEventInfo {
    private TraceEnablement fState = TraceEnablement.DISABLED;

    public EventInfo(String name) {
        super(name);
    }

    public EventInfo(EventInfo other) {
        super(other);
        this.fState = other.fState;
    }

    @Override
    public TraceEnablement getState() {
        return this.fState;
    }

    @Override
    public void setState(TraceEnablement state) {
        this.fState = state;
    }

    @Override
    public void setState(String stateName) {
        this.fState = TraceEnablement.DISABLED;
        if (TraceEnablement.DISABLED.getInName().equals(stateName)) {
            this.fState = TraceEnablement.DISABLED;
        } else if (TraceEnablement.ENABLED.getInName().equals(stateName)) {
            this.fState = TraceEnablement.ENABLED;
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fState == null ? 0 : this.fState.ordinal() + 1);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventInfo other = (EventInfo)obj;
        return this.fState == other.fState;
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("[EventInfo(");
        output.append(super.toString());
        output.append(",State=");
        output.append((Object)this.fState);
        output.append(")]");
        return output.toString();
    }
}

