/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.multipopulation.impl;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.stem.core.common.DoubleValue;
import org.eclipse.stem.core.common.DoubleValueList;
import org.eclipse.stem.core.common.StringValue;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.multipopulation.MultiPopulationSIRDiseaseModel;
import org.eclipse.stem.diseasemodels.multipopulation.MultipopulationPackage;
import org.eclipse.stem.diseasemodels.multipopulation.impl.MultiPopulationSIDiseaseModelImpl;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.SIRLabel;
import org.eclipse.stem.diseasemodels.standard.SIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SIRLabelValueImpl;

public class MultiPopulationSIRDiseaseModelImpl
extends MultiPopulationSIDiseaseModelImpl
implements MultiPopulationSIRDiseaseModel {
    protected DoubleValueList immunityLossRate;

    @Override
    protected EClass eStaticClass() {
        return MultipopulationPackage.Literals.MULTI_POPULATION_SIR_DISEASE_MODEL;
    }

    @Override
    public DoubleValueList getImmunityLossRate() {
        return this.immunityLossRate;
    }

    public NotificationChain basicSetImmunityLossRate(DoubleValueList newImmunityLossRate, NotificationChain msgs) {
        this.immunityLossRate = newImmunityLossRate;
        return msgs;
    }

    @Override
    public void setImmunityLossRate(DoubleValueList newImmunityLossRate) {
        if (newImmunityLossRate != this.immunityLossRate) {
            NotificationChain msgs = null;
            if (this.immunityLossRate != null) {
                msgs = ((InternalEObject)this.immunityLossRate).eInverseRemove((InternalEObject)this, -24, null, msgs);
            }
            if (newImmunityLossRate != null) {
                msgs = ((InternalEObject)newImmunityLossRate).eInverseAdd((InternalEObject)this, -24, null, msgs);
            }
            if ((msgs = this.basicSetImmunityLossRate(newImmunityLossRate, msgs)) != null) {
                msgs.dispatch();
            }
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 23: {
                return this.basicSetImmunityLossRate(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SIRLabelValue currentSIR = (SIRLabelValue)currentState;
            String thisPopulation = diseaseLabel.getPopulationModelLabel().getPopulationIdentifier();
            double adjustedInfectiousMortalityRate = this.getAdjustedInfectiousMortalityRate(timeDelta, thisPopulation);
            double diseaseDeaths = adjustedInfectiousMortalityRate * currentSIR.getI();
            int populationIndex = this.getPopulationIndex(thisPopulation);
            EList transmissionVector = ((DoubleValueList)this.getTransmissionRate().getValueLists().get(populationIndex)).getValues();
            double thisRecoveryRate = 0.0;
            if (this.getRecoveryRate() != null) {
                thisRecoveryRate = ((DoubleValue)this.getRecoveryRate().getValues().get(populationIndex)).getValue();
            }
            double thisImmunityLossRate = 0.0;
            if (this.getImmunityLossRate() != null) {
                thisImmunityLossRate = ((DoubleValue)this.getImmunityLossRate().getValues().get(populationIndex)).getValue();
            }
            double numberOfSusceptibleToInfected = 0.0;
            double numberSusceptible = currentSIR.getS();
            Node thisNode = diseaseLabel.getNode();
            EList groupList = this.getPopulationGroups().getValues();
            int i = 0;
            while (i < transmissionVector.size()) {
                String nextPop = ((StringValue)groupList.get(i)).getValue();
                double specificTransmission = ((DoubleValue)transmissionVector.get(i)).getValue();
                double adjustedTransmission = this.getAdjustedTransmissionRate(specificTransmission, timeDelta);
                if (!this.isFrequencyDependent()) {
                    adjustedTransmission *= this.getTransmissionRateScaleFactor(diseaseLabel);
                }
                EList nodeLabels = thisNode.getLabels();
                int j = 0;
                while (j < nodeLabels.size()) {
                    StandardDiseaseModelLabel otherDiseaseLabel;
                    String otherPopulation;
                    NodeLabel nlabel = (NodeLabel)nodeLabels.get(j);
                    if (nlabel instanceof SIRLabel && this == ((SIRLabel)nlabel).getDecorator() && (otherPopulation = (otherDiseaseLabel = (StandardDiseaseModelLabel)nlabel).getPopulationModelLabel().getPopulationIdentifier()).equals(nextPop)) {
                        double onsiteInfectious = ((SIRLabelValue)otherDiseaseLabel.getTempValue()).getI();
                        double effectiveInfectious = this.getNormalizedEffectiveInfectious(thisNode, otherDiseaseLabel, onsiteInfectious, StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
                        numberOfSusceptibleToInfected += adjustedTransmission * numberSusceptible * effectiveInfectious;
                    }
                    ++j;
                }
                ++i;
            }
            double numberOfInfectedToRecovered = this.getAdjustedRecoveryRate(thisRecoveryRate, timeDelta) * currentSIR.getI();
            double numberOfRecoveredToSusceptible = this.getAdjustedImmunityLossRate(thisImmunityLossRate, timeDelta) * currentSIR.getR();
            double deltaS = -numberOfSusceptibleToInfected + numberOfRecoveredToSusceptible;
            double deltaI = numberOfSusceptibleToInfected - numberOfInfectedToRecovered - diseaseDeaths;
            double deltaR = numberOfInfectedToRecovered - numberOfRecoveredToSusceptible;
            SIRLabelValueImpl ret = (SIRLabelValueImpl)deltaValue;
            Exchange siExchange = (Exchange)ExchangePool.POOL.get();
            siExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            siExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
            siExchange.setCount(numberOfSusceptibleToInfected);
            siExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
            siExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)siExchange);
            Exchange irExchange = (Exchange)ExchangePool.POOL.get();
            irExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
            irExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            irExchange.setCount(numberOfInfectedToRecovered);
            irExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)irExchange);
            Exchange rsExchange = (Exchange)ExchangePool.POOL.get();
            rsExchange.setSource(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            rsExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            rsExchange.setCount(numberOfRecoveredToSusceptible);
            rsExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)rsExchange);
            ret.setS(deltaS);
            ret.setI(deltaI);
            ret.setR(deltaR);
            ret.setIncidence(numberOfSusceptibleToInfected);
            ret.setDiseaseDeaths(diseaseDeaths);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    public double getAdjustedImmunityLossRate(double specificLossRate, long timeDelta) {
        return specificLossRate * ((double)timeDelta / (double)this.getTimePeriod());
    }

    @Override
    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createSIRLabel();
    }

    @Override
    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createSIRLabelValue();
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 23: {
                return this.getImmunityLossRate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 23: {
                this.setImmunityLossRate((DoubleValueList)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 23: {
                this.setImmunityLossRate(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 23: {
                return this.immunityLossRate != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

