/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jet.internal.xpath.ast.ExprNode;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.NodeSet;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathFunctionWithContext;
import org.eclipse.jet.xpath.XPathUtil;

public class Function
extends ExprNode {
    private final XPathFunction function;
    private final List argExprs;
    private final boolean requiresContext;
    private final String functionName;

    public Function(String functionName, XPathFunction function, List argExprs) {
        this.functionName = functionName;
        this.function = function;
        this.argExprs = argExprs;
        this.requiresContext = function instanceof XPathFunctionWithContext;
    }

    public Object evalAsObject(Context context) {
        Object var4_4;
        Object result;
        block10: {
            block9: {
                if (this.requiresContext) {
                    ((XPathFunctionWithContext)((Object)this.function)).setContext(context);
                }
                ArrayList<Object> functionArgValues = new ArrayList<Object>(this.argExprs.size());
                Iterator i = this.argExprs.iterator();
                while (i.hasNext()) {
                    ExprNode expr = (ExprNode)i.next();
                    functionArgValues.add(expr.evalAsObject(context));
                }
                try {
                    result = this.function.evaluate(functionArgValues);
                    if (!(result instanceof Object[])) break block9;
                    NodeSet nodeSet = XPathUtil.asNodeSet((Object[])result);
                    var4_4 = null;
                    if (this.requiresContext) {
                        ((XPathFunctionWithContext)((Object)this.function)).setContext(null);
                    }
                    return nodeSet;
                }
                catch (Throwable throwable) {
                    block11: {
                        var4_4 = null;
                        if (!this.requiresContext) break block11;
                        ((XPathFunctionWithContext)((Object)this.function)).setContext(null);
                    }
                    throw throwable;
                }
            }
            if (!(result instanceof Collection) || result instanceof NodeSet) break block10;
            NodeSet nodeSet = XPathUtil.asNodeSet((Collection)result);
            var4_4 = null;
            if (this.requiresContext) {
                ((XPathFunctionWithContext)((Object)this.function)).setContext(null);
            }
            return nodeSet;
        }
        Object object = result;
        var4_4 = null;
        if (this.requiresContext) {
            ((XPathFunctionWithContext)((Object)this.function)).setContext(null);
        }
        return object;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.functionName);
        buffer.append('(');
        Iterator i = this.argExprs.iterator();
        while (i.hasNext()) {
            ExprNode expr = (ExprNode)i.next();
            buffer.append(expr.toString());
            if (!i.hasNext()) continue;
            buffer.append(",");
        }
        buffer.append(')');
        return buffer.toString();
    }
}

