/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.java;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jet.BodyContentWriter;
import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.java.JavaActionsUtil;
import org.eclipse.jet.taglib.workspace.AbstractWorkspaceAction2;
import org.eclipse.jet.taglib.workspace.ActionsUtil;
import org.eclipse.jet.taglib.workspace.IWorkspaceAction2;
import org.eclipse.jet.taglib.workspace.IWorkspaceActionExtension;

public final class JavaFileAction
extends AbstractWorkspaceAction2
implements IWorkspaceAction2,
IWorkspaceActionExtension {
    protected final IPath srcFolderPath;
    protected final String pkgName;
    protected final String fileName;
    private final BodyContentWriter content;
    private final boolean replace;
    private final String encoding;
    private final boolean derived;
    private IFile file;

    public JavaFileAction(IPath srcFolderPath, String pkgName, String fileName, BodyContentWriter content, boolean replace, String encoding, boolean derived, TagInfo td, String templatePath) {
        super(td, templatePath);
        this.srcFolderPath = srcFolderPath;
        this.pkgName = pkgName;
        this.fileName = fileName;
        this.content = content;
        this.replace = replace;
        this.encoding = encoding;
        this.derived = derived;
    }

    private final IFile getUnderlyingFile() throws JET2TagException {
        if (this.file == null) {
            this.file = JavaActionsUtil.getResourceForJavaResource(this.srcFolderPath, this.pkgName, this.fileName);
        }
        return this.file;
    }

    public final IResource getResource() throws JET2TagException {
        return this.getUnderlyingFile();
    }

    public final boolean performActionIfRequired(IProgressMonitor monitor) throws JET2TagException {
        IFile targetFile = this.getUnderlyingFile();
        return ActionsUtil.writeTextFile(targetFile, this.replace, this.encoding, this.derived, this.content.getContent(), monitor);
    }

    public final boolean requiresValidateEdit() throws JET2TagException {
        if (!this.replace) {
            return false;
        }
        try {
            IFile res = this.getUnderlyingFile();
            return res.exists() && res.getResourceAttributes().isReadOnly();
        }
        catch (JET2TagException jET2TagException) {
            return false;
        }
    }

    public BufferedJET2Writer getContentWriter() {
        return this.content;
    }
}

