/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementSource;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;

public class OpenGeneratedMenu extends CompoundContributionItem {

	protected static final IContributionItem[] NO_ITEMS = {};

	protected ComposedAdapterFactory adapterFactory;

	@Override
	protected IContributionItem[] getContributionItems() {
		ISelectionService selectionService = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getSelectionService();
		ISelection sel = selectionService.getSelection();
		if (sel instanceof IStructuredSelection) {
			Object target = ((IStructuredSelection) sel).getFirstElement();
			if (target != null) {
				if (adapterFactory == null)
					adapterFactory = new ComposedAdapterFactory(
							ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

				Object adapter = adapterFactory.adapt(target,
						IItemJavaElementSource.class);
				if (adapter instanceof IItemJavaElementSource)
					return createActions((IItemJavaElementSource) adapter,
							target);
			}
		}

		return NO_ITEMS;
	}

	private IContributionItem[] createActions(IItemJavaElementSource provider,
			Object target) {
		List<IItemJavaElementDescriptor> descriptors = new ArrayList<IItemJavaElementDescriptor>(
				provider.getJavaElementDescriptors(target));
		Collections.sort(descriptors, new DescriptorComparator(target));
		ArrayList<IContributionItem> actions = new ArrayList<IContributionItem>(
				descriptors.size());
		String category = null;
		for (IItemJavaElementDescriptor descriptor : descriptors) {
			String newCategory = descriptor.getCategory(target);
			if (category == null ? newCategory != null : !category
					.equals(newCategory)) {
				category = newCategory;
				if (!actions.isEmpty())
					actions.add(new Separator());
			}

			IAction action = createAction(descriptor, target);
			actions.add(new ActionContributionItem(action));
		}

		return actions.toArray(new IContributionItem[actions.size()]);
	}

	protected IAction createAction(IItemJavaElementDescriptor descriptor,
			Object target) {
		return new OpenGeneratedAction(descriptor, target);
	}

	@Override
	public void dispose() {
		if (adapterFactory != null) {
			adapterFactory.dispose();
			adapterFactory = null;
		}

		super.dispose();
	}

	protected static class DescriptorComparator implements
			Comparator<IItemJavaElementDescriptor> {

		protected final Object target;

		public DescriptorComparator(Object target) {
			this.target = target;
		}

		public int compare(IItemJavaElementDescriptor o1,
				IItemJavaElementDescriptor o2) {
			String category1 = o1.getCategory(target);
			String category2 = o2.getCategory(target);
			if (category1 == null) {
				if (category2 != null)
					return -1;
			} else {
				if (category2 == null)
					return 1;

				int result = category1.compareTo(category2);
				if (result != 0)
					return result;
			}

			String name1 = o1.getDisplayName(target);
			String name2 = o2.getDisplayName(target);
			if (name1 == null)
				return name2 == null ? 0 : -1;

			if (name2 == null)
				return 1;

			return name1.compareTo(name2);
		}
	}
}
