/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.http.internal.server;

import java.text.MessageFormat;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.connector.ConnectorLocation;
import org.eclipse.net4j.http.internal.common.HTTPConnector;
import org.eclipse.net4j.http.internal.server.HTTPAcceptor;
import org.eclipse.net4j.protocol.IProtocol;

public class HTTPServerConnector
extends HTTPConnector {
    private HTTPAcceptor acceptor;

    public HTTPServerConnector(HTTPAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public HTTPAcceptor getAcceptor() {
        return this.acceptor;
    }

    public ConnectorLocation getLocation() {
        return ConnectorLocation.SERVER;
    }

    public String getURL() {
        return "agent://connector:" + this.getConnectorID();
    }

    public int getMaxIdleTime() {
        return this.acceptor.getMaxIdleTime();
    }

    public String toString() {
        if (this.getUserID() == null) {
            return MessageFormat.format("HTTPServerConnector[{0}]", this.getConnectorID());
        }
        return MessageFormat.format("HTTPServerConnector[{1}@{0}]", this.getConnectorID(), this.getUserID());
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.leaveConnecting();
    }

    protected void registerChannelWithPeer(int channelID, short channelIndex, IProtocol protocol, long timeout) throws ConnectorException {
        throw new UnsupportedOperationException();
    }

    protected boolean pollAgain() {
        try {
            Thread.sleep(100L);
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }
}

