/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDOAuthenticationResult;
import org.eclipse.emf.cdo.common.protocol.CDOAuthenticator;
import org.eclipse.emf.cdo.common.revision.cache.CDORevisionCache;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionConfiguration;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.SecurityUtil;

public abstract class CDOSessionConfigurationImpl
implements CDOSessionConfiguration {
    private InternalCDOSession session;
    private String repositoryName;
    private CDOSession.ExceptionHandler exceptionHandler;
    private CDOPackageRegistry packageRegistry;
    private CDORevisionCache revisionCache;
    private CDOAuthenticator authenticator = new AuthenticatorImpl();
    private boolean activateOnOpen = true;

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.checkNotOpen();
        this.repositoryName = repositoryName;
    }

    public CDOSession.ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(CDOSession.ExceptionHandler exceptionHandler) {
        this.checkNotOpen();
        this.exceptionHandler = exceptionHandler;
    }

    public CDOPackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    public void setPackageRegistry(CDOPackageRegistry packageRegistry) {
        this.checkNotOpen();
        this.packageRegistry = packageRegistry;
    }

    public CDORevisionCache getRevisionCache() {
        return this.revisionCache;
    }

    public void setRevisionCache(CDORevisionCache revisionCache) {
        this.checkNotOpen();
        this.revisionCache = revisionCache;
    }

    public CDOAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(CDOAuthenticator authenticator) {
        this.checkNotOpen();
        this.authenticator = authenticator;
    }

    public boolean isActivateOnOpen() {
        return this.activateOnOpen;
    }

    public void setActivateOnOpen(boolean activateOnOpen) {
        this.checkNotOpen();
        this.activateOnOpen = activateOnOpen;
    }

    public boolean isSessionOpen() {
        if (this.session == null) {
            return false;
        }
        if (!this.session.isClosed()) {
            return true;
        }
        this.session = null;
        return false;
    }

    public CDOSession openSession() {
        if (!this.isSessionOpen()) {
            this.session = this.createSession();
            this.session.setRepositoryName(this.repositoryName);
            this.session.setPackageRegistry((InternalCDOPackageRegistry)this.packageRegistry);
            this.session.getRevisionManager().setCache(this.revisionCache);
            this.session.setAuthenticator(this.authenticator);
            if (this.activateOnOpen) {
                this.session.activate();
            }
        }
        return this.session;
    }

    protected void checkNotOpen() {
        if (this.isSessionOpen()) {
            throw new IllegalStateException(Messages.getString("CDOSessionConfigurationImpl.0"));
        }
    }

    protected abstract InternalCDOSession createSession();

    protected class AuthenticatorImpl
    implements CDOAuthenticator {
        private String encryptionAlgorithmName = "PBEWithMD5AndDES";
        private byte[] encryptionSaltBytes = SecurityUtil.DEFAULT_SALT;
        private int encryptionIterationCount = 20;
        private IPasswordCredentialsProvider credentialsProvider;

        public String getEncryptionAlgorithmName() {
            return this.encryptionAlgorithmName;
        }

        public void setEncryptionAlgorithmName(String encryptionAlgorithmName) {
            this.checkSessionNotOpened();
            this.encryptionAlgorithmName = encryptionAlgorithmName;
        }

        public byte[] getEncryptionSaltBytes() {
            return this.encryptionSaltBytes;
        }

        public void setEncryptionSaltBytes(byte[] encryptionSaltBytes) {
            this.checkSessionNotOpened();
            this.encryptionSaltBytes = encryptionSaltBytes;
        }

        public int getEncryptionIterationCount() {
            return this.encryptionIterationCount;
        }

        public void setEncryptionIterationCount(int encryptionIterationCount) {
            this.checkSessionNotOpened();
            this.encryptionIterationCount = encryptionIterationCount;
        }

        public IPasswordCredentialsProvider getCredentialsProvider() {
            return this.credentialsProvider;
        }

        public void setCredentialsProvider(IPasswordCredentialsProvider credentialsProvider) {
            this.checkSessionNotOpened();
            this.credentialsProvider = credentialsProvider;
        }

        public CDOAuthenticationResult authenticate(byte[] randomToken) {
            if (this.credentialsProvider == null) {
                throw new IllegalStateException("No credentials provider configured");
            }
            IPasswordCredentials credentials = this.credentialsProvider.getCredentials();
            String userID = credentials.getUserID();
            CDOSessionConfigurationImpl.this.session.setUserID(userID);
            byte[] cryptedToken = this.encryptToken(credentials.getPassword(), randomToken);
            return new CDOAuthenticationResult(userID, cryptedToken);
        }

        protected byte[] encryptToken(char[] password, byte[] token) {
            try {
                return SecurityUtil.encrypt((byte[])token, (char[])password, (String)this.encryptionAlgorithmName, (byte[])this.encryptionSaltBytes, (int)this.encryptionIterationCount);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SecurityException(ex);
            }
        }

        private void checkSessionNotOpened() {
            if (CDOSessionConfigurationImpl.this.session != null) {
                throw new IllegalStateException("Not allowed after the session has been opened");
            }
        }
    }
}

