/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.internal.cdo.net4j.protocol.LoadRevisionRequest;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class LoadRevisionByVersionRequest
extends LoadRevisionRequest {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadRevisionByVersionRequest.class);
    private int version;

    public LoadRevisionByVersionRequest(CDOClientProtocol protocol, CDOID id, int referenceChunk, int version) {
        super(protocol, (short)9, Collections.singleton(id), referenceChunk);
        this.version = version;
    }

    protected void requesting(CDODataOutput out) throws IOException {
        super.requesting(out);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing version: {0}", new Object[]{this.version});
        }
        out.writeInt(this.version);
    }

    public String toString() {
        return MessageFormat.format("{0}(ids={1}, referenceChunk={2}, version={3})", ((Object)((Object)this)).getClass().getSimpleName(), this.getIds(), this.getReferenceChunk(), this.version);
    }
}

