/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.debug.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.m2m.atl.adt.debug.Messages;
import org.eclipse.m2m.atl.adt.debug.core.AtlDebugTarget;
import org.eclipse.m2m.atl.adt.debug.core.AtlStackFrame;
import org.eclipse.m2m.atl.adt.debug.core.AtlValue;
import org.eclipse.m2m.atl.adt.debug.core.ocl.OclHelper;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMXMLWriter;
import org.eclipse.m2m.atl.engine.vm.adwp.ADWPDebugger;
import org.eclipse.m2m.atl.engine.vm.adwp.StringValue;
import org.eclipse.m2m.atl.engine.vm.adwp.Value;

public class AtlWatchExpressionDelegate
implements IWatchExpressionDelegate {
    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        AtlStackFrame frame = null;
        if (context instanceof AtlStackFrame) {
            frame = (AtlStackFrame)context;
        } else if (context instanceof IThread) {
            try {
                frame = (AtlStackFrame)((IThread)context).getTopStackFrame();
            }
            catch (DebugException e) {
                ATLLogger.log((Level)Level.INFO, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (frame == null) {
            listener.watchEvaluationFinished(null);
        } else {
            AtlWatchExpressionResult atlwe = this.doEvaluation(frame, expression);
            listener.watchEvaluationFinished((IWatchExpressionResult)atlwe);
        }
    }

    private AtlWatchExpressionResult doEvaluation(AtlStackFrame frame, String expression) {
        DebugException de = null;
        String[] errorMessages = null;
        AtlValue value = null;
        try {
            ArrayList<String> parameters = new ArrayList<String>();
            IVariable[] variables = frame.getVariables();
            int i = 0;
            while (i < variables.length) {
                String pname = variables[i].getName();
                if (!pname.equals("self")) {
                    parameters.add(pname);
                }
                ++i;
            }
            ASM asm = new OclHelper(expression, parameters).compile();
            StringWriter sw = new StringWriter();
            new ASMXMLWriter(new PrintWriter(sw), false).print(asm);
            AtlDebugTarget debugTarget = (AtlDebugTarget)frame.getDebugTarget();
            ADWPDebugger debugger = debugTarget.getDebugger();
            Value val = debugger.request(21, Arrays.asList(frame.getStackFrame(), StringValue.valueOf((String)sw.toString())));
            value = new AtlValue(val, debugTarget);
        }
        catch (DebugException e) {
            de = e;
        }
        catch (IOException e) {
            de = new DebugException((IStatus)new Status(4, "org.eclipse.m2m.atl.adt.debug", 0, Messages.getString("AtlWatchExpressionDelegate.EXPRESSIONERROR"), (Throwable)e));
        }
        return new AtlWatchExpressionResult(de, errorMessages, value);
    }

    class AtlWatchExpressionResult
    implements IWatchExpressionResult {
        String[] errorMessages;
        IValue value;
        DebugException de;

        public AtlWatchExpressionResult(DebugException de, String[] errorMessages, IValue value) {
            this.errorMessages = errorMessages;
            this.value = value;
        }

        public IValue getValue() {
            return this.value;
        }

        public boolean hasErrors() {
            return this.errorMessages != null && this.errorMessages.length > 0;
        }

        public String[] getErrorMessages() {
            return this.errorMessages;
        }

        public String getExpressionText() {
            try {
                return this.value.getValueString();
            }
            catch (DebugException debugException) {
                return null;
            }
        }

        public DebugException getException() {
            return this.de;
        }
    }
}

