
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link SwarmInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSwarmInfo.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableSwarmInfo implements SwarmInfo {
  private final @Nullable SwarmCluster cluster;
  private final boolean controlAvailable;
  private final String error;
  private final String localNodeState;
  private final String nodeAddr;
  private final String nodeId;
  private final @Nullable Integer nodes;
  private final @Nullable Integer managers;
  private final @Nullable List<RemoteManager> remoteManagers;

  private ImmutableSwarmInfo(
      @Nullable SwarmCluster cluster,
      boolean controlAvailable,
      String error,
      String localNodeState,
      String nodeAddr,
      String nodeId,
      @Nullable Integer nodes,
      @Nullable Integer managers,
      @Nullable List<RemoteManager> remoteManagers) {
    this.cluster = cluster;
    this.controlAvailable = controlAvailable;
    this.error = error;
    this.localNodeState = localNodeState;
    this.nodeAddr = nodeAddr;
    this.nodeId = nodeId;
    this.nodes = nodes;
    this.managers = managers;
    this.remoteManagers = remoteManagers;
  }

  /**
   * @return The value of the {@code cluster} attribute
   */
  @JsonProperty("Cluster")
  @Override
  public @Nullable SwarmCluster cluster() {
    return cluster;
  }

  /**
   * @return The value of the {@code controlAvailable} attribute
   */
  @JsonProperty("ControlAvailable")
  @Override
  public boolean controlAvailable() {
    return controlAvailable;
  }

  /**
   * @return The value of the {@code error} attribute
   */
  @JsonProperty("Error")
  @Override
  public String error() {
    return error;
  }

  /**
   * @return The value of the {@code localNodeState} attribute
   */
  @JsonProperty("LocalNodeState")
  @Override
  public String localNodeState() {
    return localNodeState;
  }

  /**
   * @return The value of the {@code nodeAddr} attribute
   */
  @JsonProperty("NodeAddr")
  @Override
  public String nodeAddr() {
    return nodeAddr;
  }

  /**
   * @return The value of the {@code nodeId} attribute
   */
  @JsonProperty("NodeID")
  @Override
  public String nodeId() {
    return nodeId;
  }

  /**
   * @return The value of the {@code nodes} attribute
   */
  @JsonProperty("Nodes")
  @Override
  public @Nullable Integer nodes() {
    return nodes;
  }

  /**
   * @return The value of the {@code managers} attribute
   */
  @JsonProperty("Managers")
  @Override
  public @Nullable Integer managers() {
    return managers;
  }

  /**
   * @return The value of the {@code remoteManagers} attribute
   */
  @JsonProperty("RemoteManagers")
  @Override
  public @Nullable List<RemoteManager> remoteManagers() {
    return remoteManagers;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmInfo#cluster() cluster} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cluster (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableSwarmInfo withCluster(@Nullable SwarmCluster value) {
    if (this.cluster == value) return this;
    return new ImmutableSwarmInfo(
        value,
        this.controlAvailable,
        this.error,
        this.localNodeState,
        this.nodeAddr,
        this.nodeId,
        this.nodes,
        this.managers,
        this.remoteManagers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmInfo#controlAvailable() controlAvailable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for controlAvailable
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableSwarmInfo withControlAvailable(boolean value) {
    if (this.controlAvailable == value) return this;
    return new ImmutableSwarmInfo(
        this.cluster,
        value,
        this.error,
        this.localNodeState,
        this.nodeAddr,
        this.nodeId,
        this.nodes,
        this.managers,
        this.remoteManagers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmInfo#error() error} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for error
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableSwarmInfo withError(String value) {
    String newValue = Objects.requireNonNull(value, "error");
    if (this.error.equals(newValue)) return this;
    return new ImmutableSwarmInfo(
        this.cluster,
        this.controlAvailable,
        newValue,
        this.localNodeState,
        this.nodeAddr,
        this.nodeId,
        this.nodes,
        this.managers,
        this.remoteManagers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmInfo#localNodeState() localNodeState} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for localNodeState
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableSwarmInfo withLocalNodeState(String value) {
    String newValue = Objects.requireNonNull(value, "localNodeState");
    if (this.localNodeState.equals(newValue)) return this;
    return new ImmutableSwarmInfo(
        this.cluster,
        this.controlAvailable,
        this.error,
        newValue,
        this.nodeAddr,
        this.nodeId,
        this.nodes,
        this.managers,
        this.remoteManagers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmInfo#nodeAddr() nodeAddr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeAddr
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableSwarmInfo withNodeAddr(String value) {
    String newValue = Objects.requireNonNull(value, "nodeAddr");
    if (this.nodeAddr.equals(newValue)) return this;
    return new ImmutableSwarmInfo(
        this.cluster,
        this.controlAvailable,
        this.error,
        this.localNodeState,
        newValue,
        this.nodeId,
        this.nodes,
        this.managers,
        this.remoteManagers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmInfo#nodeId() nodeId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableSwarmInfo withNodeId(String value) {
    String newValue = Objects.requireNonNull(value, "nodeId");
    if (this.nodeId.equals(newValue)) return this;
    return new ImmutableSwarmInfo(
        this.cluster,
        this.controlAvailable,
        this.error,
        this.localNodeState,
        this.nodeAddr,
        newValue,
        this.nodes,
        this.managers,
        this.remoteManagers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmInfo#nodes() nodes} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodes (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableSwarmInfo withNodes(@Nullable Integer value) {
    if (Objects.equals(this.nodes, value)) return this;
    return new ImmutableSwarmInfo(
        this.cluster,
        this.controlAvailable,
        this.error,
        this.localNodeState,
        this.nodeAddr,
        this.nodeId,
        value,
        this.managers,
        this.remoteManagers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmInfo#managers() managers} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for managers (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableSwarmInfo withManagers(@Nullable Integer value) {
    if (Objects.equals(this.managers, value)) return this;
    return new ImmutableSwarmInfo(
        this.cluster,
        this.controlAvailable,
        this.error,
        this.localNodeState,
        this.nodeAddr,
        this.nodeId,
        this.nodes,
        value,
        this.remoteManagers);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SwarmInfo#remoteManagers() remoteManagers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSwarmInfo withRemoteManagers(@Nullable RemoteManager... elements) {
    if (elements == null) {
      if (this.remoteManagers == null) return this;
      return new ImmutableSwarmInfo(
          this.cluster,
          this.controlAvailable,
          this.error,
          this.localNodeState,
          this.nodeAddr,
          this.nodeId,
          this.nodes,
          this.managers,
          null);
    }
    List<RemoteManager> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableSwarmInfo(
        this.cluster,
        this.controlAvailable,
        this.error,
        this.localNodeState,
        this.nodeAddr,
        this.nodeId,
        this.nodes,
        this.managers,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SwarmInfo#remoteManagers() remoteManagers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of remoteManagers elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableSwarmInfo withRemoteManagers(@Nullable Iterable<? extends RemoteManager> elements) {
    if (this.remoteManagers == elements) return this;
    @Nullable List<RemoteManager> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableSwarmInfo(
        this.cluster,
        this.controlAvailable,
        this.error,
        this.localNodeState,
        this.nodeAddr,
        this.nodeId,
        this.nodes,
        this.managers,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSwarmInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSwarmInfo
        && equalsByValue((ImmutableSwarmInfo) another);
  }

  private boolean equalsByValue(ImmutableSwarmInfo another) {
    return Objects.equals(cluster, another.cluster)
        && controlAvailable == another.controlAvailable
        && error.equals(another.error)
        && localNodeState.equals(another.localNodeState)
        && nodeAddr.equals(another.nodeAddr)
        && nodeId.equals(another.nodeId)
        && Objects.equals(nodes, another.nodes)
        && Objects.equals(managers, another.managers)
        && Objects.equals(remoteManagers, another.remoteManagers);
  }

  /**
   * Computes a hash code from attributes: {@code cluster}, {@code controlAvailable}, {@code error}, {@code localNodeState}, {@code nodeAddr}, {@code nodeId}, {@code nodes}, {@code managers}, {@code remoteManagers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(cluster);
    h += (h << 5) + Boolean.hashCode(controlAvailable);
    h += (h << 5) + error.hashCode();
    h += (h << 5) + localNodeState.hashCode();
    h += (h << 5) + nodeAddr.hashCode();
    h += (h << 5) + nodeId.hashCode();
    h += (h << 5) + Objects.hashCode(nodes);
    h += (h << 5) + Objects.hashCode(managers);
    h += (h << 5) + Objects.hashCode(remoteManagers);
    return h;
  }

  /**
   * Prints the immutable value {@code SwarmInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SwarmInfo{"
        + "cluster=" + cluster
        + ", controlAvailable=" + controlAvailable
        + ", error=" + error
        + ", localNodeState=" + localNodeState
        + ", nodeAddr=" + nodeAddr
        + ", nodeId=" + nodeId
        + ", nodes=" + nodes
        + ", managers=" + managers
        + ", remoteManagers=" + remoteManagers
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link SwarmInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SwarmInfo instance
   */
  public static ImmutableSwarmInfo copyOf(SwarmInfo instance) {
    if (instance instanceof ImmutableSwarmInfo) {
      return (ImmutableSwarmInfo) instance;
    }
    return ImmutableSwarmInfo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSwarmInfo ImmutableSwarmInfo}.
   * <pre>
   * ImmutableSwarmInfo.builder()
   *    .cluster(org.mandas.docker.client.messages.swarm.SwarmCluster | null) // nullable {@link SwarmInfo#cluster() cluster}
   *    .controlAvailable(boolean) // required {@link SwarmInfo#controlAvailable() controlAvailable}
   *    .error(String) // required {@link SwarmInfo#error() error}
   *    .localNodeState(String) // required {@link SwarmInfo#localNodeState() localNodeState}
   *    .nodeAddr(String) // required {@link SwarmInfo#nodeAddr() nodeAddr}
   *    .nodeId(String) // required {@link SwarmInfo#nodeId() nodeId}
   *    .nodes(Integer | null) // nullable {@link SwarmInfo#nodes() nodes}
   *    .managers(Integer | null) // nullable {@link SwarmInfo#managers() managers}
   *    .remoteManagers(List&lt;org.mandas.docker.client.messages.swarm.RemoteManager&gt; | null) // nullable {@link SwarmInfo#remoteManagers() remoteManagers}
   *    .build();
   * </pre>
   * @return A new ImmutableSwarmInfo builder
   */
  public static ImmutableSwarmInfo.Builder builder() {
    return new ImmutableSwarmInfo.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSwarmInfo ImmutableSwarmInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_CONTROL_AVAILABLE = 0x1L;
    private static final long INIT_BIT_ERROR = 0x2L;
    private static final long INIT_BIT_LOCAL_NODE_STATE = 0x4L;
    private static final long INIT_BIT_NODE_ADDR = 0x8L;
    private static final long INIT_BIT_NODE_ID = 0x10L;
    private long initBits = 0x1fL;

    private SwarmCluster cluster;
    private boolean controlAvailable;
    private String error;
    private String localNodeState;
    private String nodeAddr;
    private String nodeId;
    private Integer nodes;
    private Integer managers;
    private List<RemoteManager> remoteManagers = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SwarmInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SwarmInfo instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable SwarmCluster clusterValue = instance.cluster();
      if (clusterValue != null) {
        cluster(clusterValue);
      }
      this.controlAvailable(instance.controlAvailable());
      this.error(instance.error());
      this.localNodeState(instance.localNodeState());
      this.nodeAddr(instance.nodeAddr());
      this.nodeId(instance.nodeId());
      @Nullable Integer nodesValue = instance.nodes();
      if (nodesValue != null) {
        nodes(nodesValue);
      }
      @Nullable Integer managersValue = instance.managers();
      if (managersValue != null) {
        managers(managersValue);
      }
      @Nullable List<RemoteManager> remoteManagersValue = instance.remoteManagers();
      if (remoteManagersValue != null) {
        addAllRemoteManagers(remoteManagersValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmInfo#cluster() cluster} attribute.
     * @param cluster The value for cluster (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Cluster")
    public final Builder cluster(@Nullable SwarmCluster cluster) {
      this.cluster = cluster;
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmInfo#controlAvailable() controlAvailable} attribute.
     * @param controlAvailable The value for controlAvailable 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ControlAvailable")
    public final Builder controlAvailable(boolean controlAvailable) {
      this.controlAvailable = controlAvailable;
      initBits &= ~INIT_BIT_CONTROL_AVAILABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmInfo#error() error} attribute.
     * @param error The value for error 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Error")
    public final Builder error(String error) {
      this.error = Objects.requireNonNull(error, "error");
      initBits &= ~INIT_BIT_ERROR;
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmInfo#localNodeState() localNodeState} attribute.
     * @param localNodeState The value for localNodeState 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("LocalNodeState")
    public final Builder localNodeState(String localNodeState) {
      this.localNodeState = Objects.requireNonNull(localNodeState, "localNodeState");
      initBits &= ~INIT_BIT_LOCAL_NODE_STATE;
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmInfo#nodeAddr() nodeAddr} attribute.
     * @param nodeAddr The value for nodeAddr 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NodeAddr")
    public final Builder nodeAddr(String nodeAddr) {
      this.nodeAddr = Objects.requireNonNull(nodeAddr, "nodeAddr");
      initBits &= ~INIT_BIT_NODE_ADDR;
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmInfo#nodeId() nodeId} attribute.
     * @param nodeId The value for nodeId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NodeID")
    public final Builder nodeId(String nodeId) {
      this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
      initBits &= ~INIT_BIT_NODE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmInfo#nodes() nodes} attribute.
     * @param nodes The value for nodes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Nodes")
    public final Builder nodes(@Nullable Integer nodes) {
      this.nodes = nodes;
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmInfo#managers() managers} attribute.
     * @param managers The value for managers (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Managers")
    public final Builder managers(@Nullable Integer managers) {
      this.managers = managers;
      return this;
    }

    /**
     * Adds one element to {@link SwarmInfo#remoteManagers() remoteManagers} list.
     * @param element A remoteManagers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder remoteManager(RemoteManager element) {
      if (this.remoteManagers == null) {
        this.remoteManagers = new ArrayList<RemoteManager>();
      }
      this.remoteManagers.add(Objects.requireNonNull(element, "remoteManagers element"));
      return this;
    }

    /**
     * Adds elements to {@link SwarmInfo#remoteManagers() remoteManagers} list.
     * @param elements An array of remoteManagers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder remoteManagers(RemoteManager... elements) {
      if (this.remoteManagers == null) {
        this.remoteManagers = new ArrayList<RemoteManager>();
      }
      for (RemoteManager element : elements) {
        this.remoteManagers.add(Objects.requireNonNull(element, "remoteManagers element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SwarmInfo#remoteManagers() remoteManagers} list.
     * @param elements An iterable of remoteManagers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("RemoteManagers")
    public final Builder remoteManagers(@Nullable Iterable<? extends RemoteManager> elements) {
      if (elements == null) {
        this.remoteManagers = null;
        return this;
      }
      this.remoteManagers = new ArrayList<RemoteManager>();
      return addAllRemoteManagers(elements);
    }

    /**
     * Adds elements to {@link SwarmInfo#remoteManagers() remoteManagers} list.
     * @param elements An iterable of remoteManagers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRemoteManagers(Iterable<? extends RemoteManager> elements) {
      Objects.requireNonNull(elements, "remoteManagers element");
      if (this.remoteManagers == null) {
        this.remoteManagers = new ArrayList<RemoteManager>();
      }
      for (RemoteManager element : elements) {
        this.remoteManagers.add(Objects.requireNonNull(element, "remoteManagers element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableSwarmInfo ImmutableSwarmInfo}.
     * @return An immutable instance of SwarmInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSwarmInfo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSwarmInfo(
          cluster,
          controlAvailable,
          error,
          localNodeState,
          nodeAddr,
          nodeId,
          nodes,
          managers,
          remoteManagers == null ? null : createUnmodifiableList(true, remoteManagers));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONTROL_AVAILABLE) != 0) attributes.add("controlAvailable");
      if ((initBits & INIT_BIT_ERROR) != 0) attributes.add("error");
      if ((initBits & INIT_BIT_LOCAL_NODE_STATE) != 0) attributes.add("localNodeState");
      if ((initBits & INIT_BIT_NODE_ADDR) != 0) attributes.add("nodeAddr");
      if ((initBits & INIT_BIT_NODE_ID) != 0) attributes.add("nodeId");
      return "Cannot build SwarmInfo, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
