/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.operations;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.glsp.server.actions.TriggerEdgeCreationAction;
import org.eclipse.glsp.server.actions.TriggerElementCreationAction;
import org.eclipse.glsp.server.actions.TriggerNodeCreationAction;
import org.eclipse.glsp.server.operations.CreateEdgeOperation;
import org.eclipse.glsp.server.operations.CreateNodeOperation;
import org.eclipse.glsp.server.operations.CreateOperation;
import org.eclipse.glsp.server.operations.Operation;
import org.eclipse.glsp.server.operations.OperationHandler;

public interface CreateOperationHandler
extends OperationHandler {
    public Class<? extends CreateOperation> getHandledOperationType();

    default public List<TriggerElementCreationAction> getTriggerActions() {
        if (CreateNodeOperation.class.isAssignableFrom(this.getHandledOperationType())) {
            return this.getHandledElementTypeIds().stream().map(TriggerNodeCreationAction::new).collect(Collectors.toList());
        }
        if (CreateEdgeOperation.class.isAssignableFrom(this.getHandledOperationType())) {
            return this.getHandledElementTypeIds().stream().map(TriggerEdgeCreationAction::new).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public List<String> getHandledElementTypeIds();

    @Override
    default public boolean handles(Operation operation) {
        return OperationHandler.super.handles(operation) && this.getHandledElementTypeIds().contains(this.getHandledOperationType().cast(operation).getElementTypeId());
    }
}

