/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.operations.gmodel;

import java.util.Optional;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.BasicCreateOperationHandler;
import org.eclipse.glsp.server.operations.CreateEdgeOperation;
import org.eclipse.glsp.server.utils.GModelUtil;

public abstract class CreateEdgeOperationHandler
extends BasicCreateOperationHandler<CreateEdgeOperation> {
    private final String label;

    public CreateEdgeOperationHandler(String elementTypeId, String label) {
        super(elementTypeId);
        this.label = label;
    }

    @Override
    public void executeOperation(CreateEdgeOperation action, GModelState modelState) {
        if (action.getSourceElementId() == null || action.getTargetElementId() == null) {
            throw new IllegalArgumentException("Incomplete create connection action");
        }
        GModelIndex index = modelState.getIndex();
        Optional source = index.findElement(action.getSourceElementId(), GModelUtil.IS_CONNECTABLE);
        Optional target = index.findElement(action.getTargetElementId(), GModelUtil.IS_CONNECTABLE);
        if (!source.isPresent() || !target.isPresent()) {
            throw new IllegalArgumentException("Invalid source or target for source ID " + action.getSourceElementId() + " and target ID " + action.getTargetElementId());
        }
        Optional<GEdge> connection = this.createEdge((GModelElement)source.get(), (GModelElement)target.get(), modelState);
        if (!connection.isPresent()) {
            throw new IllegalArgumentException(String.format("Creation of connection failed for source: %s , target: %s", ((GModelElement)source.get()).getId(), ((GModelElement)target.get()).getId()));
        }
        GModelRoot currentModel = (GModelRoot)modelState.getRoot();
        currentModel.getChildren().add((Object)((GModelElement)connection.get()));
    }

    protected abstract Optional<GEdge> createEdge(GModelElement var1, GModelElement var2, GModelState var3);

    @Override
    public String getLabel() {
        return this.label;
    }
}

