/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.di;

import com.google.inject.Inject;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionHandler;
import org.eclipse.glsp.server.actions.ActionHandlerRegistry;
import org.eclipse.glsp.server.internal.di.MapMultiRegistry;
import org.eclipse.glsp.server.utils.Handler;

public class DIActionHandlerRegistry
extends MapMultiRegistry<Class<? extends Action>, ActionHandler>
implements ActionHandlerRegistry {
    @Inject
    public DIActionHandlerRegistry(Set<ActionHandler> handlers) {
        handlers.forEach(handler -> handler.getHandledActionTypes().forEach(action -> {
            boolean bl = this.register(action, handler);
        }));
    }

    @Override
    public List<ActionHandler> get(Class<? extends Action> key) {
        Optional<Class> potentialKey;
        List<ActionHandler> result = super.get(key);
        if (result.isEmpty() && (potentialKey = this.elements.keySet().stream().filter(actionClass -> actionClass.isAssignableFrom(key)).findFirst()).isPresent()) {
            result = super.get(potentialKey.get());
            result.forEach(actionClass -> {
                boolean bl = this.register(key, actionClass);
            });
        }
        result.sort(Comparator.comparing(Handler::getPriority));
        return result;
    }
}

