/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.actions;

import java.util.Arrays;
import java.util.List;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionHandler;
import org.eclipse.glsp.server.internal.util.GenericsUtil;
import org.eclipse.glsp.server.model.GModelState;

public abstract class BasicActionHandler<T extends Action>
implements ActionHandler {
    protected final Class<T> actionType = this.deriveActionType();

    protected Class<T> deriveActionType() {
        return GenericsUtil.getGenericTypeParameterClass(this.getClass(), BasicActionHandler.class);
    }

    @Override
    public boolean handles(Action action) {
        return this.actionType.isInstance(action);
    }

    @Override
    public List<Action> execute(Action action, GModelState modelState) {
        if (this.handles(action)) {
            Action actualAction = (Action)this.actionType.cast(action);
            return this.executeAction(actualAction, modelState);
        }
        return this.none();
    }

    protected abstract List<Action> executeAction(T var1, GModelState var2);

    public Class<T> getActionType() {
        return this.actionType;
    }

    @Override
    public List<Class<? extends Action>> getHandledActionTypes() {
        return Arrays.asList(this.actionType);
    }
}

