/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.launch;

import com.google.inject.Module;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.elk.alg.layered.options.LayeredMetaDataProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.glsp.example.workflow.WorkflowDiagramModule;
import org.eclipse.glsp.example.workflow.launch.WorkflowCLIParser;
import org.eclipse.glsp.layout.ElkLayoutEngine;
import org.eclipse.glsp.server.di.DiagramModule;
import org.eclipse.glsp.server.di.ServerModule;
import org.eclipse.glsp.server.launch.DefaultCLIParser;
import org.eclipse.glsp.server.launch.SocketGLSPServerLauncher;
import org.eclipse.glsp.server.utils.LaunchUtil;
import org.eclipse.glsp.server.websocket.WebsocketServerLauncher;

public final class WorkflowServerLauncher {
    private WorkflowServerLauncher() {
    }

    public static void main(String[] args) {
        String processName = "org.eclipse.glsp.example.workflow-X.X.X-glsp.jar";
        try {
            WorkflowCLIParser parser = new WorkflowCLIParser(args, processName);
            ElkLayoutEngine.initialize((ILayoutMetaDataProvider[])new ILayoutMetaDataProvider[]{new LayeredMetaDataProvider()});
            int port = parser.parsePort();
            ServerModule workflowServerModule = new ServerModule().configureDiagramModule((DiagramModule)new WorkflowDiagramModule(), new Module[0]);
            WebsocketServerLauncher launcher = parser.isWebsocket() ? new WebsocketServerLauncher(workflowServerModule, "/workflow", parser.parseWebsocketLogLevel(), new Module[0]) : new SocketGLSPServerLauncher(workflowServerModule, new Module[0]);
            launcher.start("localhost", port, (DefaultCLIParser)parser);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            System.out.println();
            LaunchUtil.printHelp((String)processName, (Options)WorkflowCLIParser.getDefaultOptions());
        }
    }
}

