/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.commons;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.dsl.Dsl;
import org.osgi.framework.Bundle;

public class DslHelper {
    public static Bundle getDslBundle(String languageName) {
        IConfigurationElement[] languages;
        IConfigurationElement[] iConfigurationElementArray = languages = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gemoc.gemoc_language_workbench.sequential.xdsml");
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement lang = iConfigurationElementArray[n2];
            String xdsmlPath = lang.getAttribute("xdsmlFilePath");
            String xdsmlName = lang.getAttribute("name");
            if (xdsmlName.equals(languageName) && xdsmlPath.endsWith(".dsl")) {
                String dslBundleName = lang.getContributor().getName();
                return Platform.getBundle((String)dslBundleName);
            }
            ++n2;
        }
        return null;
    }

    public static List<String> getAllLanguages() {
        IConfigurationElement[] languages;
        ArrayList<String> languagesNames = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = languages = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gemoc.gemoc_language_workbench.sequential.xdsml");
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement lang = iConfigurationElementArray[n2];
            languagesNames.add(lang.getAttribute("name"));
            ++n2;
        }
        return languagesNames;
    }

    public static Dsl load(String languageName) {
        IConfigurationElement[] languages;
        IConfigurationElement[] iConfigurationElementArray = languages = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gemoc.gemoc_language_workbench.sequential.xdsml");
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement lang = iConfigurationElementArray[n2];
            String xdsmlPath = lang.getAttribute("xdsmlFilePath");
            String xdsmlName = lang.getAttribute("name");
            if (xdsmlName.equals(languageName) && xdsmlPath.endsWith(".dsl")) {
                Resource res = new ResourceSetImpl().getResource(URI.createURI((String)xdsmlPath), true);
                Dsl dsl = (Dsl)res.getContents().get(0);
                return dsl;
            }
            ++n2;
        }
        return null;
    }

    public static String lastSegment(String qualifiedName) {
        if (qualifiedName.contains(".")) {
            return qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);
        }
        return qualifiedName;
    }
}

