/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.GenericProtocolClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.etrice.generator.java.Main;
import org.eclipse.etrice.generator.java.gen.DataClassGen;
import org.eclipse.etrice.generator.java.gen.Initialization;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.etrice.generator.java.setup.GeneratorOptionsHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ProtocolClassGen
extends GenericProtocolClassGenerator {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    private Initialization _initialization;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    private DataClassGen _dataClassGen;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    private IDiagnostician diagnostician;

    public void doGenerate(Root root) {
        Functions.Function1 function1 = it -> {
            boolean bl = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !bl;
        };
        Consumer<ProtocolClass> consumer = pc -> {
            CharSequence contents;
            boolean bl;
            String path = this._roomExtensions.getPath((RoomClass)pc);
            String file = this._javaExtensions.getJavaFileName((RoomClass)pc);
            CharSequence charSequence = null;
            CommunicationType communicationType = pc.getCommType();
            if (communicationType != null) {
                switch (communicationType) {
                    case EVENT_DRIVEN: {
                        charSequence = this.generate(root, (ProtocolClass)pc);
                        break;
                    }
                    case DATA_DRIVEN: {
                        charSequence = this.generateDataDriven(root, (ProtocolClass)pc);
                        break;
                    }
                    case SYNCHRONOUS: {
                        charSequence = "";
                        break;
                    }
                }
            }
            if (bl = (contents = charSequence).toString().isEmpty()) {
                this.diagnostician.error("synchronous protocols not supported yet", (EObject)pc, null);
            } else {
                this.fileIO.generateFile("generating ProtocolClass implementation", path + file, contents);
            }
        };
        IterableExtensions.filter((Iterable)root.getProtocolClasses(), (Functions.Function1)function1).forEach(consumer);
    }

    public CharSequence generate(Root root, ProtocolClass pc) {
        String string;
        CharSequence charSequence;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("package ");
        String string2 = this._roomExtensions.getPackage((RoomClass)pc);
        stringConcatenation.append(string2);
        stringConcatenation.append(";");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("import org.eclipse.etrice.runtime.java.messaging.Message;");
        stringConcatenation.newLine();
        stringConcatenation.append("import org.eclipse.etrice.runtime.java.modelbase.EventMessage;");
        stringConcatenation.newLine();
        stringConcatenation.append("import org.eclipse.etrice.runtime.java.modelbase.EventWithDataMessage;");
        stringConcatenation.newLine();
        stringConcatenation.append("import org.eclipse.etrice.runtime.java.modelbase.IInterfaceItemOwner;");
        stringConcatenation.newLine();
        stringConcatenation.append("import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBase;");
        stringConcatenation.newLine();
        stringConcatenation.append("import org.eclipse.etrice.runtime.java.modelbase.PortBase;");
        stringConcatenation.newLine();
        stringConcatenation.append("import org.eclipse.etrice.runtime.java.modelbase.ReplicatedPortBase;");
        stringConcatenation.newLine();
        boolean bl = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl) {
            stringConcatenation.append("import org.eclipse.etrice.runtime.java.debugging.DebuggingService;");
            stringConcatenation.newLine();
        }
        stringConcatenation.append("import static org.eclipse.etrice.runtime.java.etunit.EtUnit.*;");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        CharSequence charSequence2 = this._procedureHelpers.userCode(pc, 1);
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        EList models = root.getReferencedModels((RoomClass)pc);
        stringConcatenation.newLineIfNotEmpty();
        for (RoomModel model : models) {
            stringConcatenation.append("import ");
            charSequence = model.getName();
            stringConcatenation.append(charSequence);
            stringConcatenation.append(".*;");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        stringConcatenation.append("public class ");
        String string3 = pc.getName();
        stringConcatenation.append(string3);
        stringConcatenation.append(" {");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append("// message IDs");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        String string4 = this.genMessageIDs(pc);
        stringConcatenation.append(string4, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        charSequence = this._procedureHelpers.userCode(pc, 2);
        stringConcatenation.append((Object)charSequence, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("private static String messageStrings[] = {\"MIN\", ");
        Object object = this._roomHelpers.getAllOutgoingMessages(pc);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Message m = (Message)iterator.next();
            stringConcatenation.append("\"");
            string = m.getName();
            stringConcatenation.append(string, "\t");
            stringConcatenation.append("\",");
        }
        stringConcatenation.append(" ");
        object = this._roomHelpers.getAllIncomingMessages(pc);
        iterator = object.iterator();
        while (iterator.hasNext()) {
            Message m_1 = (Message)iterator.next();
            stringConcatenation.append("\"");
            string = m_1.getName();
            stringConcatenation.append(string, "\t");
            stringConcatenation.append("\",");
        }
        stringConcatenation.append("\"MAX\"};");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("public String getMessageString(int msg_id) {");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("if (msg_id<MSG_MIN || msg_id>MSG_MAX+1){");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t\t");
        stringConcatenation.append("// id out of range");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t\t");
        stringConcatenation.append("return \"Message ID out of range\";");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("else{");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t\t");
        stringConcatenation.append("return messageStrings[msg_id];");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        object = this.portClass(pc, false);
        stringConcatenation.append(object, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        CharSequence charSequence3 = this.portClass(pc, true);
        stringConcatenation.append((Object)charSequence3, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    public CharSequence portClass(ProtocolClass pc, boolean conj) {
        CharSequence charSequence;
        Object object;
        Object object2;
        boolean bl;
        CharSequence charSequence2;
        StringConcatenation stringConcatenation = null;
        PortClass pclass = this._roomExtensions.getPortClass(pc, conj);
        String portClassName = this._roomExtensions.getPortClassName(pc, conj);
        String replPortClassName = this._roomExtensions.getPortClassName(pc, conj, true);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.newLine();
        stringConcatenation2.append("// port class");
        stringConcatenation2.newLine();
        stringConcatenation2.append("static public class ");
        stringConcatenation2.append(portClassName);
        stringConcatenation2.append(" extends PortBase {");
        stringConcatenation2.newLineIfNotEmpty();
        if (pclass != null) {
            stringConcatenation2.append("\t");
            charSequence2 = this._procedureHelpers.userCode(pclass.getUserCode());
            stringConcatenation2.append((Object)charSequence2, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// constructors");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public ");
        stringConcatenation2.append(portClassName, "\t");
        stringConcatenation2.append("(IInterfaceItemOwner actor, String name, int localId) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("this(actor, name, localId, 0);");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public ");
        stringConcatenation2.append(portClassName, "\t");
        stringConcatenation2.append("(IInterfaceItemOwner actor, String name, int localId, int idx) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("super(actor, name, localId, idx);");
        stringConcatenation2.newLine();
        if (pclass != null) {
            stringConcatenation2.append("\t\t");
            charSequence2 = this._initialization.attributeInitialization((List<Attribute>)pclass.getAttributes(), (EObject)pclass, true);
            stringConcatenation2.append((Object)charSequence2, "\t\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        if (bl = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings())) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("DebuggingService.getInstance().addPortInstance(this);");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        bl = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl) {
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("public void destroy() {");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("DebuggingService.getInstance().removePortInstance(this);");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("super.destroy();");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("@Override");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public void receive(Message m) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("if (!(m instanceof EventMessage))");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("return;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("EventMessage msg = (EventMessage) m;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("if (0 < msg.getEvtId() && msg.getEvtId() < MSG_MAX) {");
        stringConcatenation2.newLine();
        bl = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl) {
            stringConcatenation2.append("\t\t\t");
            stringConcatenation2.append("DebuggingService.getInstance().addMessageAsyncIn(getPeerAddress(), getAddress(), messageStrings[msg.getEvtId()]);");
            stringConcatenation2.newLine();
        }
        if (bl = this._roomExtensions.handlesReceive(pc, conj)) {
            stringConcatenation2.append("\t\t\t");
            stringConcatenation2.append("switch (msg.getEvtId()) {");
            stringConcatenation2.newLine();
            object2 = this._roomExtensions.getReceiveHandlers(pc, conj);
            object = object2.iterator();
            while (object.hasNext()) {
                MessageHandler hdlr = (MessageHandler)object.next();
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("case ");
                charSequence = this._roomExtensions.getCodeName(hdlr.getMsg());
                stringConcatenation2.append(charSequence, "\t\t\t\t");
                stringConcatenation2.append(":");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("{");
                stringConcatenation2.newLine();
                EList eList = hdlr.getDetailCode().getLines();
                for (String command : eList) {
                    stringConcatenation2.append("\t\t\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append(command, "\t\t\t\t\t");
                    stringConcatenation2.newLineIfNotEmpty();
                }
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("break;");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("default:");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("if (msg instanceof EventWithDataMessage)");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t\t");
        stringConcatenation2.append("getActor().receiveEvent(this, msg.getEvtId(), ((EventWithDataMessage)msg).getData());");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("else");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t\t");
        stringConcatenation2.append("getActor().receiveEvent(this, msg.getEvtId(), null);");
        stringConcatenation2.newLine();
        bl = this._roomExtensions.handlesReceive(pc, conj);
        if (bl) {
            stringConcatenation2.append("\t\t\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        if (pclass != null) {
            stringConcatenation2.append("\t");
            CharSequence charSequence3 = this._procedureHelpers.attributes((List)pclass.getAttributes());
            stringConcatenation2.append((Object)charSequence3, "\t");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            object2 = this._procedureHelpers.attributeSettersGettersImplementation((List)pclass.getAttributes(), null);
            stringConcatenation2.append(object2, "\t");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            Iterator iterator = this._procedureHelpers.operationsImplementation((List)pclass.getOperations(), portClassName);
            stringConcatenation2.append((Object)iterator, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// sent messages");
        stringConcatenation2.newLine();
        List list = this._roomHelpers.getAllMessages(pc, conj);
        for (Message m : list) {
            stringConcatenation2.append("\t");
            object = this.sendMessage(m, conj);
            stringConcatenation2.append(object, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("// replicated port class");
        stringConcatenation2.newLine();
        stringConcatenation2.append("static public class ");
        stringConcatenation2.append(replPortClassName);
        stringConcatenation2.append(" extends ReplicatedPortBase {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public ");
        stringConcatenation2.append(replPortClassName, "\t");
        stringConcatenation2.append("(IInterfaceItemOwner actor, String name, int localId) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("super(actor, name, localId);");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public int getReplication() {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("return getNInterfaceItems();");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public int getIndexOf(InterfaceItemBase ifitem){");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("return ifitem.getIdx();");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public ");
        stringConcatenation2.append(portClassName, "\t");
        stringConcatenation2.append(" get(int idx) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("return (");
        stringConcatenation2.append(portClassName, "\t\t");
        stringConcatenation2.append(") getInterfaceItem(idx);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("protected InterfaceItemBase createInterfaceItem(IInterfaceItemOwner rcv, String name, int lid, int idx) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("return new ");
        stringConcatenation2.append(portClassName, "\t\t");
        stringConcatenation2.append("(rcv, name, lid, idx);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        if (conj) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("// incoming messages");
            stringConcatenation2.newLine();
            list = this._roomHelpers.getAllIncomingMessages(pc);
            for (Message m_1 : list) {
                stringConcatenation2.append("\t");
                object = this.messageSignature(m_1);
                stringConcatenation2.append(object, "\t");
                stringConcatenation2.append("{");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("for (InterfaceItemBase item : getItems()) {");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("((");
                stringConcatenation2.append(portClassName, "\t\t\t");
                stringConcatenation2.append(")item).");
                charSequence = this.messageCall(m_1);
                stringConcatenation2.append((Object)charSequence, "\t\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
        } else {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("// outgoing messages");
            stringConcatenation2.newLine();
            list = this._roomHelpers.getAllOutgoingMessages(pc);
            for (Message m_2 : list) {
                stringConcatenation2.append("\t");
                object = this.messageSignature(m_2);
                stringConcatenation2.append(object, "\t");
                stringConcatenation2.append("{");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("for (InterfaceItemBase item : getItems()) {");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("((");
                stringConcatenation2.append(portClassName, "\t\t\t");
                stringConcatenation2.append(")item).");
                charSequence = this.messageCall(m_2);
                stringConcatenation2.append((Object)charSequence, "\t\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    public CharSequence messageSignature(Message m) {
        boolean bl;
        StringConcatenation stringConcatenation = new StringConcatenation();
        boolean bl2 = m.isPriv();
        if (bl2) {
            stringConcatenation.append("private");
        } else {
            stringConcatenation.append("public");
        }
        stringConcatenation.append(" void ");
        String string = m.getName();
        stringConcatenation.append(string);
        stringConcatenation.append("(");
        MessageData messageData = m.getData();
        boolean bl3 = bl = messageData != null;
        if (bl) {
            String string2 = this._typeHelpers.typeName(m.getData().getRefType().getType());
            stringConcatenation.append(string2);
            stringConcatenation.append(" ");
            stringConcatenation.append("transitionData");
        }
        stringConcatenation.append(")");
        return stringConcatenation;
    }

    public CharSequence messageSignatureExplicit(Message m) {
        StringConcatenation stringConcatenation = null;
        DataType dataType = m.getData().getRefType().getType();
        DataClass dc = (DataClass)dataType;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("public void ");
        String string = m.getName();
        stringConcatenation2.append(string);
        stringConcatenation2.append("(");
        String string2 = this._dataClassGen.argList(dc);
        stringConcatenation2.append(string2);
        stringConcatenation2.append(")");
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    public CharSequence messageCall(Message m) {
        boolean bl;
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = m.getName();
        stringConcatenation.append(string);
        stringConcatenation.append("(");
        MessageData messageData = m.getData();
        boolean bl2 = bl = messageData != null;
        if (bl) {
            stringConcatenation.append(" ");
            stringConcatenation.append("transitionData");
        }
        stringConcatenation.append(")");
        return stringConcatenation;
    }

    public CharSequence sendMessage(Message m, boolean conj) {
        Object object;
        Object object2;
        StringConcatenation stringConcatenation = null;
        String string = null;
        string = conj ? "IN" : "OUT";
        String dir = string;
        MessageHandler hdlr = this._roomExtensions.getSendHandler(m, conj);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        CharSequence charSequence = this.messageSignature(m);
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.append(" {");
        stringConcatenation2.newLineIfNotEmpty();
        if (hdlr != null) {
            stringConcatenation2.append("\t");
            object2 = hdlr.getDetailCode().getLines();
            for (String command : object2) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append(command, "\t");
                stringConcatenation2.newLineIfNotEmpty();
            }
        } else {
            boolean bl;
            boolean bl2 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (bl2) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("DebuggingService.getInstance().addMessageAsyncOut(getAddress(), getPeerAddress(), messageStrings[");
                stringConcatenation2.append(dir, "\t");
                stringConcatenation2.append("_");
                String string2 = m.getName();
                stringConcatenation2.append(string2, "\t");
                stringConcatenation2.append("]);");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("if (getPeerAddress()!=null)");
            stringConcatenation2.newLine();
            object2 = m.getData();
            boolean bl3 = bl = object2 == null;
            if (bl) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("getPeerMsgReceiver().receive(new EventMessage(getPeerAddress(), ");
                stringConcatenation2.append(dir, "\t\t");
                stringConcatenation2.append("_");
                object = m.getName();
                stringConcatenation2.append((String)object, "\t\t");
                stringConcatenation2.append("));");
                stringConcatenation2.newLineIfNotEmpty();
            } else {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("getPeerMsgReceiver().receive(new EventWithDataMessage(getPeerAddress(), ");
                stringConcatenation2.append(dir, "\t\t");
                stringConcatenation2.append("_");
                object = m.getName();
                stringConcatenation2.append((String)object, "\t\t");
                stringConcatenation2.append(", ");
                stringConcatenation2.append("transitionData", "\t\t");
                if (!m.getData().getRefType().isRef() && !this._typeHelpers.isEnumerationOrPrimitive(m.getData().getRefType().getType())) {
                    stringConcatenation2.append(".deepCopy()");
                }
                stringConcatenation2.append("));");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        if (m.getData() != null && m.getData().getRefType().getType() instanceof DataClass) {
            object2 = this.messageSignatureExplicit(m);
            stringConcatenation2.append(object2);
            stringConcatenation2.append(" {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            String string3 = m.getName();
            stringConcatenation2.append(string3, "\t");
            stringConcatenation2.append("(new ");
            object = m.getData().getRefType().getType().getName();
            stringConcatenation2.append((String)object, "\t");
            stringConcatenation2.append("(");
            DataType dataType = m.getData().getRefType().getType();
            String string4 = this._dataClassGen.paramList((DataClass)dataType);
            stringConcatenation2.append(string4, "\t");
            stringConcatenation2.append("));");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    public CharSequence generateDataDriven(Root root, ProtocolClass pc) {
        String string;
        String string2;
        String string3;
        String string4;
        Object object;
        String string5;
        String string6;
        Object object2;
        String string7;
        StringConcatenation stringConcatenation = null;
        Functions.Function1 function1 = m -> {
            MessageData messageData = m.getData();
            return messageData != null;
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)this._roomHelpers.getAllIncomingMessages(pc), (Functions.Function1)function1);
        EList models = root.getReferencedModels((RoomClass)pc);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("package ");
        String string8 = this._roomExtensions.getPackage((RoomClass)pc);
        stringConcatenation2.append(string8);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.messaging.IRTObject;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.DataReceivePort;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.DataSendPort;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import static org.eclipse.etrice.runtime.java.etunit.EtUnit.*;");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence = this._procedureHelpers.userCode(pc, 1);
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        for (RoomModel model : models) {
            stringConcatenation2.append("import ");
            string7 = model.getName();
            stringConcatenation2.append(string7);
            stringConcatenation2.append(".*;");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("public class ");
        String string9 = pc.getName();
        stringConcatenation2.append(string9);
        stringConcatenation2.append(" {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        CharSequence charSequence2 = this._procedureHelpers.userCode(pc, 2);
        stringConcatenation2.append((Object)charSequence2, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// send port holds data");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("static public class ");
        string7 = this._roomExtensions.getPortClassName(pc, true);
        stringConcatenation2.append(string7, "\t");
        stringConcatenation2.append(" extends DataSendPort {");
        stringConcatenation2.newLineIfNotEmpty();
        for (Message msg : sentMsgs) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("private ");
            object2 = this._typeHelpers.typeName(msg.getData().getRefType().getType());
            stringConcatenation2.append((String)object2, "\t\t");
            stringConcatenation2.append(" ");
            string6 = msg.getName();
            stringConcatenation2.append(string6, "\t\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// constructor");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("public ");
        String string10 = this._roomExtensions.getPortClassName(pc, true);
        stringConcatenation2.append(string10, "\t\t");
        stringConcatenation2.append("(IRTObject parent, String name, int localId) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("super(parent, name, localId);");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// getters and setters");
        stringConcatenation2.newLine();
        for (Message msg_1 : sentMsgs) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("public void ");
            string6 = msg_1.getName();
            stringConcatenation2.append(string6, "\t\t");
            stringConcatenation2.append("(");
            string5 = this._typeHelpers.typeName(msg_1.getData().getRefType().getType());
            stringConcatenation2.append(string5, "\t\t");
            stringConcatenation2.append(" ");
            object = msg_1.getName();
            stringConcatenation2.append((String)object, "\t\t");
            stringConcatenation2.append(") {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("this.");
            string4 = msg_1.getName();
            stringConcatenation2.append(string4, "\t\t\t");
            stringConcatenation2.append(" = ");
            string3 = msg_1.getName();
            stringConcatenation2.append(string3, "\t\t\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("public ");
            string2 = this._typeHelpers.typeName(msg_1.getData().getRefType().getType());
            stringConcatenation2.append(string2, "\t\t");
            stringConcatenation2.append(" ");
            string = msg_1.getName();
            stringConcatenation2.append(string, "\t\t");
            stringConcatenation2.append("() {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("return ");
            String string11 = msg_1.getName();
            stringConcatenation2.append(string11, "\t\t\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// receive port accesses send port");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("static public class ");
        String string12 = this._roomExtensions.getPortClassName(pc, false);
        stringConcatenation2.append(string12, "\t");
        stringConcatenation2.append(" extends DataReceivePort {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("private ");
        object2 = this._roomExtensions.getPortClassName(pc, true);
        stringConcatenation2.append((String)object2, "\t\t");
        stringConcatenation2.append(" peer;");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// constructor");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("public ");
        string6 = this._roomExtensions.getPortClassName(pc, false);
        stringConcatenation2.append(string6, "\t\t");
        stringConcatenation2.append("(IRTObject parent, String name, int localId) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("super(parent, name, localId);");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// getters");
        stringConcatenation2.newLine();
        for (Message msg_2 : sentMsgs) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("public ");
            string4 = this._typeHelpers.typeName(msg_2.getData().getRefType().getType());
            stringConcatenation2.append(string4, "\t\t");
            stringConcatenation2.append(" ");
            string3 = msg_2.getName();
            stringConcatenation2.append(string3, "\t\t");
            stringConcatenation2.append("() {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("if (peer==null)");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("return ");
            string2 = this._javaExtensions.defaultValue(msg_2.getData().getRefType().getType());
            stringConcatenation2.append(string2, "\t\t\t\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("return peer.");
            string = msg_2.getName();
            stringConcatenation2.append(string, "\t\t\t");
            stringConcatenation2.append("();");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("protected void connect(DataSendPort dataSendPort) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("if (dataSendPort instanceof ");
        string5 = this._roomExtensions.getPortClassName(pc, true);
        stringConcatenation2.append(string5, "\t\t\t");
        stringConcatenation2.append(")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t\t\t");
        stringConcatenation2.append("peer = (");
        object = this._roomExtensions.getPortClassName(pc, true);
        stringConcatenation2.append((String)object, "\t\t\t\t");
        stringConcatenation2.append(")dataSendPort;");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }
}

