/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.KeyValue;
import org.eclipse.etrice.core.common.base.Literal;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.SimpleState;
import org.eclipse.etrice.core.fsm.fSM.TransitionPoint;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.util.InterfaceContractHelpers;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.Pair;

public class InterfaceContractValidator
extends AbstractDeclarativeValidator {
    @Inject
    RoomHelpers roomHelpers;
    @Inject
    InterfaceContractHelpers contractMonitorHelpers;

    @Check
    public void checkProtocolContract(ProtocolClass pc) {
        if (!this.contractMonitorHelpers.hasContract(pc)) {
            return;
        }
        ActorClass contract = this.contractMonitorHelpers.getInterfaceContractActorClass(pc);
        Optional<KeyValue> attr = pc.getAnnotations().stream().map(anno -> anno.getAttributes()).flatMap(Collection::stream).filter(anno -> "definedBy".equals(anno.getKey())).findFirst();
        if (contract == null || contract.eIsProxy()) {
            if (attr.isPresent()) {
                this.error("Couldn't resolve ActorClass '" + this.toSafeString(attr.get().getValue()) + "' - try with fully qualified name", (EObject)attr.get(), null);
            }
        } else if (!this.contractMonitorHelpers.isContract(contract) && attr.isPresent()) {
            this.error("ActorClass '" + contract.getName() + "' is missing annotation '@InterfaceContractDefinition'", (EObject)attr.get(), null);
        }
    }

    @Check
    public void checkContract(ActorClass ac) {
        Optional<KeyValue> genNameAttr;
        Optional<KeyValue> attr;
        if (!this.contractMonitorHelpers.isContract(ac)) {
            return;
        }
        Annotation annotation = ac.getAnnotations().stream().filter(anno -> "InterfaceContractDefinition".equals(anno.getType().getName())).findFirst().get();
        ProtocolClass protocol = this.contractMonitorHelpers.getContractProtocol(ac);
        if ((protocol == null || protocol.eIsProxy()) && (attr = ac.getAnnotations().stream().map(anno -> anno.getAttributes()).flatMap(Collection::stream).filter(anno -> "protocol".equals(anno.getKey())).findFirst()).isPresent()) {
            this.error("Couldn't resolve ProtocolClass '" + this.toSafeString(attr.get().getValue()) + "' - try with fully qualified name", (EObject)attr.get(), null);
        }
        Pair<List<Port>, List<Port>> ports = this.contractMonitorHelpers.getContractPorts(ac, protocol);
        boolean portsOk = false;
        if (protocol != null && !protocol.eIsProxy()) {
            if (((List)ports.getKey()).size() != 1 && ((List)ports.getValue()).size() != 1) {
                this.error("ActorClass '" + ac.getName() + "' must have exactly one regular and conjugated end-port for '" + protocol.getName() + "'", (EObject)annotation, null);
            } else {
                portsOk = true;
            }
        }
        if ((genNameAttr = ac.getAnnotations().stream().map(anno -> anno.getAttributes()).flatMap(Collection::stream).filter(anno -> "generatedMonitorName".equals(anno.getKey())).findFirst()).isPresent()) {
            String name = this.toSafeString(genNameAttr.get().getValue());
            if (name.contains(".")) {
                this.error("monitor name must be without namespace", (EObject)genNameAttr.get(), null);
            } else if (name.isEmpty() || !name.matches("[a-zA-Z_]([\\w_])*")) {
                this.error("not a valid ID", (EObject)genNameAttr.get(), null);
            }
        }
        if (portsOk && ac.getStateMachine() != null) {
            ac.getStateMachine().eContents().stream().forEach(elem -> {
                if (elem instanceof TriggeredTransition) {
                    TriggeredTransition tr = (TriggeredTransition)elem;
                    if (tr.getTriggers().size() > 1) {
                        this.error("For contracts multiple triggers are not supported", (EObject)elem, (EStructuralFeature)FSMPackage.Literals.TRIGGERED_TRANSITION__TRIGGERS);
                    } else if (tr.getTriggers().size() == 1 && ((Trigger)tr.getTriggers().get(0)).getMsgFromIfPairs().size() > 1) {
                        this.error("For contracts trigger can have only single message", (EObject)tr.getTriggers().get(0), null);
                    }
                } else if (!(elem instanceof InitialTransition)) {
                    if (elem instanceof SimpleState) {
                        SimpleState state = (SimpleState)elem;
                        if (state.getSubgraph() != null) {
                            this.error("For contracts sub graphs are not supported", (EObject)state.getSubgraph(), null);
                        }
                    } else if (elem instanceof TransitionPoint) {
                        if (!((TransitionPoint)elem).isHandler()) {
                            this.error("For contracts transition point must be handler", (EObject)elem, null);
                        }
                    } else {
                        this.error("For contracts not supported", (EObject)elem, null);
                    }
                }
            });
        }
    }

    private String toSafeString(Literal literal) {
        return literal != null ? this.roomHelpers.literalToString(literal) : "null";
    }

    public void register(EValidatorRegistrar registrar) {
    }
}

