/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.compose.Union;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphMapLink;
import org.apache.jena.sparql.core.DatasetGraphReadOnly;
import org.apache.jena.sparql.core.DatasetGraphWrapperView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphOps;
import org.apache.jena.sparql.graph.GraphUnionRead;
import org.apache.jena.sparql.util.NodeUtils;

public class DynamicDatasets {
    public static Dataset dynamicDataset(DatasetDescription description, Dataset ds, boolean defaultUnionGraph) {
        DatasetGraph dsg2;
        DatasetGraph dsg = ds.asDatasetGraph();
        if (dsg == (dsg2 = DynamicDatasets.dynamicDataset(description, dsg, defaultUnionGraph))) {
            return ds;
        }
        return DatasetFactory.wrap(dsg2);
    }

    public static DatasetGraph dynamicDataset(DatasetDescription description, DatasetGraph dsg, boolean defaultUnionGraph) {
        if (description == null) {
            return dsg;
        }
        if (description.isEmpty()) {
            return dsg;
        }
        Set<Node> defaultGraphs = NodeUtils.convertToSetNodes(description.getDefaultGraphURIs());
        Set<Node> namedGraphs = NodeUtils.convertToSetNodes(description.getNamedGraphURIs());
        return DynamicDatasets.dynamicDataset(defaultGraphs, namedGraphs, dsg, defaultUnionGraph);
    }

    public static DatasetGraph dynamicDataset(Collection<Node> defaultGraphs, Collection<Node> namedGraphs, DatasetGraph dsg, boolean defaultUnionGraph) {
        Graph dft = defaultUnionGraph || defaultGraphs.contains(Quad.unionGraph) ? (defaultGraphs.contains(Quad.defaultGraphIRI) ? new Union(dsg.getUnionGraph(), dsg.getDefaultGraph()) : dsg.getUnionGraph()) : new GraphUnionRead(dsg, defaultGraphs);
        DatasetGraph dsg2 = new DatasetGraphMapLink(dft);
        for (Node gn : namedGraphs) {
            Graph g;
            if (Quad.isUnionGraph(gn) || (g = GraphOps.getGraph(dsg, gn)) == null) continue;
            dsg2.addGraph(gn, g);
        }
        if (dsg.getContext() != null) {
            dsg2.getContext().putAll(dsg.getContext());
        }
        dsg2 = new DynamicDatasetGraph(dsg2, dsg);
        dsg2.getContext().set(ARQConstants.symDatasetDefaultGraphs, defaultGraphs);
        dsg2.getContext().set(ARQConstants.symDatasetNamedGraphs, namedGraphs);
        return dsg2;
    }

    public static class DynamicDatasetGraph
    extends DatasetGraphReadOnly
    implements DatasetGraphWrapperView {
        private final DatasetGraph original;

        public DynamicDatasetGraph(DatasetGraph viewDSG, DatasetGraph originalDSG) {
            super(viewDSG, originalDSG.getContext().copy());
            this.original = Objects.requireNonNull(originalDSG);
        }

        public DatasetGraph getOriginal() {
            return this.original;
        }

        public Collection<Node> getOriginalDefaultGraphs() {
            return (Collection)this.getContext().get(ARQConstants.symDatasetDefaultGraphs);
        }

        public Collection<Node> getOriginalNamedGraphs() {
            return (Collection)this.getContext().get(ARQConstants.symDatasetNamedGraphs);
        }
    }
}

