/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmlinput0;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdf.model.impl.RDFDefaultErrorHandler;
import org.apache.jena.rdfxml.xmlinput0.JenaHandler;
import org.apache.jena.rdfxml.xmlinput0.RDFXMLReader0;
import org.apache.jena.rdfxml.xmlinput0.SAX2RDF;
import org.apache.jena.shared.JenaException;
import org.xml.sax.SAXParseException;

public class SAX2Model
extends SAX2RDF {
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    private final JenaHandler handler;
    private boolean closed = false;

    public static SAX2Model create(String base, Model m) throws SAXParseException {
        return new SAX2Model(base, m, "");
    }

    public static SAX2Model create(String base, Model m, String lang) throws SAXParseException {
        return new SAX2Model(base, m, lang);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXParseException {
        super.startPrefixMapping(prefix, uri);
    }

    protected SAX2Model(String base, Model m, String lang) throws SAXParseException {
        super(base, lang);
        this.handler = this.initHandler(m);
    }

    private JenaHandler initHandler(Model m) {
        if (m == null) {
            return null;
        }
        JenaHandler rslt = new JenaHandler(m, this.errorHandler);
        rslt.useWith(this.getHandlers());
        return rslt;
    }

    @Override
    public void close() {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        if (this.handler != null) {
            this.handler.setErrorHandler(errHandler);
        }
        return old;
    }

    public Object setProperty(String str2, Object value) throws JenaException {
        Object obj = value;
        if (str2.startsWith("http:") && str2.startsWith("http://jena.hpl.hp.com/arp/properties/")) {
            str2 = str2.substring(RDFXMLReader0.arpPropertiesURLLength);
        }
        return this.setArpProperty(str2, obj);
    }

    private Object setArpProperty(String str2, Object v) {
        return RDFXMLReader0.processArpOptions(this.getOptions(), str2, v, this.errorHandler);
    }
}

