/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecore.delegates.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epsilon.ecore.delegates.DelegateLabelProvider;
import org.eclipse.epsilon.ecore.delegates.EvlDelegateContext;
import org.eclipse.epsilon.ecore.delegates.ExeedLabelProvider;
import org.eclipse.epsilon.ecore.delegates.execution.EvlConstraint;
import org.eclipse.epsilon.ecore.delegates.validation.EpsilonValidationDelegate;
import org.eclipse.epsilon.emc.emf.InMemoryEmfModel;
import org.eclipse.epsilon.eol.models.IModel;

public class EvlValidationDelegate
implements EpsilonValidationDelegate {
    private final Map<Resource, InMemoryEmfModel> models = new HashMap<Resource, InMemoryEmfModel>();
    private final Map<String, EvlConstraint> programs = new HashMap<String, EvlConstraint>();
    private final Set<Target> errors = new HashSet<Target>();
    private final EvlDelegateContext delegateContext;
    private final DelegateLabelProvider labelProvider;

    public EvlValidationDelegate(EvlDelegateContext delegateContext, DelegateLabelProvider labelProvider) {
        this.delegateContext = delegateContext;
        this.labelProvider = labelProvider;
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, EOperation invariant, String expression) {
        return this.validate(eClass, eObject, context, invariant.getName(), expression);
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, String constraint, String expression) {
        Target target = new Target(constraint, eObject);
        if (this.errors.contains(target)) {
            return false;
        }
        EvlConstraint program = this.programs.computeIfAbsent(constraint, c -> (EvlConstraint)this.delegateContext.parse(this.toEvlContext(expression, eObject.eClass().getName(), (String)c)));
        this.addLabelProvider(context);
        try {
            Object result = program.execute(eObject, (IModel)this.models.computeIfAbsent(eObject.eResource(), r -> new InMemoryEmfModel(r)));
            return !((Optional)result).isPresent();
        }
        catch (Throwable e) {
            this.errors.add(target);
            throw new IllegalStateException(e);
        }
    }

    public boolean validate(EDataType eDataType, Object value, Map<Object, Object> context, String constraint, String expression) {
        return true;
    }

    @Override
    public void reset() {
        this.errors.clear();
        this.models.clear();
        this.programs.clear();
    }

    private String toEvlContext(String expression, String context, String constraint) {
        StringBuilder result = new StringBuilder();
        result.append("context ");
        result.append(context);
        result.append("{");
        result.append("constraint ");
        result.append(constraint);
        result.append("{");
        result.append("check: ");
        result.append(expression);
        result.append("}");
        result.append("}");
        return result.toString();
    }

    private void addLabelProvider(Map<Object, Object> context) {
        EValidator.SubstitutionLabelProvider delegate = null;
        if (context.containsKey(EValidator.SubstitutionLabelProvider.class)) {
            delegate = (EValidator.SubstitutionLabelProvider)context.get(EValidator.SubstitutionLabelProvider.class);
            if (delegate instanceof ExeedLabelProvider) {
                return;
            }
            context.put(EValidator.SubstitutionLabelProvider.class, this.labelProvider.delegate(delegate));
        } else {
            context.put(EValidator.SubstitutionLabelProvider.class, this.labelProvider);
        }
    }

    private class Target {
        private final String constraint;
        private final Object eObject;

        public Target(String constraint, Object eObject) {
            this.constraint = constraint;
            this.eObject = eObject;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + Objects.hash(this.constraint, this.eObject);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Target other = (Target)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return Objects.equals(this.constraint, other.constraint) && Objects.equals(this.eObject, other.eObject);
        }

        private EvlValidationDelegate getEnclosingInstance() {
            return EvlValidationDelegate.this;
        }
    }
}

