/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Font_variant implements Enumerator
{
    NORMAL(0, "normal", "normal"),
    SMALL_CAPS(1, "small_caps", "small-caps"),
    INHERIT(2, "inherit", "inherit");

    public static final int NORMAL_VALUE = 0;
    public static final int SMALL_CAPS_VALUE = 1;
    public static final int INHERIT_VALUE = 2;
    private static final Font_variant[] VALUES_ARRAY;
    public static final List<Font_variant> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Font_variant[]{NORMAL, SMALL_CAPS, INHERIT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Font_variant get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Font_variant result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Font_variant getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Font_variant result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Font_variant get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return SMALL_CAPS;
            }
            case 2: {
                return INHERIT;
            }
        }
        return null;
    }

    private Font_variant(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

