/**
 * *******************************************************************************
 * Copyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Steve Monnier OBEO - Initial API and implementation
 *         
 * SPDX-License-Identifier: EPL-1.0    
 * *******************************************************************************
 */
package org.eclipse.apogy.core.programs.javascript.impl;

import org.eclipse.apogy.core.programs.javascript.*;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.apogy.core.programs.javascript.impl.ApogyJavaScriptFacadeCustomImpl;
import org.eclipse.apogy.core.programs.javascript.impl.JavaScriptProgramRuntimeCustomImpl;
import org.eclipse.apogy.core.programs.javascript.impl.JavaScriptProgramFactoryCustomImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ApogyCoreJavaScriptProgramsFactoryImpl extends EFactoryImpl implements ApogyCoreJavaScriptProgramsFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ApogyCoreJavaScriptProgramsFactory init() {
		try {
			ApogyCoreJavaScriptProgramsFactory theApogyCoreJavaScriptProgramsFactory = (ApogyCoreJavaScriptProgramsFactory)EPackage.Registry.INSTANCE.getEFactory(ApogyCoreJavaScriptProgramsPackage.eNS_URI);
			if (theApogyCoreJavaScriptProgramsFactory != null) {
				return theApogyCoreJavaScriptProgramsFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new ApogyCoreJavaScriptProgramsFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ApogyCoreJavaScriptProgramsFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case ApogyCoreJavaScriptProgramsPackage.APOGY_JAVA_SCRIPT_FACADE: return createApogyJavaScriptFacade();
			case ApogyCoreJavaScriptProgramsPackage.JAVA_SCRIPT_PROGRAM: return createJavaScriptProgram();
			case ApogyCoreJavaScriptProgramsPackage.JAVA_SCRIPT_PROGRAM_RUNTIME: return createJavaScriptProgramRuntime();
			case ApogyCoreJavaScriptProgramsPackage.JAVA_SCRIPT_PROGRAM_FACTORY: return createJavaScriptProgramFactory();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ApogyJavaScriptFacade createApogyJavaScriptFacade() {
		ApogyJavaScriptFacadeImpl apogyJavaScriptFacade = new ApogyJavaScriptFacadeCustomImpl();
		return apogyJavaScriptFacade;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JavaScriptProgram createJavaScriptProgram() {
		JavaScriptProgramImpl javaScriptProgram = new JavaScriptProgramImpl();
		return javaScriptProgram;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JavaScriptProgramRuntime createJavaScriptProgramRuntime() {
		JavaScriptProgramRuntimeImpl javaScriptProgramRuntime = new JavaScriptProgramRuntimeCustomImpl();
		return javaScriptProgramRuntime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JavaScriptProgramFactory createJavaScriptProgramFactory() {
		JavaScriptProgramFactoryImpl javaScriptProgramFactory = new JavaScriptProgramFactoryCustomImpl();
		return javaScriptProgramFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ApogyCoreJavaScriptProgramsPackage getApogyCoreJavaScriptProgramsPackage() {
		return (ApogyCoreJavaScriptProgramsPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static ApogyCoreJavaScriptProgramsPackage getPackage() {
		return ApogyCoreJavaScriptProgramsPackage.eINSTANCE;
	}

} //ApogyCoreJavaScriptProgramsFactoryImpl
