/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.topic;

import com.google.common.base.Preconditions;
import org.ros.internal.transport.ConnectionHeader;
import org.ros.namespace.GraphName;

public class TopicIdentifier {
    private final GraphName name;

    public static TopicIdentifier forName(String name) {
        return new TopicIdentifier(GraphName.of(name));
    }

    public TopicIdentifier(GraphName name) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((boolean)name.isGlobal());
        this.name = name;
    }

    public ConnectionHeader toConnectionHeader() {
        ConnectionHeader connectionHeader = new ConnectionHeader();
        connectionHeader.addField("topic", this.name.toString());
        return connectionHeader;
    }

    public GraphName getName() {
        return this.name;
    }

    public String toString() {
        return "TopicIdentifier<" + this.name + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicIdentifier other = (TopicIdentifier)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

