/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.topic;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.internal.node.topic.TopicDeclaration;
import org.ros.internal.node.topic.TopicIdentifier;
import org.ros.internal.transport.ConnectionHeader;
import org.ros.namespace.GraphName;

public class PublisherIdentifier {
    private final NodeIdentifier nodeIdentifier;
    private final TopicIdentifier topicIdentifier;

    public static Collection<PublisherIdentifier> newCollectionFromUris(Collection<URI> publisherUris, TopicDeclaration topicDeclaration) {
        HashSet publishers = Sets.newHashSet();
        for (URI uri : publisherUris) {
            NodeIdentifier nodeIdentifier = new NodeIdentifier(null, uri);
            publishers.add(new PublisherIdentifier(nodeIdentifier, topicDeclaration.getIdentifier()));
        }
        return publishers;
    }

    public static PublisherIdentifier newFromStrings(String nodeName, String uri, String topicName) {
        return new PublisherIdentifier(NodeIdentifier.forNameAndUri(nodeName, uri), TopicIdentifier.forName(topicName));
    }

    public PublisherIdentifier(NodeIdentifier nodeIdentifier, TopicIdentifier topicIdentifier) {
        Preconditions.checkNotNull((Object)nodeIdentifier);
        Preconditions.checkNotNull((Object)topicIdentifier);
        this.nodeIdentifier = nodeIdentifier;
        this.topicIdentifier = topicIdentifier;
    }

    public ConnectionHeader toConnectionHeader() {
        ConnectionHeader connectionHeader = new ConnectionHeader();
        connectionHeader.merge(this.nodeIdentifier.toConnectionHeader());
        connectionHeader.merge(this.topicIdentifier.toConnectionHeader());
        return connectionHeader;
    }

    public NodeIdentifier getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public GraphName getNodeName() {
        return this.nodeIdentifier.getName();
    }

    public URI getNodeUri() {
        return this.nodeIdentifier.getUri();
    }

    public TopicIdentifier getTopicIdentifier() {
        return this.topicIdentifier;
    }

    public GraphName getTopicName() {
        return this.topicIdentifier.getName();
    }

    public String toString() {
        return "PublisherIdentifier<" + this.nodeIdentifier + ", " + this.topicIdentifier + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.nodeIdentifier.hashCode();
        result = 31 * result + this.topicIdentifier.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PublisherIdentifier other = (PublisherIdentifier)obj;
        if (!this.nodeIdentifier.equals(other.nodeIdentifier)) {
            return false;
        }
        return this.topicIdentifier.equals(other.topicIdentifier);
    }
}

