/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.service;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.ros.exception.ServiceException;
import org.ros.internal.message.MessageBufferPool;
import org.ros.internal.node.service.ServiceDeclaration;
import org.ros.internal.node.service.ServiceServerResponse;
import org.ros.message.MessageDeserializer;
import org.ros.message.MessageFactory;
import org.ros.message.MessageSerializer;
import org.ros.node.service.ServiceResponseBuilder;

class ServiceRequestHandler<T, S>
extends SimpleChannelHandler {
    private final ServiceDeclaration serviceDeclaration;
    private final ServiceResponseBuilder<T, S> responseBuilder;
    private final MessageDeserializer<T> deserializer;
    private final MessageSerializer<S> serializer;
    private final MessageFactory messageFactory;
    private final ExecutorService executorService;
    private final MessageBufferPool messageBufferPool;

    public ServiceRequestHandler(ServiceDeclaration serviceDeclaration, ServiceResponseBuilder<T, S> responseBuilder, MessageDeserializer<T> deserializer, MessageSerializer<S> serializer, MessageFactory messageFactory, ExecutorService executorService) {
        this.serviceDeclaration = serviceDeclaration;
        this.deserializer = deserializer;
        this.serializer = serializer;
        this.responseBuilder = responseBuilder;
        this.messageFactory = messageFactory;
        this.executorService = executorService;
        this.messageBufferPool = new MessageBufferPool();
    }

    private void handleRequest(ChannelBuffer requestBuffer, ChannelBuffer responseBuffer) throws ServiceException {
        Object request = this.deserializer.deserialize(requestBuffer);
        Object response = this.messageFactory.newFromType(this.serviceDeclaration.getType());
        this.responseBuilder.build(request, response);
        this.serializer.serialize(response, responseBuffer);
    }

    private void handleSuccess(ChannelHandlerContext ctx, ServiceServerResponse response, ChannelBuffer responseBuffer) {
        response.setErrorCode(1);
        response.setMessageLength(responseBuffer.readableBytes());
        response.setMessage(responseBuffer);
        ctx.getChannel().write((Object)response);
    }

    private void handleError(ChannelHandlerContext ctx, ServiceServerResponse response, String message) {
        response.setErrorCode(0);
        ByteBuffer encodedMessage = Charset.forName("US-ASCII").encode(message);
        response.setMessageLength(encodedMessage.limit());
        response.setMessage(ChannelBuffers.wrappedBuffer((ByteBuffer)encodedMessage));
        ctx.getChannel().write((Object)response);
    }

    public void messageReceived(final ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        final ChannelBuffer requestBuffer = ((ChannelBuffer)e.getMessage()).copy();
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                boolean success;
                ServiceServerResponse response = new ServiceServerResponse();
                ChannelBuffer responseBuffer = ServiceRequestHandler.this.messageBufferPool.acquire();
                try {
                    ServiceRequestHandler.this.handleRequest(requestBuffer, responseBuffer);
                    success = true;
                }
                catch (ServiceException ex) {
                    ServiceRequestHandler.this.handleError(ctx, response, ex.getMessage());
                    success = false;
                }
                if (success) {
                    ServiceRequestHandler.this.handleSuccess(ctx, response, responseBuffer);
                }
                ServiceRequestHandler.this.messageBufferPool.release(responseBuffer);
            }
        });
        super.messageReceived(ctx, e);
    }
}

