/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBuffer;
import org.ros.exception.RosRuntimeException;
import org.ros.internal.message.MessageBufferPool;
import org.ros.internal.node.service.ServiceClientHandshakeHandler;
import org.ros.internal.node.service.ServiceDeclaration;
import org.ros.internal.transport.ClientHandshakeListener;
import org.ros.internal.transport.ConnectionHeader;
import org.ros.internal.transport.tcp.TcpClient;
import org.ros.internal.transport.tcp.TcpClientManager;
import org.ros.message.MessageDeserializer;
import org.ros.message.MessageFactory;
import org.ros.message.MessageSerializer;
import org.ros.namespace.GraphName;
import org.ros.node.service.ServiceClient;
import org.ros.node.service.ServiceResponseListener;

public class DefaultServiceClient<T, S>
implements ServiceClient<T, S> {
    private final ServiceDeclaration serviceDeclaration;
    private final MessageSerializer<T> serializer;
    private final MessageFactory messageFactory;
    private final MessageBufferPool messageBufferPool;
    private final Queue<ServiceResponseListener<S>> responseListeners;
    private final ConnectionHeader connectionHeader;
    private final TcpClientManager tcpClientManager;
    private final HandshakeLatch handshakeLatch;
    private TcpClient tcpClient;

    public static <S, T> DefaultServiceClient<S, T> newDefault(GraphName nodeName, ServiceDeclaration serviceDeclaration, MessageSerializer<S> serializer, MessageDeserializer<T> deserializer, MessageFactory messageFactory, ScheduledExecutorService executorService) {
        return new DefaultServiceClient<S, T>(nodeName, serviceDeclaration, serializer, deserializer, messageFactory, executorService);
    }

    private DefaultServiceClient(GraphName nodeName, ServiceDeclaration serviceDeclaration, MessageSerializer<T> serializer, MessageDeserializer<S> deserializer, MessageFactory messageFactory, ScheduledExecutorService executorService) {
        this.serviceDeclaration = serviceDeclaration;
        this.serializer = serializer;
        this.messageFactory = messageFactory;
        this.messageBufferPool = new MessageBufferPool();
        this.responseListeners = Lists.newLinkedList();
        this.connectionHeader = new ConnectionHeader();
        this.connectionHeader.addField("callerid", nodeName.toString());
        this.connectionHeader.addField("persistent", "1");
        this.connectionHeader.merge(serviceDeclaration.toConnectionHeader());
        this.tcpClientManager = new TcpClientManager(executorService);
        ServiceClientHandshakeHandler serviceClientHandshakeHandler = new ServiceClientHandshakeHandler(this.connectionHeader, this.responseListeners, deserializer, executorService);
        this.handshakeLatch = new HandshakeLatch();
        serviceClientHandshakeHandler.addListener(this.handshakeLatch);
        this.tcpClientManager.addNamedChannelHandler(serviceClientHandshakeHandler);
    }

    @Override
    public void connect(URI uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"URI must be specified.");
        Preconditions.checkArgument((boolean)uri.getScheme().equals("rosrpc"), (Object)"Invalid service URI.");
        Preconditions.checkState((this.tcpClient == null ? 1 : 0) != 0, (Object)"Already connected.");
        InetSocketAddress address = new InetSocketAddress(uri.getHost(), uri.getPort());
        this.handshakeLatch.reset();
        this.tcpClient = this.tcpClientManager.connect(this.toString(), address);
        try {
            if (!this.handshakeLatch.await(1L, TimeUnit.SECONDS)) {
                throw new RosRuntimeException(this.handshakeLatch.getErrorMessage());
            }
        }
        catch (InterruptedException e) {
            throw new RosRuntimeException("Handshake timed out.");
        }
    }

    @Override
    public void shutdown() {
        this.tcpClientManager.shutdown();
    }

    @Override
    public void call(T request, ServiceResponseListener<S> listener) {
        ChannelBuffer buffer = this.messageBufferPool.acquire();
        this.serializer.serialize(request, buffer);
        this.responseListeners.add(listener);
        this.tcpClient.write(buffer).awaitUninterruptibly();
        this.messageBufferPool.release(buffer);
    }

    @Override
    public GraphName getName() {
        return this.serviceDeclaration.getName();
    }

    public String toString() {
        return "ServiceClient<" + this.serviceDeclaration + ">";
    }

    @Override
    public T newMessage() {
        return (T)this.messageFactory.newFromType(this.serviceDeclaration.getType());
    }

    @Override
    public boolean isConnected() {
        return this.tcpClient.getChannel().isConnected();
    }

    private final class HandshakeLatch
    implements ClientHandshakeListener {
        private CountDownLatch latch;
        private boolean success;
        private String errorMessage;

        private HandshakeLatch() {
        }

        @Override
        public void onSuccess(ConnectionHeader outgoingConnectionHeader, ConnectionHeader incomingConnectionHeader) {
            this.success = true;
            this.latch.countDown();
        }

        @Override
        public void onFailure(ConnectionHeader outgoingConnectionHeader, String errorMessage) {
            this.errorMessage = errorMessage;
            this.success = false;
            this.latch.countDown();
        }

        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            this.latch.await(timeout, unit);
            return this.success;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void reset() {
            this.latch = new CountDownLatch(1);
            this.success = false;
            this.errorMessage = null;
        }
    }
}

