/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.response;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ros.internal.node.response.ResultFactory;
import org.ros.master.client.SystemState;
import org.ros.master.client.TopicSystemState;

public class SystemStateResultFactory
implements ResultFactory<SystemState> {
    @Override
    public SystemState newFromValue(Object value) {
        Object[] vals = (Object[])value;
        Map<String, Set<String>> publisherMap = this.getPublishers(vals[0]);
        Map<String, Set<String>> subscriberMap = this.getSubscribers(vals[1]);
        HashMap topics = Maps.newHashMap();
        for (Map.Entry<String, Set<String>> publisherData : publisherMap.entrySet()) {
            String topicName = publisherData.getKey();
            HashSet subscriberNodes = subscriberMap.remove(topicName);
            if (subscriberNodes == null) {
                subscriberNodes = Sets.newHashSet();
            }
            topics.put(topicName, new TopicSystemState(topicName, publisherData.getValue(), subscriberNodes));
        }
        for (Map.Entry<String, Set<String>> subscriberData : subscriberMap.entrySet()) {
            HashSet noPublishers = Sets.newHashSet();
            String topicName = subscriberData.getKey();
            topics.put(topicName, new TopicSystemState(topicName, noPublishers, subscriberData.getValue()));
        }
        return new SystemState(topics.values());
    }

    private Map<String, Set<String>> getPublishers(Object pubPairs) {
        HashMap topicToPublishers = Maps.newHashMap();
        for (Object topicData : Arrays.asList((Object[])pubPairs)) {
            Object[] publisherData;
            String topicName = (String)((Object[])topicData)[0];
            HashSet publishers = Sets.newHashSet();
            Object[] objectArray = publisherData = (Object[])((Object[])topicData)[1];
            int n = publisherData.length;
            int n2 = 0;
            while (n2 < n) {
                Object publisher = objectArray[n2];
                publishers.add(publisher.toString());
                ++n2;
            }
            topicToPublishers.put(topicName, publishers);
        }
        return topicToPublishers;
    }

    private Map<String, Set<String>> getSubscribers(Object subPairs) {
        HashMap topicToSubscribers = Maps.newHashMap();
        for (Object topicData : Arrays.asList((Object[])subPairs)) {
            Object[] subscriberData;
            String topicName = (String)((Object[])topicData)[0];
            HashSet subscribers = Sets.newHashSet();
            Object[] objectArray = subscriberData = (Object[])((Object[])topicData)[1];
            int n = subscriberData.length;
            int n2 = 0;
            while (n2 < n) {
                Object subscriber = objectArray[n2];
                subscribers.add(subscriber.toString());
                ++n2;
            }
            topicToSubscribers.put(topicName, subscribers);
        }
        return topicToSubscribers;
    }
}

